/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension.structure.dungeon;

import com.robertx22.library_of_exile.database.mob_list.MobList;
import com.robertx22.library_of_exile.database.mob_list.MobListTags;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonRoom;
import com.robertx22.library_of_exile.dimension.structure.dungeon.RoomType;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.tags.ExileTagRequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DungeonData {
    public String folder = "";
    public ExileTagRequirement<MobList> mob_list_tag_check = new ExileTagRequirement().createBuilder().includes(MobListTags.MAP).build();
    public List<String> entrances = new ArrayList<String>();
    public List<String> four_ways = new ArrayList<String>();
    public List<String> straight_hallways = new ArrayList<String>();
    public List<String> curved_hallways = new ArrayList<String>();
    public List<String> triple_hallway = new ArrayList<String>();
    public List<String> ends = new ArrayList<String>();
    private transient List<DungeonRoom> rooms = new ArrayList<DungeonRoom>();

    public boolean checkValidity(ExileRegistry reg) {
        for (RoomType type : RoomType.values()) {
            if (!this.getRoomList(type).isEmpty()) continue;
            ExileLog.get().warn("Dungeons must have rooms of each type! " + reg.getRegistryIdPlusGuid() + " is missing " + type.name() + " rooms", new Object[0]);
            return false;
        }
        return true;
    }

    public List<DungeonRoom> getRooms() {
        if (this.rooms.isEmpty()) {
            this.addRooms(RoomType.ENTRANCE, this.entrances);
            this.addRooms(RoomType.FOUR_WAY, this.four_ways);
            this.addRooms(RoomType.STRAIGHT_HALLWAY, this.straight_hallways);
            this.addRooms(RoomType.CURVED_HALLWAY, this.curved_hallways);
            this.addRooms(RoomType.TRIPLE_HALLWAY, this.triple_hallway);
            this.addRooms(RoomType.END, this.ends);
        }
        return this.rooms;
    }

    public List<DungeonRoom> getRoomsOfType(RoomType type) {
        return this.getRooms().stream().filter(x -> x.type.equals(type)).collect(Collectors.toList());
    }

    public List<String> getRoomList(RoomType type) {
        if (type == RoomType.END) {
            return this.ends;
        }
        if (type == RoomType.ENTRANCE) {
            return this.entrances;
        }
        if (type == RoomType.FOUR_WAY) {
            return this.four_ways;
        }
        if (type == RoomType.CURVED_HALLWAY) {
            return this.curved_hallways;
        }
        if (type == RoomType.STRAIGHT_HALLWAY) {
            return this.straight_hallways;
        }
        if (type == RoomType.TRIPLE_HALLWAY) {
            return this.triple_hallway;
        }
        return Arrays.asList(new String[0]);
    }

    private void addRooms(RoomType type, List<String> list) {
        for (String room : list) {
            DungeonRoom b = new DungeonRoom(this.folder, room, type);
            this.rooms.add(b);
        }
    }

    public final boolean hasRoomFor(RoomType type) {
        return this.getRooms().stream().anyMatch(x -> x.type.equals(type));
    }
}

