/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.localization;

import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.ITranslated;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.tags.tag_types.RegistryTag;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringEscapeUtils;

public class ExileLangFile {
    public static HashMap<String, HashMap<String, ExileTranslation>> all = new HashMap();

    private static void gatherAll(String modid) {
        Iterator tra;
        ArrayList<ITranslated> gathered = new ArrayList<ITranslated>();
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof ITranslated)) continue;
            tra = (ITranslated)item;
            gathered.add((ITranslated)((Object)tra));
        }
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof ITranslated)) continue;
            tra = (ITranslated)block;
            gathered.add((ITranslated)((Object)tra));
        }
        for (MobEffect mobEffect : ForgeRegistries.MOB_EFFECTS) {
            if (!(mobEffect instanceof ITranslated)) continue;
            tra = (ITranslated)mobEffect;
            gathered.add((ITranslated)((Object)tra));
        }
        for (ExileRegistryContainer exileRegistryContainer : Database.getAllRegistries()) {
            for (ExileRegistry o : exileRegistryContainer.getAllIncludingSeriazable()) {
                if (!(o instanceof ITranslated)) continue;
                ITranslated tra2 = (ITranslated)((Object)o);
                gathered.add(tra2);
            }
        }
        for (Map.Entry entry : RegistryTag.MAP.entrySet()) {
            for (RegistryTag tag : (List)entry.getValue()) {
                gathered.add(tag);
            }
        }
        for (ITranslated iTranslated : gathered) {
            TranslationBuilder b = iTranslated.createTranslationBuilder();
            if (b.modid == null) {
                System.out.println(iTranslated.GUID() + " has null modid");
                continue;
            }
            if (!b.modid.equals(modid)) continue;
            b.build();
        }
    }

    public static String createJsonForModid(String modid, String extraManual) {
        ExileLangFile.gatherAll(modid);
        Object json = "{\n";
        json = (String)json + extraManual;
        List sorted = all.get(modid).values().stream().sorted(Comparator.comparing(x -> x.key)).collect(Collectors.toList());
        for (ExileTranslation tra : sorted) {
            json = (String)json + "\t\"" + tra.key + "\": \"" + StringEscapeUtils.escapeJava((String)tra.locname) + "\",\n";
        }
        json = (String)json + "\n}";
        json = ExileLangFile.replaceLast((String)json, ",", "");
        return json;
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }

    public static void createFile(String modid, String extraManual) {
        try {
            String json = ExileLangFile.createJsonForModid(modid, extraManual);
            String path = ExileLangFile.langFilePath(modid);
            if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                Files.createFile(Paths.get(path, new String[0]), new FileAttribute[0]);
            }
            File file = new File(path);
            FileWriter fw = new FileWriter(file);
            fw.write(json);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String modDir() {
        return FMLPaths.GAMEDIR.get().toString().replace("run", "src");
    }

    static String langFolderDir(String modid) {
        return ExileLangFile.modDir() + "/main/resources/assets/" + modid + "/lang/";
    }

    static String langFilePath(String modid) {
        return ExileLangFile.langFolderDir(modid) + "en_us.json";
    }
}

