/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.main;

import com.robertx22.library_of_exile.components.EntityInfoComponent;
import com.robertx22.library_of_exile.components.PlayerCapabilities;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.CommonInit;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ApiForgeEvents {
    public static <T extends Event> void registerForgeEvent(Class<T> clazz, Consumer<T> event, EventPriority priority) {
        if (IModBusEvent.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(IModBusEvent.class)) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(priority, event);
        } else {
            MinecraftForge.EVENT_BUS.addListener(priority, event);
        }
    }

    public static <T extends Event> void registerForgeEvent(Class<T> clazz, Consumer<T> event) {
        ApiForgeEvents.registerForgeEvent(clazz, event, EventPriority.NORMAL);
    }

    public static void register() {
        ApiForgeEvents.registerForgeEvent(LivingAttackEvent.class, event -> {
            ExileEvents.OnDamageEntity after = ExileEvents.DAMAGE_BEFORE_CALC.callEvents(new ExileEvents.OnDamageEntity(event.getSource(), event.getAmount(), event.getEntity()));
            if (after.canceled) {
                event.setCanceled(true);
            }
        }, EventPriority.HIGHEST);
        ApiForgeEvents.registerForgeEvent(LivingDamageEvent.class, event -> {
            ExileEvents.OnDamageEntity after = ExileEvents.DAMAGE_AFTER_CALC.callEvents(new ExileEvents.OnDamageEntity(event.getSource(), event.getAmount(), event.getEntity()));
            event.setAmount(after.damage);
        }, EventPriority.LOWEST);
        ApiForgeEvents.registerForgeEvent(EntityJoinLevelEvent.class, event -> {
            Entity patt2810$temp = event.getEntity();
            if (patt2810$temp instanceof LivingEntity) {
                LivingEntity en = (LivingEntity)patt2810$temp;
                EntityInfoComponent.get(en).spawnInit((Entity)en);
            }
        });
        ApiForgeEvents.registerForgeEvent(LivingEvent.LivingTickEvent.class, event -> {
            LivingEntity entity = event.getEntity();
            if (entity.f_19797_ == 20) {
                EntityInfoComponent.get(entity).spawnInit((Entity)entity);
            }
            ExileEvents.LIVING_ENTITY_TICK.callEvents(new ExileEvents.OnEntityTick(entity));
        });
        ApiForgeEvents.registerForgeEvent(LivingDeathEvent.class, event -> {
            if (!(event.getEntity() instanceof Player) && event.getSource().m_7639_() instanceof LivingEntity) {
                ExileEvents.MOB_DEATH.callEvents(new ExileEvents.OnMobDeath(event.getEntity(), (LivingEntity)event.getSource().m_7639_()));
            }
        });
        ApiForgeEvents.registerForgeEvent(PlayerEvent.Clone.class, event -> {
            PlayerCapabilities.saveAllOnDeath(event);
            PlayerCapabilities.syncAllToClient(event.getEntity());
        });
        ApiForgeEvents.registerForgeEvent(ServerStartedEvent.class, event -> CommonInit.onDatapacksReloaded());
        ApiForgeEvents.registerForgeEvent(AddReloadListenerEvent.class, event -> CommonInit.onDatapacksReloaded());
    }
}

