/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.google.common.base.Preconditions;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.main.LibraryOfExile;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.packets.registry.EfficientRegistryPacket;
import com.robertx22.library_of_exile.registry.DataGenKey;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.FilterListWrap;
import com.robertx22.library_of_exile.registry.register_info.ExileRegistrationInfo;
import com.robertx22.library_of_exile.registry.register_info.RegistrationInfoData;
import com.robertx22.library_of_exile.utils.RandomUtils;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ExileRegistryContainer<C extends ExileRegistry> {
    private List<String> registersErrorsAlertedFor = new ArrayList<String>();
    private List<String> accessorErrosAletedFor = new ArrayList<String>();
    private List<String> emptyRegistries = new ArrayList<String>();
    public HashMap<String, RegistrationInfoData> registrationInfo = new HashMap();
    private boolean dataPacksAreRegistered = true;
    boolean isDatapack = false;
    private HashMap<String, C> serializables = new HashMap();
    List<C> fromDatapacks = null;
    FriendlyByteBuf cachedBuf = null;
    private ExileRegistryType type;
    private String emptyDefault;
    private HashMap<String, C> map = new HashMap();
    private boolean errorIfEmpty = true;
    private boolean logAdditionsToRegistry = false;
    private boolean logMissingEntryOnAccess = true;
    boolean accessedEarly = false;

    public ExileRegistryContainer<C> setIsDatapack() {
        this.dataPacksAreRegistered = false;
        this.isDatapack = true;
        return this;
    }

    public List<C> getSerializable() {
        return new ArrayList<C>(this.serializables.values());
    }

    public void sendUpdatePacket(ServerPlayer player) {
        if (this.type.ser == null) {
            return;
        }
        if (LibraryOfExile.DISABLE_DATABASE_DATAPACK_FEATURE) {
            return;
        }
        Preconditions.checkNotNull((Object)this.cachedBuf, (Object)(this.type.id + " error, cachedbuf is null!!!"));
        Packets.sendToClient((Player)player, new EfficientRegistryPacket<C>(this.type, Database.getRegistry(this.type).getFromDatapacks()));
    }

    public void onAllDatapacksLoaded() {
        this.fromDatapacks = null;
        this.getFromDatapacks();
        if (this.fromDatapacks != null && !this.fromDatapacks.isEmpty()) {
            this.cachedBuf = new FriendlyByteBuf(Unpooled.buffer());
            new EfficientRegistryPacket<C>(this.type, Database.getRegistry(this.type).getFromDatapacks()).saveToData(this.cachedBuf);
            Preconditions.checkNotNull((Object)this.cachedBuf);
        }
    }

    public List<C> getFromDatapacks() {
        if (this.fromDatapacks == null) {
            this.fromDatapacks = this.getList().stream().filter(x -> x.isFromDatapack()).collect(Collectors.toList());
        }
        return this.fromDatapacks;
    }

    public ExileRegistryType getType() {
        return this.type;
    }

    public static void logRegistryError(String text) {
        try {
            throw new Exception("[Mine and Slash Registry Error]: " + text);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public C getDefault() {
        return (C)((ExileRegistry)this.map.getOrDefault(this.emptyDefault, null));
    }

    public ExileRegistryContainer logAdditions() {
        this.logAdditionsToRegistry = true;
        return this;
    }

    public void unRegister(ExileRegistry entry) {
        if (this.map.containsKey(entry.GUID())) {
            this.map.remove(entry.GUID());
        }
    }

    public ExileRegistryContainer dontErrorMissingEntriesOnAccess() {
        this.logMissingEntryOnAccess = false;
        return this;
    }

    public ExileRegistryContainer dontErrorIfEmpty() {
        this.errorIfEmpty = false;
        return this;
    }

    public int getSize() {
        return this.map.size();
    }

    public boolean isRegistrationDone() {
        return this.getSize() > 0;
    }

    public ExileRegistryContainer(ExileRegistryType type, String emptyDefault) {
        this.type = type;
        this.emptyDefault = emptyDefault;
    }

    private void tryLogEmptyRegistry() {
        if (this.errorIfEmpty && this.map.isEmpty() && this.dataPacksAreRegistered && this.emptyRegistries.contains(this.type.id)) {
            this.emptyRegistries.add(this.type.id);
            ExileRegistryContainer.logRegistryError("Exile Registry of type: " + this.type.toString() + " is empty, this is really bad!");
        }
    }

    public HashMap<String, C> getAll() {
        this.tryLogEmptyRegistry();
        return this.map;
    }

    public List<C> getList() {
        if (!this.map.isEmpty()) {
            return new ArrayList<C>(this.map.values());
        }
        this.tryLogEmptyRegistry();
        return Arrays.asList(new ExileRegistry[0]);
    }

    public List<C> getAllIncludingSeriazable() {
        ArrayList<C> list = new ArrayList<C>(this.map.values());
        list.addAll(this.serializables.values());
        return list;
    }

    public C getFromSerializables(DataGenKey<C> key) {
        return (C)((ExileRegistry)this.serializables.get(key.GUID()));
    }

    public C getFromSerializables(String key) {
        return (C)((ExileRegistry)this.serializables.get(key));
    }

    public C get(String guid) {
        if (this.map.isEmpty() && this.serializables.isEmpty()) {
            if (!this.accessedEarly) {
                throw new RuntimeException("\n Accessed slash registry earlier than datapacks are loaded, returning empty: " + guid + "\n");
            }
            this.accessedEarly = true;
            return this.getDefault();
        }
        this.tryLogEmptyRegistry();
        if (guid == null || guid.isEmpty()) {
            return this.getDefault();
        }
        if (this.map.containsKey(guid)) {
            return (C)((ExileRegistry)this.map.get(guid));
        }
        if (this.serializables.containsKey(guid)) {
            return (C)((ExileRegistry)this.serializables.get(guid));
        }
        if (this.logMissingEntryOnAccess && !this.accessorErrosAletedFor.contains(guid)) {
            ExileRegistryContainer.logRegistryError("GUID Error: " + guid + " of type: " + this.type.id + " doesn't exist. This is either a removed/renamed old registry, or robertx22 forgot to include it in an update.");
            this.accessorErrosAletedFor.add(guid);
        }
        return this.getDefault();
    }

    public FilterListWrap<C> getWrapped() {
        return new FilterListWrap<C>(this.map.values());
    }

    public FilterListWrap<C> getFilterWrapped(Predicate<C> pred) {
        return new FilterListWrap<C>(this.getFiltered(pred));
    }

    public List<C> getFiltered(Predicate<C> predicate) {
        return this.getList().stream().filter(predicate).collect(Collectors.toList());
    }

    public C random() {
        return (C)((ExileRegistry)RandomUtils.weightedRandom(this.getList()));
    }

    public C random(Double randomDouble) {
        return (C)((ExileRegistry)RandomUtils.weightedRandom(this.getList(), randomDouble));
    }

    public boolean isRegistered(C c) {
        return this.isRegistered(c.GUID());
    }

    public boolean isRegistered(String guid) {
        return this.map.containsKey(guid);
    }

    public Optional<C> getOptional(String guid) {
        if (this.isRegistered(guid)) {
            return Optional.of(this.get(guid));
        }
        return Optional.empty();
    }

    public boolean isExistingSeriazable(String guid) {
        return this.map.containsKey(guid);
    }

    public void register(C c, ExileRegistrationInfo info) {
        Preconditions.checkNotNull((Object)info);
        if (this.isRegistered(c)) {
            if (!this.registersErrorsAlertedFor.contains(c.GUID())) {
                ExileRegistryContainer.logRegistryError("Key: " + c.GUID() + " has already been registered to: " + c.getExileRegistryType().toString() + " registry.");
                this.registersErrorsAlertedFor.add(c.GUID());
            }
        } else {
            this.tryLogAddition(c);
            this.map.put(c.GUID(), c);
            if (!this.registrationInfo.containsKey(c.GUID())) {
                this.registrationInfo.put(c.GUID(), new RegistrationInfoData());
            }
            this.registrationInfo.get(c.GUID()).onRegister(info);
            ExileEvents.ON_REGISTER_TO_DATABASE.callEvents(new ExileEvents.OnRegisterToDatabase(c, this.type));
        }
    }

    private void tryLogAddition(C c) {
    }

    public void addSerializable(C entry, ExileRegistrationInfo info) {
        if (this.serializables.containsKey(entry.GUID())) {
            ExileLog.get().warn("Entry of type: " + entry.getExileRegistryType().id + " already exists as seriazable: " + entry.GUID(), new Object[0]);
        }
        this.serializables.put(entry.GUID(), entry);
        this.unRegister((ExileRegistry)entry);
        this.register(entry, info);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

