/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.register_info.ExileRegistrationInfo;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public interface JsonExileRegistry<T>
extends ExileRegistry<T> {
    public static final HashMap<ExileRegistryType, Set<String>> INVALID_JSONS_MAP = new HashMap();
    public static final HashMap<ExileRegistryType, Set<ResourceLocation>> NOT_LOADED_JSONS_MAP = new HashMap();
    public static final ExileLog LOGGER = ExileLog.get();

    default public void addToSerializables(ExileRegistrationInfo info) {
        Database.getRegistry(this.getExileRegistryType()).addSerializable(this, info);
    }

    public static void addToInvalidJsons(ExileRegistryType type, String id) {
        if (!INVALID_JSONS_MAP.containsKey(type)) {
            INVALID_JSONS_MAP.put(type, new HashSet());
        }
        INVALID_JSONS_MAP.get(type).add(id);
    }

    public static void addToErroredJsons(ExileRegistryType type, ResourceLocation id) {
        if (!NOT_LOADED_JSONS_MAP.containsKey(type)) {
            NOT_LOADED_JSONS_MAP.put(type, new HashSet());
        }
        NOT_LOADED_JSONS_MAP.get(type).add(id);
    }

    @Override
    default public void compareLoadedJsonAndFinalClass(JsonObject json, Boolean editmode) {
        JsonExileRegistry jsonExileRegistry = this;
        if (jsonExileRegistry instanceof ISerializable) {
            JsonElement v2;
            ISerializable ser = (ISerializable)((Object)jsonExileRegistry);
            JsonObject after = ser.toJson();
            if (editmode.booleanValue()) {
                for (Map.Entry en : new HashSet(after.entrySet())) {
                    if (!json.has((String)en.getKey())) continue;
                    after.remove((String)en.getKey());
                }
                return;
            }
            JsonElement v1 = JsonParser.parseString((String)json.toString());
            if (!v1.equals(v2 = JsonParser.parseString((String)after.toString()))) {
                LOGGER.warn("============[" + this.getExileRegistryType().getModName() + " Datapack Check Failed]=================", new Object[0]);
                LOGGER.warn("The file with id " + this.getRegistryIdPlusGuid() + " is different after loading", new Object[0]);
                LOGGER.warn("Json from your datapack:", new Object[0]);
                LOGGER.warn(json.toString(), new Object[0]);
                LOGGER.warn("Json after it was loaded and turned back into json:", new Object[0]);
                LOGGER.warn(after.toString(), new Object[0]);
                LOGGER.warn("Please check for things like wrong field names, missing fields, wrong types used etc.", new Object[0]);
                LOGGER.warn("You can copy and paste these jsons into any online Json Comparison/Diff tools see what the difference is. Like: www.jsondiff.com", new Object[0]);
                LOGGER.warn("===================================================================", new Object[0]);
                JsonExileRegistry.addToInvalidJsons(this.getExileRegistryType(), this.GUID());
            }
        }
    }

    @Override
    default public boolean isFromDatapack() {
        return true;
    }
}

