/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.orbs_of_crafting.main;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.robertx22.library_of_exile.command_wrapper.CommandBuilder;
import com.robertx22.library_of_exile.command_wrapper.PermWrapper;
import com.robertx22.library_of_exile.command_wrapper.PlayerWrapper;
import com.robertx22.library_of_exile.command_wrapper.RegistryWrapper;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.orbs_of_crafting.misc.LocReqContext;
import com.robertx22.orbs_of_crafting.misc.ResultItem;
import com.robertx22.orbs_of_crafting.misc.StackHolder;
import com.robertx22.orbs_of_crafting.register.ExileCurrency;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;

public class OrbCommands {
    public static String ID = "orbs_of_crafting";

    public static void init() {
        ApiForgeEvents.registerForgeEvent(RegisterCommandsEvent.class, event -> {
            CommandDispatcher dis = event.getDispatcher();
            CommandBuilder.of(ID, dis, x -> {
                PlayerWrapper PLAYER = new PlayerWrapper();
                RegistryWrapper CURRENCY = new RegistryWrapper(LibDatabase.CURRENCY);
                x.addLiteral("orb", PermWrapper.OP);
                x.addLiteral("use", PermWrapper.OP);
                x.addArg(PLAYER);
                x.addArg(CURRENCY);
                x.action(e -> {
                    Player p = (Player)PLAYER.get((CommandContext<CommandSourceStack>)e);
                    ExileCurrency mod = (ExileCurrency)CURRENCY.getFromRegistry((CommandContext)e);
                    ItemStack stack = p.m_21205_();
                    LocReqContext ctx = new LocReqContext(p, stack, mod.getItem().m_7968_());
                    ExplainedResult ex = mod.canItemBeModified(ctx);
                    if (ex.can) {
                        ResultItem res = mod.modifyItem(ctx);
                        p.m_8061_(EquipmentSlot.MAINHAND, res.stack.m_41777_());
                    } else {
                        p.m_213846_(ex.answer);
                    }
                });
            }, "Tries to apply an item currency to the item in player's hand.");
            CommandBuilder.of(ID, dis, x -> {
                PlayerWrapper PLAYER = new PlayerWrapper();
                RegistryWrapper MOD = new RegistryWrapper(LibDatabase.ITEM_MOD);
                x.addLiteral("item_mod", PermWrapper.OP);
                x.addLiteral("use", PermWrapper.OP);
                x.addArg(PLAYER);
                x.addArg(MOD);
                x.action(e -> {
                    ItemModificationResult res = new ItemModificationResult();
                    Player p = (Player)PLAYER.get((CommandContext<CommandSourceStack>)e);
                    ItemModification mod = (ItemModification)MOD.getFromRegistry((CommandContext)e);
                    ItemStack stack = p.m_21205_();
                    StackHolder ex = new StackHolder(stack);
                    mod.applyMod(p, ex, res);
                    res.onFinish(p);
                    p.m_8061_(EquipmentSlot.MAINHAND, ex.stack);
                    p.m_213846_((Component)Component.m_237113_((String)"Applied Item Modification from Command").m_130940_(ChatFormatting.GREEN));
                });
            }, "Applies an item modification to the item in player's hand.");
        });
    }
}

