/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.catchers;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.handler.TickHandler;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelChunk.class})
public abstract class WorldChunkMixin {
    @Shadow
    @Nullable
    public abstract BlockEntity m_7702_(BlockPos var1);

    @Inject(method={"removeBlockEntity"}, at={@At(value="HEAD")})
    private void removeErrored(BlockPos pos, CallbackInfo ci) {
        BlockEntity blockEntity = this.m_7702_(pos);
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        if (tickHandler.isErrored(blockEntity)) {
            tickHandler.removeErrored(blockEntity);
        }
    }

    @Mixin(targets={"net.minecraft.world.chunk.WorldChunk$DirectBlockEntityTickInvoker"})
    private static abstract class DirectBlockEntityTickInvokerMixin {
        private DirectBlockEntityTickInvokerMixin() {
        }

        @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/BlockEntityTicker;tick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/BlockEntity;)V")})
        private void catchTickingBlockEntity$notTheCauseOfTickLag(BlockEntityTicker<? extends BlockEntity> instance, Level world, BlockPos pos, BlockState state, BlockEntity blockEntity, Operation<Void> original) {
            Neruina.getInstance().getTickHandler().safelyTickBlockEntity(instance, world, pos, state, blockEntity, original);
        }
    }
}

