/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.railwayteam.railways.content.fuel.tank.FuelTankBlock;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.registry.forge.CRBlockEntitiesImpl;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FuelTankItem
extends BlockItem {
    public FuelTankItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult m_40576_(@NotNull BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean m_7274_(@NotNull BlockPos blockPos, Level level, Player player, @NotNull ItemStack itemStack, @NotNull BlockState blockState) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = itemStack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            FluidStack fluid;
            nbt.m_128473_("Luminosity");
            nbt.m_128473_("Size");
            nbt.m_128473_("Height");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
            if (nbt.m_128441_("TankContent") && !(fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("TankContent"))).isEmpty()) {
                fluid.setAmount(Math.min(FuelTankBlockEntity.getCapacityMultiplier(), fluid.getAmount()));
                nbt.m_128365_("TankContent", (Tag)fluid.writeToNBT(new CompoundTag()));
            }
        }
        return super.m_7274_(blockPos, level, player, itemStack, blockState);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        if (!face.m_122434_().m_122478_()) {
            return;
        }
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockState placedOnState = world.m_8055_(placedOnPos = (pos = ctx.m_8083_()).m_121945_(face.m_122424_()));
        if (!FuelTankBlock.isTank(placedOnState)) {
            return;
        }
        FuelTankBlockEntity tankAt = (FuelTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CRBlockEntitiesImpl.FUEL_TANK.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        if (tankAt == null) {
            return;
        }
        FuelTankBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = controllerBE.width;
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerBE.m_58899_().m_7495_() : controllerBE.m_58899_().m_6630_(controllerBE.height);
        if (startPos.m_123342_() != pos.m_123342_()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (FuelTankBlock.isTank(blockState)) continue;
                if (!blockState.m_247087_()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (FuelTankBlock.isTank(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceTankSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceTankSound");
            }
        }
    }
}

