/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.railwayteam.railways.content.coupling.TrainUtils;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;

public class SplitTrainCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"split_train").requires(cs -> cs.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"train_id", (ArgumentType)UuidArgument.m_113850_()).executes(ctx -> {
            UUID trainId = UuidArgument.m_113853_((CommandContext)ctx, (String)"train_id");
            return SplitTrainCommand.execute((CommandContext<CommandSourceStack>)ctx, trainId, 1);
        })).then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            UUID trainId = UuidArgument.m_113853_((CommandContext)ctx, (String)"train_id");
            int number = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"number");
            return SplitTrainCommand.execute((CommandContext<CommandSourceStack>)ctx, trainId, number);
        })))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"train_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"train_name");
            UUID trainId = Create.RAILWAYS.trains.values().stream().filter(t -> t.name.getString().equals(name)).findFirst().map(t -> t.id).orElse(null);
            return SplitTrainCommand.execute((CommandContext<CommandSourceStack>)ctx, trainId, 1);
        })).then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"train_name");
            UUID trainId = Create.RAILWAYS.trains.values().stream().filter(t -> t.name.getString().equals(name)).findFirst().map(t -> t.id).orElse(null);
            int number = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"number");
            return SplitTrainCommand.execute((CommandContext<CommandSourceStack>)ctx, trainId, number);
        })));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, UUID trainId, int numberOffEnd) {
        if (trainId == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No trains were found."));
            return 0;
        }
        Train train = (Train)Create.RAILWAYS.trains.get(trainId);
        if (train == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No Train with id " + trainId.toString().substring(0, 5) + "[...] was found")));
            return 0;
        }
        try {
            TrainUtils.splitTrain(train, numberOffEnd);
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to split train: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Train '").m_7220_(train.name).m_130946_("' split successfully"), true);
        return 1;
    }
}

