/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import com.google.common.collect.ImmutableList;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.IModCompat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public class ModCompatLoader
implements IInitListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<IModCompat, ForgeConfigSpec.BooleanValue> compatEnableMap = new HashMap<IModCompat, ForgeConfigSpec.BooleanValue>();
    private final List<IModCompat> incompatibleCompats = new LinkedList<IModCompat>();
    @Nullable
    private List<IModCompat> availableModCompats = new LinkedList<IModCompat>();
    private List<IModCompat> loadedModCompats;

    public void addModCompat(@NotNull IModCompat compat) {
        if (this.availableModCompats == null) {
            throw new IllegalStateException("Add mod compats BEFORE init (" + compat.getModID() + ")");
        }
        this.availableModCompats.add(compat);
    }

    public void buildConfig(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ForgeConfigSpec.Builder builder) {
        builder.push("Compatibility");
        assert (this.availableModCompats != null);
        for (IModCompat c : this.availableModCompats) {
            if (!this.isModLoaded(c)) continue;
            builder.push(c.getModID());
            this.compatEnableMap.put(c, builder.define("enable_compat_" + c.getModID(), true));
            c.buildConfig(builder);
            builder.pop();
        }
    }

    @Nullable
    public List<IModCompat> getAvailableModCompats() {
        return this.availableModCompats;
    }

    @NotNull
    public List<IModCompat> getIncompatibleCompats() {
        return ImmutableList.copyOf(this.incompatibleCompats);
    }

    @NotNull
    public List<IModCompat> getLoadedModCompats() {
        return ImmutableList.copyOf(this.loadedModCompats);
    }

    @Override
    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        if (step == IInitListener.Step.COMMON_SETUP) {
            this.prepareModCompats();
        }
        Iterator<IModCompat> it = this.loadedModCompats.iterator();
        while (it.hasNext()) {
            IModCompat next = it.next();
            try {
                next.onInitStep(step, event);
            }
            catch (Exception e) {
                LOGGER.error("---------------------------------------------------------", (Throwable)e);
                LOGGER.error("Mod Compat {} threw an exception during {}. Unloading.", (Object)next.getModID(), (Object)step);
                LOGGER.error("---------------------------------------------------------");
                it.remove();
            }
        }
    }

    private boolean isModLoaded(@NotNull IModCompat modCompat) {
        return ModList.get().isLoaded(modCompat.getModID());
    }

    private boolean isVersionOk(@NotNull IModCompat modCompat) {
        Optional mod = ModList.get().getModContainerById(modCompat.getModID());
        if (mod.isPresent()) {
            VersionRange range;
            String s = modCompat.getAcceptedVersionRange();
            if (s == null) {
                return true;
            }
            try {
                range = VersionRange.createFromVersionSpec((String)s);
            }
            catch (InvalidVersionSpecificationException e) {
                LOGGER.error("Invalid version spec {} for {}", (Object)s, (Object)modCompat.getModID());
                return false;
            }
            return range.containsVersion(((ModContainer)mod.get()).getModInfo().getVersion());
        }
        return false;
    }

    private void prepareModCompats() {
        if (this.availableModCompats == null) {
            LOGGER.warn("Trying to load mod compat twice");
            return;
        }
        LinkedList<IModCompat> loaded = new LinkedList<IModCompat>();
        for (IModCompat modCompat : this.availableModCompats) {
            ForgeConfigSpec.BooleanValue enabled;
            if (!this.isModLoaded(modCompat) || (enabled = this.compatEnableMap.get(modCompat)) == null || !((Boolean)enabled.get()).booleanValue()) continue;
            if (this.isVersionOk(modCompat)) {
                loaded.add(modCompat);
                LOGGER.debug("Prepared {} compatibility", (Object)modCompat.getModID());
                continue;
            }
            LOGGER.warn("Cannot load {} compat due to incompatible version", (Object)modCompat.getModID());
            this.incompatibleCompats.add(modCompat);
        }
        this.loadedModCompats = loaded;
        this.availableModCompats = null;
    }
}

