/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.skills;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillNodeScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTabType;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class SkillsTabScreen {
    public static final int SCREEN_WIDTH = 234;
    public static final int SCREEN_HEIGHT = 172;
    private final Minecraft minecraft;
    private final SkillsScreen screen;
    private final ISkillHandler<?> skillHandler;
    private final ItemStack icon;
    private final Component title;
    private final Map<SkillNode, SkillNodeScreen> nodes = new HashMap<SkillNode, SkillNodeScreen>();
    private final AdvancementTabType position;
    private final SkillNodeScreen root;
    private final int treeWidth;
    private final int treeHeight;
    private final ResourceLocation background;
    private double scrollX;
    private double scrollY;
    private int minX = Integer.MIN_VALUE;
    private int minY = Integer.MIN_VALUE;
    private int maxX = Integer.MAX_VALUE;
    private int maxY = Integer.MAX_VALUE;
    private float zoom = 1.0f;
    private final int index;
    private float fade;

    public SkillsTabScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, int index, @NotNull ItemStack icon, @NotNull SkillNode rootNode, @NotNull ISkillHandler<?> skillHandler, @NotNull Component title) {
        this.minecraft = minecraft;
        this.screen = screen;
        this.skillHandler = skillHandler;
        this.index = index;
        this.icon = icon;
        this.title = title;
        this.position = AdvancementTabType.LEFT;
        this.root = new SkillNodeScreen(minecraft, screen, this, rootNode, (SkillHandler)skillHandler);
        this.treeWidth = SkillTree.getTreeWidth(rootNode);
        this.treeHeight = SkillTree.getTreeHeight(rootNode);
        this.background = new ResourceLocation("vampirism", "textures/gui/skills/backgrounds/level.png");
        this.addNode(this.root);
        this.recalculateBorders();
        this.scrollX = 0.0;
        this.scrollY = 20.0;
    }

    private void recalculateBorders() {
        this.minY = (int)(-((float)this.treeHeight * this.zoom));
        this.maxY = (int)(20.0f * this.zoom);
        this.minX = (int)((float)(-this.treeWidth / 2) * this.zoom);
        this.maxX = (int)((float)(this.treeWidth / 2) * this.zoom);
        this.center();
    }

    private void addNode(@NotNull SkillNodeScreen screen) {
        this.nodes.put(screen.getSkillNode(), screen);
        for (SkillNodeScreen child : screen.getChildren()) {
            this.addNode(child);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void drawTab(@NotNull GuiGraphics graphics, int x, int y, boolean selected) {
        this.position.m_280111_(graphics, x, y, selected, this.index);
    }

    public void drawIcon(GuiGraphics graphics, int x, int y) {
        this.position.m_280639_(graphics, x, y, this.index, this.icon);
    }

    public boolean isMouseOver(int guiLeft, int guiTop, double mouseX, double mouseY) {
        return this.position.m_97213_(guiLeft, guiTop, this.index, mouseX, mouseY);
    }

    public void drawContents(@NotNull GuiGraphics graphics, int x, int y) {
        PoseStack pose = graphics.m_280168_();
        graphics.m_280588_(x, y, x + 234, y + 172);
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, 0.0f);
        int i = this.getX();
        int j = this.getY();
        int k = i % 16;
        int l = j % 16;
        pose.m_85841_(this.zoom, this.zoom, 1.0f);
        int i1 = -1;
        while ((float)i1 <= 15.0f / this.zoom) {
            int j1 = -1;
            while ((float)j1 <= 12.0f / this.zoom) {
                graphics.m_280163_(this.background, k + 16 * i1, l + 16 * j1, 0.0f, 0.0f, 16, 16, 16, 16);
                ++j1;
            }
            ++i1;
        }
        this.root.drawConnectivity(graphics, i, j, true);
        this.root.drawConnectivity(graphics, i, j, false);
        this.root.draw(graphics, i, j);
        pose.m_85849_();
        if (this.minecraft.f_91074_.m_21124_((MobEffect)ModEffects.OBLIVION.get()) != null) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 200.0f);
            graphics.m_280509_(x, y, x + 234, y + 172, Mth.m_14107_((double)127.5) << 24);
            pose.m_252880_(0.0f, 0.0f, 200.0f);
            this.drawDisableText(graphics, x, y);
            pose.m_85849_();
        }
        graphics.m_280618_();
    }

    public void drawTooltips(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, -200.0f);
        graphics.m_280509_(0, 0, 234, 172, Mth.m_14143_((float)(this.fade * 255.0f)) << 24);
        boolean flag = false;
        int scrollX = this.getX();
        int scrollY = this.getY();
        if (mouseX >= 0 && mouseX < 235 && mouseY >= 0 && mouseY < 173) {
            for (SkillNodeScreen nodeScreen : this.nodes.values()) {
                if (!nodeScreen.isMouseOver((float)mouseX / this.zoom, (float)mouseY / this.zoom, scrollX, scrollY)) continue;
                flag = true;
                pose.m_85836_();
                pose.m_85841_(this.zoom, this.zoom, 1.0f);
                nodeScreen.drawHover(graphics, (float)mouseX / this.zoom, (float)mouseY / this.zoom, this.fade, scrollX, scrollY);
                pose.m_85849_();
                break;
            }
        }
        pose.m_85849_();
        this.fade = flag ? Mth.m_14036_((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : Mth.m_14036_((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public void mouseDragged(double mouseX, double mouseY, int mouseButton, double xDragged, double yDragged) {
        this.scrollX += xDragged;
        this.scrollY += yDragged;
        this.center();
    }

    private void center() {
        this.scrollX = Mth.m_14008_((double)this.scrollX, (double)this.minX, (double)this.maxX);
        this.scrollY = Mth.m_14008_((double)this.scrollY, (double)this.minY, (double)this.maxY);
    }

    public Component getTitle() {
        return this.title;
    }

    private int getX() {
        int centerX = 117;
        centerX = (int)((double)centerX + this.scrollX);
        centerX = (int)((float)centerX / this.zoom);
        return centerX;
    }

    private int getY() {
        int centerY = 20;
        centerY = (int)((double)centerY + this.scrollY);
        centerY = (int)((float)centerY / this.zoom);
        return centerY;
    }

    @Nullable
    public ISkill<?> getSelected(int mouseX, int mouseY) {
        int i = this.getX();
        int j = this.getY();
        for (SkillNodeScreen screen : this.nodes.values()) {
            ISkill selected = screen.getSelectedSkill((float)mouseX / this.zoom, (float)mouseY / this.zoom, i, j);
            if (selected == null) continue;
            return selected;
        }
        return null;
    }

    public int getRemainingPoints() {
        return this.skillHandler.getLeftSkillPoints();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        double scrollXP = this.scrollX * (double)this.zoom;
        double scrollYP = this.scrollY * (double)this.zoom;
        float heightZoom = this.zoom = (float)((double)this.zoom + amount / 25.0);
        float widthZoom = this.zoom;
        if (this.zoom * (float)this.treeHeight < 172.0f) {
            heightZoom = Math.max(this.zoom, 172.0f / (float)this.treeHeight);
        }
        if (this.zoom * (float)this.treeWidth < 214.0f) {
            widthZoom = Math.max(this.zoom, 214.0f / (float)Math.max(60, this.treeWidth));
        }
        this.zoom = Math.min(heightZoom, widthZoom);
        this.zoom = Math.min(1.0f, this.zoom);
        this.scrollX = scrollXP / (double)this.zoom;
        this.scrollY = scrollYP / (double)this.zoom;
        this.recalculateBorders();
        return true;
    }

    public void drawDisableText(@NotNull GuiGraphics graphics, int x, int y) {
        MutableComponent f = Component.m_237115_((String)"text.vampirism.skill.unlock_unavailable").m_130940_(ChatFormatting.WHITE);
        FormattedCharSequence s = Language.m_128107_().m_5536_((FormattedText)f);
        int tooltipTextWidth = 219;
        int tooltipX = 7 + x;
        int tooltipY = 17 + y;
        Objects.requireNonNull(this.minecraft.f_91062_);
        int tooltipHeight = 9 * 2;
        int backgroundColor = -258276348;
        int borderColorStart = 1348406284;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)tooltipX, (int)tooltipY, (int)tooltipTextWidth, (int)tooltipHeight, (int)400, (int)backgroundColor, (int)backgroundColor, (int)borderColorStart, (int)borderColorEnd);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        Font font = this.minecraft.f_91062_;
        int n = tooltipX + tooltipTextWidth / 2;
        int n2 = tooltipY + tooltipHeight / 2;
        Objects.requireNonNull(this.minecraft.f_91062_);
        graphics.m_280653_(font, (Component)f, n, n2 - 9 / 2, 0xF000F0);
        graphics.m_280168_().m_85849_();
    }
}

