/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiteNearbyEntityVampireGoal<T extends Mob>
extends Goal {
    private final T vampire;
    @Nullable
    private IExtendedCreatureVampirism creature;
    private int timer;

    public BiteNearbyEntityVampireGoal(T vampire) {
        this.vampire = vampire;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8045_() {
        return this.timer > 0 && this.creature.getEntity().m_6084_() && this.creature.getEntity().m_20191_().m_82381_(this.getBiteBoundingBox());
    }

    public boolean m_8036_() {
        if (((IVampire)this.vampire).wantsBlood()) {
            List list = this.vampire.m_20193_().m_6443_(PathfinderMob.class, this.getBiteBoundingBox(), EntitySelector.f_20408_.and(entity -> entity != this.vampire && entity.m_6084_()));
            if (list.size() > 1) {
                try {
                    list.sort((o1, o2) -> (int)(this.vampire.m_20280_((Entity)o1) - this.vampire.m_20280_((Entity)o2)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            for (PathfinderMob o : list) {
                if (!this.vampire.m_21574_().m_148306_((Entity)o) || o.m_8077_() || !ExtendedCreature.getSafe((Entity)o).filter(this::canFeed).map(creature -> {
                    this.creature = creature;
                    return true;
                }).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        this.creature = null;
        return false;
    }

    public void m_8056_() {
        this.timer = 20 + this.vampire.m_217043_().m_188503_(20);
    }

    public void m_8041_() {
        this.creature = null;
    }

    public void m_8037_() {
        PathfinderMob e = this.creature.getEntity();
        this.vampire.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(e.m_20185_(), e.m_20186_() + (double)e.m_20192_(), e.m_20189_()));
        --this.timer;
        if (this.timer == 1 && this.canFeed(this.creature)) {
            int amount = this.creature.onBite((IVampire)this.vampire);
            this.vampire.m_5496_((SoundEvent)ModSounds.VAMPIRE_BITE.get(), 1.0f, 1.0f);
            ((IVampire)this.vampire).drinkBlood(amount, this.creature.getBloodSaturation(), new DrinkBloodContext((LivingEntity)e));
        }
    }

    protected boolean canFeed(@NotNull IExtendedCreatureVampirism entity) {
        return entity.canBeBitten((IVampire)this.vampire) && !entity.hasPoisonousBlood() && (!(entity.getEntity() instanceof Villager) || (float)entity.getBlood() > (float)entity.getMaxBlood() / 2.0f);
    }

    @NotNull
    protected AABB getBiteBoundingBox() {
        return this.vampire.m_20191_().m_82377_(0.5, 0.7, 0.5);
    }
}

