/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.FactionPlayerBooleanSupplier;
import de.teamlapen.vampirism.api.entity.player.FactionPlayerConsumer;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.api.util.NonnullSupplier;
import de.teamlapen.vampirism.api.util.NullableSupplier;
import de.teamlapen.vampirism.entity.player.tasks.req.BooleanRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.EntityRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.EntityTypeRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.StatRequirement;
import de.teamlapen.vampirism.entity.player.tasks.reward.ConsumerReward;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemReward;
import de.teamlapen.vampirism.entity.player.tasks.unlock.ParentUnlocker;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskBuilder {
    @NotNull
    private final Map<ResourceLocation, TaskRequirement.Requirement<?>> requirement = new HashMap();
    @NotNull
    private final List<TaskUnlocker> unlocker = Lists.newArrayList();
    @Nullable
    private TaskReward reward;
    private Component title;
    private Component description;
    @Nullable
    private ResourceLocation taskId;

    @NotNull
    public static TaskBuilder builder() {
        return new TaskBuilder();
    }

    @Deprecated
    @NotNull
    public static TaskBuilder builder(ResourceKey<Task> taskKey) {
        return new TaskBuilder(taskKey);
    }

    private TaskBuilder() {
    }

    private TaskBuilder(@NotNull ResourceKey<Task> taskKey) {
        this.taskId = taskKey.m_135782_();
    }

    @Deprecated
    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, @NotNull EntityType<?> entityType, int amount) {
        return this.addRequirement(new EntityRequirement(new ResourceLocation(this.modId(), name), entityType, amount, this.requirementDescription(name)));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull EntityType<?> entityType, int amount, Component description) {
        return this.addRequirement(new EntityRequirement(entityType, amount, description));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull EntityType<?> entityType, int amount) {
        return this.addRequirement(new EntityRequirement(entityType, amount, (Component)Component.m_237115_((String)Util.m_137492_((String)"entity", (ResourceLocation)RegUtil.id(entityType)))));
    }

    @Deprecated
    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, @NotNull TagKey<EntityType<?>> entityType, int amount) {
        return this.addRequirement(new EntityTypeRequirement(new ResourceLocation(this.modId(), name), entityType, amount, this.requirementDescription(name)));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull TagKey<EntityType<?>> entityType, int amount, Component description) {
        return this.addRequirement(new EntityTypeRequirement(entityType, amount, description));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull TagKey<EntityType<?>> entityType, int amount) {
        return this.addRequirement(new EntityTypeRequirement(entityType, amount, (Component)Component.m_237115_((String)Util.m_137492_((String)"entity_tag", (ResourceLocation)entityType.f_203868_()))));
    }

    @Deprecated
    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, @NotNull ResourceLocation stat, int amount) {
        return this.addRequirement(new StatRequirement(new ResourceLocation(this.modId(), name), stat, amount, this.requirementDescription(name)));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull ResourceLocation stat, int amount, Component description) {
        return this.addRequirement(new StatRequirement(stat, amount, description));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull ResourceLocation stat, int amount) {
        return this.addRequirement(new StatRequirement(stat, amount, (Component)Component.m_237115_((String)Util.m_137492_((String)"stat", (ResourceLocation)stat))));
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, NonnullSupplier<ItemStack> itemStack) {
        return this.addRequirement(new ItemRequirement(new ResourceLocation(this.modId(), name), itemStack.get(), this.requirementDescription(name)));
    }

    @Deprecated
    public TaskBuilder addRequirement(@NotNull String name, ItemStack itemStack) {
        return this.addRequirement(new ItemRequirement(new ResourceLocation(this.modId(), name), itemStack, this.requirementDescription(name)));
    }

    public TaskBuilder addRequirement(ItemStack itemStack, Component description) {
        return this.addRequirement(new ItemRequirement(itemStack, description));
    }

    public TaskBuilder addRequirement(ItemStack itemStack) {
        return this.addRequirement(new ItemRequirement(itemStack, (Component)Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)RegUtil.id(itemStack.m_41720_())))));
    }

    @Deprecated
    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, @NotNull FactionPlayerBooleanSupplier function) {
        return this.addRequirement(new BooleanRequirement(new ResourceLocation(this.modId(), name), function, this.requirementDescription(name)));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull FactionPlayerBooleanSupplier function, Component description) {
        return this.addRequirement(new BooleanRequirement(function, description));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull FactionPlayerBooleanSupplier function) {
        return this.addRequirement(new BooleanRequirement(function, (Component)Component.m_237115_((String)Util.m_137492_((String)"faction_boolean_supplier", (ResourceLocation)FactionPlayerBooleanSupplier.getId(function)))));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull TaskRequirement.Requirement<?> requirement) {
        Preconditions.checkArgument((!this.requirement.containsKey(requirement.id()) ? 1 : 0) != 0, (Object)String.format("Requirement %s already exists", requirement.id()));
        this.requirement.put(requirement.id(), requirement);
        return this;
    }

    @NotNull
    public TaskBuilder setTitle(@NotNull Component title) {
        this.title = title;
        return this;
    }

    @NotNull
    public TaskBuilder setTitle(@NotNull ResourceLocation title) {
        this.title = Component.m_237115_((String)Util.m_137492_((String)"task", (ResourceLocation)title));
        return this;
    }

    @Deprecated
    @NotNull
    public TaskBuilder defaultTitle() {
        Preconditions.checkArgument((this.taskId != null ? 1 : 0) != 0, (Object)"If you want to use legacy naming, you need to provide the builder with a task key");
        this.title = Component.m_237115_((String)Util.m_137492_((String)"task", (ResourceLocation)this.taskId));
        return this;
    }

    @Deprecated
    private Component requirementDescription(String name) {
        Preconditions.checkArgument((this.taskId != null ? 1 : 0) != 0, (Object)"If you want to use legacy naming, you need to provide the builder with a task key");
        return Component.m_237115_((String)(Util.m_137492_((String)"task", (ResourceLocation)this.taskId) + ".req." + new ResourceLocation(this.modId(), name).toString().replace(":", ".")));
    }

    @NotNull
    public Task build() {
        Preconditions.checkArgument((!this.requirement.isEmpty() ? 1 : 0) != 0, (Object)"Task needs requirements");
        Preconditions.checkArgument((this.reward != null ? 1 : 0) != 0, (Object)"Task needs a reward");
        Preconditions.checkArgument((this.title != null ? 1 : 0) != 0, (Object)"Task needs a title");
        return new Task(new TaskRequirement(this.requirement.values()), this.reward, this.unlocker.toArray(new TaskUnlocker[0]), this.description, this.title);
    }

    @NotNull
    public TaskBuilder setDescription(Component description) {
        this.description = description;
        return this;
    }

    @NotNull
    public TaskBuilder setDescription(ResourceLocation title) {
        this.description = Component.m_237115_((String)(Util.m_137492_((String)"task", (ResourceLocation)title) + ".desc"));
        return this;
    }

    @NotNull
    public TaskBuilder requireParent(@Nullable Holder<Task> parentTask) {
        this.unlocker.add(new ParentUnlocker(parentTask));
        return this;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public TaskBuilder setReward(NonnullSupplier<ItemStack> reward) {
        this.reward = new ItemReward(reward.get());
        return this;
    }

    @NotNull
    public TaskBuilder setReward(ItemStack reward) {
        this.reward = new ItemReward(reward);
        return this;
    }

    @NotNull
    public TaskBuilder setReward(TaskReward reward) {
        this.reward = reward;
        return this;
    }

    @NotNull
    public TaskBuilder setReward(FactionPlayerConsumer reward, Component description) {
        return this.setReward(new ConsumerReward(reward, description));
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public TaskBuilder setUnique() {
        return this;
    }

    @NotNull
    public TaskBuilder unlockedBy(TaskUnlocker unlocker) {
        this.unlocker.add(unlocker);
        return this;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public TaskBuilder withFaction(@NotNull NullableSupplier<IPlayableFaction<?>> faction) {
        return this;
    }

    @NotNull
    protected String modId() {
        return "vampirism";
    }
}

