/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.animation.attacks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import reascer.wom.animation.attacks.BasicMultipleAttackAnimation;
import reascer.wom.gameasset.colliders.WOMWeaponColliders;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.projectile.NapoleonBullet;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class NapoleonShootAttackAnimation
extends BasicMultipleAttackAnimation {
    public NapoleonShootAttackAnimation(float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends NapoleonShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, antic, antic, contact, recovery, collider, colliderJoint, accessor, armature);
    }

    public NapoleonShootAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends NapoleonShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, accessor, armature, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, colliderJoint, collider)});
    }

    public NapoleonShootAttackAnimation(float convertTime, float antic, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends NapoleonShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, accessor, armature, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, antic, antic, contact, recovery, Float.MAX_VALUE, hand, colliderJoint, collider)});
    }

    public NapoleonShootAttackAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends NapoleonShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, boolean Coordsetter, AttackAnimation.Phase ... phases) {
        super(convertTime, accessor, armature, phases);
    }

    public NapoleonShootAttackAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends NapoleonShootAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, accessor, armature, phases);
        this.newTimePair(0.0f, Float.MAX_VALUE);
        this.addStateRemoveOld(EntityState.TURNING_LOCKED, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_TARGET_DISTANCE);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!((StaticAnimation)self.getRealAnimation().get()).getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_().m_82549_(attackTarget.m_20184_().m_82490_(8.0));
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 1.2f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.8f, 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale;
                }
                transformSheet.readFrom(transform);
            } else {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        });
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (self, pose, entitypatch, time, partialticks) -> {
            if (self instanceof AttackAnimation) {
                float pitch = (float)Math.toDegrees(((LivingEntity)entitypatch.getOriginal()).m_20252_((float)1.0f).f_82480_);
                JointTransform armR = pose.orElseEmpty("Arm_R");
                armR.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
                if (((AttackAnimation)self).getPhaseByTime((float)1.0f).colliders[0].getFirst() != ((HumanoidArmature)Armatures.BIPED.get()).armR) {
                    JointTransform armL = pose.orElseEmpty("Arm_L");
                    armL.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
                }
                JointTransform chest = pose.orElseEmpty("Chest");
                chest.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(pitch > 35.0f ? -pitch + 35.0f : 0.0f)), OpenMatrix4f::mul);
                JointTransform head = pose.orElseEmpty("Head");
                head.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(pitch)), OpenMatrix4f::mul);
            }
        });
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (!entitypatch.isLogicalClient()) {
            AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
            float elapsedTime = player.getElapsedTime();
            float prevElapsedTime = player.getPrevElapsedTime();
            EntityState state = this.getState(entitypatch, elapsedTime);
            EntityState prevState = this.getState(entitypatch, prevElapsedTime);
            AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
            if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
                ((Mob)entitypatch.getOriginal()).m_21573_().m_26573_();
                ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
                LivingEntity target = entitypatch.getTarget();
                if (target != null) {
                    entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
                }
            }
            if ((prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) && (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2))) {
                Level worldIn = ((LivingEntity)entitypatch.getOriginal()).m_9236_();
                float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
                float poseTime = state.attacking() ? elapsedTime : phase.contact;
                List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
                ArrayList list2 = new ArrayList(list);
                for (Entity entity : list) {
                    if (entity instanceof Projectile) {
                        list2.remove(entity);
                        continue;
                    }
                    if (entity instanceof LivingEntity) continue;
                    list2.remove(entity);
                }
                if (list2.size() == 0) {
                    Joint joint = (Joint)phase.colliders[0].getFirst();
                    Collider collider = (Collider)phase.colliders[0].getSecond();
                    if (joint != ((HumanoidArmature)Armatures.BIPED.get()).head && joint != ((HumanoidArmature)Armatures.BIPED.get()).rootJoint && collider == WOMWeaponColliders.NAPOLEON_SHOOT) {
                        OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(-0.5f), joint);
                        transformMatrix.translate(new Vec3f(0.0f, -0.6f, -0.3f));
                        OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_19859_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
                        Vec3 direction = ((LivingEntity)entitypatch.getOriginal()).m_20252_(1.0f);
                        NapoleonBullet projectile = new NapoleonBullet((EntityType<? extends NapoleonBullet>)((EntityType)WOMEntities.NAPOLEON_BULLET.get()), worldIn);
                        projectile.m_20049_("wom_enderbullet:" + phase.getHand().toString());
                        projectile.m_5602_(entitypatch.getOriginal());
                        projectile.m_20343_((double)transformMatrix.m30 + ((LivingEntity)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((LivingEntity)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((LivingEntity)entitypatch.getOriginal()).m_20189_());
                        projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 8.0f, 0.0f);
                        projectile.life = 1;
                        worldIn.m_7967_((Entity)projectile);
                    }
                }
            }
        }
    }

    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = this.getRawPose(time);
        this.modifyPose((DynamicAnimation)this, pose, entitypatch, time, partialTicks);
        float pitch = (float)Math.toDegrees(((LivingEntity)entitypatch.getOriginal()).m_20252_((float)1.0f).f_82480_);
        JointTransform armR = pose.orElseEmpty("Arm_R");
        armR.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        if (this.getPhaseByTime((float)partialTicks).colliders[0].getFirst() != ((HumanoidArmature)Armatures.BIPED.get()).armR) {
            JointTransform armL = pose.orElseEmpty("Arm_L");
            armL.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        }
        JointTransform chest = pose.orElseEmpty("Chest");
        chest.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch * 0.5f)), OpenMatrix4f::mul);
        if (entitypatch instanceof PlayerPatch) {
            JointTransform head = pose.orElseEmpty("Head");
            head.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch * 0.5f)), OpenMatrix4f::mul);
        }
        return pose;
    }

    @Override
    public boolean isBasicAttackAnimation() {
        return false;
    }
}

