/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.ClassicMesh;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;

public class BlackLaserParticle
extends CustomModelParticle<ClassicMesh> {
    private final float length;
    private final float xRot;
    private final float yRot;

    public BlackLaserParticle(ClientLevel level, double x, double y, double z, double toX, double toY, double toZ) {
        super(level, x, y, z, 0.0, 0.0, 0.0, (AssetAccessor)Meshes.LASER);
        int i;
        this.f_107225_ = 5;
        this.f_107227_ = 0.0f;
        this.f_107228_ = 0.0f;
        this.f_107229_ = 0.0f;
        Vec3 direction = new Vec3(toX - x, toY - y, toZ - z);
        Vec3 start = new Vec3(x, y, z);
        Vec3 destination = start.m_82549_(direction.m_82541_().m_82490_(50.0));
        BlockHitResult hitResult = level.m_45547_(new ClipContext(start, destination, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        double xLength = hitResult.m_82450_().f_82479_ - x;
        double yLength = hitResult.m_82450_().f_82480_ - y;
        double zLength = hitResult.m_82450_().f_82481_ - z;
        double horizontalDistance = (float)Math.sqrt(xLength * xLength + zLength * zLength);
        this.length = (float)Math.sqrt(xLength * xLength + yLength * yLength + zLength * zLength);
        this.yRot = (float)(-Math.atan2(zLength, xLength) * 57.29577951308232) - 90.0f;
        this.xRot = (float)(Math.atan2(-yLength, horizontalDistance) * 57.29577951308232);
        int smokeCount = (int)this.length * 8;
        for (i = 0; i < smokeCount; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + new Random().nextGaussian() * (double)0.2f + xLength / (double)smokeCount * (double)i, y + new Random().nextGaussian() * (double)0.2f + yLength / (double)smokeCount * (double)i, z + new Random().nextGaussian() * (double)0.2f + zLength / (double)smokeCount * (double)i, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 10; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, new Random().nextGaussian() * (double)0.05f, new Random().nextGaussian() * (double)0.05f, new Random().nextGaussian() * (double)0.05f);
        }
        this.m_107259_(new AABB(x, y, z, toX, toY, toZ));
    }

    public void prepareDraw(PoseStack poseStack, float partialTicks) {
        poseStack.m_252781_(QuaternionUtils.YP.rotationDegrees(this.yRot));
        poseStack.m_252781_(QuaternionUtils.XP.rotationDegrees(this.xRot));
        float progression = ((float)this.f_107224_ + partialTicks) / (float)(this.f_107225_ + 1);
        float scale = Mth.m_14031_((float)(progression * (float)Math.PI)) * 0.2f;
        float zScale = -this.length;
        poseStack.m_85841_(scale, scale, zScale * this.length);
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        super.m_5744_(vertexConsumer, camera, partialTicks);
        PoseStack poseStack = new PoseStack();
        this.setupPoseStack(poseStack, camera, partialTicks);
        this.prepareDraw(poseStack, partialTicks);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
    }

    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.TRANSLUCENT_GLOWING;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double startX, double startY, double startZ, double endX, double endY, double endZ) {
            return new BlackLaserParticle(level, startX, startY, startZ, endX, endY, endZ);
        }
    }
}

