/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.gameasset.animations.entitys;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import reascer.wom.animation.attacks.BasicMultipleAttackAnimation;
import reascer.wom.armature.EvilSkeletonArmature;
import reascer.wom.gameasset.ReuseableEvents;
import reascer.wom.gameasset.WOMArmatures;
import reascer.wom.gameasset.colliders.WOMMobColliders;
import reascer.wom.gameasset.colliders.WOMWeaponColliders;
import reascer.wom.particle.ParticlesTools;
import reascer.wom.particle.WOMParticles;
import reascer.wom.world.entity.mob.EvilSkeleton;
import reascer.wom.world.entity.mobpatch.EvilSkeletonPatch;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LongHitAnimation;
import yesman.epicfight.api.animation.types.MovementAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;

public class AnimsEvilSkeleton {
    public static AnimationManager.AnimationAccessor<StaticAnimation> EVIL_SKELETON_IDLE;
    public static AnimationManager.AnimationAccessor<MovementAnimation> EVIL_SKELETON_WALK;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_POMMEL_HIT;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_UPWARD_SWING;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_UPWARD_SWING_STRONG;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_EVIL_BATTOJUSTSU;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_DOUBLE_SLASH;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_OVERHEAD_DIVISION;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_SPINNING_SLASH;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_DEMONIC_BEAM;
    public static AnimationManager.AnimationAccessor<BasicMultipleAttackAnimation> EVIL_SKELETON_DEATH;
    public static AnimationManager.AnimationAccessor<LongHitAnimation> EVIL_SKELETON_BLACKOUT;

    public static void build(AnimationManager.AnimationBuilder builder) {
        Armatures.ArmatureAccessor<EvilSkeletonArmature> armature = WOMArmatures.EVIL_SKELETON;
        EVIL_SKELETON_IDLE = builder.nextAccessor("evil_skeleton/living/evil_skeleton_idle", accessor -> new StaticAnimation(0.4f, true, accessor, armature));
        EVIL_SKELETON_WALK = builder.nextAccessor("evil_skeleton/living/evil_skeleton_walk", accessor -> new MovementAnimation(true, accessor, armature));
        EVIL_SKELETON_POMMEL_HIT = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_pommel_hit", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.15f, 0.5f, 0.6f, 1.5f, WOMWeaponColliders.EVIL_TACHI_WITH_POMMEL, ((EvilSkeletonArmature)armature.get()).tool_R, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f)).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)((SoundEvent)EpicFightSounds.BLUNT_HIT_HARD.get())).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageTypeTags.GUARD_PUNCTURE)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NEUTRALIZE).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.0f)).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)1.75f, (entitypatch, self, params) -> {}, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
        EVIL_SKELETON_UPWARD_SWING = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_upward_swing", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.05f, 0.5f, 0.9f, 1.1f, WOMWeaponColliders.EVIL_TACHI, ((EvilSkeletonArmature)armature.get()).tool_R, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.2f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)2.5f)).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)((SoundEvent)EpicFightSounds.WHOOSH_ROD.get())).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, WOMParticles.ANTITHEUS_HIT_UP).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageTypeTags.FINISHER)).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.EXTRA_COLLIDERS, (Object)5).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.0f)).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.MOVE_VERTICAL, (Object)true).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)true).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.35f, 0.75f})).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.76f, (entitypatch, self, params) -> {
            Vec3 current_Delta = ((LivingEntity)entitypatch.getOriginal()).m_20184_();
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(current_Delta.f_82479_, current_Delta.f_82480_ - 4.0, current_Delta.f_82481_);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)0.9f, (entitypatch, self, params) -> {
            Vec3 current_Delta = ((LivingEntity)entitypatch.getOriginal()).m_20184_();
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(current_Delta.f_82479_, -8.0, current_Delta.f_82481_);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
        EVIL_SKELETON_UPWARD_SWING_STRONG = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_upward_swing_strong", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.25f, 0.5f, 0.9f, 1.1f, WOMWeaponColliders.EVIL_TACHI, ((EvilSkeletonArmature)armature.get()).tool_R, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.6f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)5.0f)).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)((SoundEvent)EpicFightSounds.WHOOSH_ROD.get())).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, WOMParticles.ANTITHEUS_HIT_UP).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageTypeTags.FINISHER)).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.EXTRA_COLLIDERS, (Object)5).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.MOVE_VERTICAL, (Object)true).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)true).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> 0.8f).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.35f, 0.75f})).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.7f, (entitypatch, self, params) -> {
            Vec3 deltaMove = ((LivingEntity)entitypatch.getOriginal()).m_20184_();
            Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(((LivingEntity)entitypatch.getOriginal()).m_5686_(1.0f), ((LivingEntity)entitypatch.getOriginal()).m_5675_(1.0f)));
            Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(-0.5));
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(jumpDir.f_82479_ + deltaMove.f_82479_, jumpDir.f_82480_ + deltaMove.f_82480_, jumpDir.f_82481_ + deltaMove.f_82481_);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)1.0f, (entitypatch, self, params) -> {
            Vec3 current_Delta = ((LivingEntity)entitypatch.getOriginal()).m_20184_();
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(current_Delta.f_82479_, -8.0, current_Delta.f_82481_);
            if (entitypatch.isLastAttackSuccess()) {
                entitypatch.playAnimationSynchronized(EVIL_SKELETON_DEMONIC_BEAM, -0.4f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
        EVIL_SKELETON_EVIL_BATTOJUSTSU = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_evil_battojutsu", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.5f, 0.75f, 1.15f, 2.35f, WOMMobColliders.EVIl_SKELETON_EVIL_BATTOJUTSU, ((EvilSkeletonArmature)armature.get()).rootJoint, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.8f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)0.9f)).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageTypeTags.BYPASS_DODGE)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, WOMParticles.ANTITHEUS_HIT).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)((SoundEvent)EpicFightSounds.WHOOSH_BIG.get())).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)((SoundEvent)EpicFightSounds.BLADE_RUSH_FINISHER.get())).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.0f)).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> 1.4f).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)true).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.75f, (entitypatch, self, params) -> {
            Entity entity = entitypatch.getOriginal();
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)EpicFightParticles.WHITE_AFTERIMAGE.get(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Double.longBitsToDouble(entity.m_19879_()), (double)1.3f, 0.0);
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.75f, (entitypatch, self, params) -> {
            Vec3 deltaMove = ((LivingEntity)entitypatch.getOriginal()).m_20184_();
            Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(((LivingEntity)entitypatch.getOriginal()).m_5686_(1.0f), ((LivingEntity)entitypatch.getOriginal()).m_5675_(1.0f)));
            Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(3.4));
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_6263_(null, ((LivingEntity)entitypatch.getOriginal()).m_20185_(), ((LivingEntity)entitypatch.getOriginal()).m_20186_(), ((LivingEntity)entitypatch.getOriginal()).m_20189_(), SoundEvents.f_12558_, SoundSource.MASTER, 0.5f, 0.8f - (new Random().nextFloat() - 0.5f) * 0.1f);
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_6263_(null, ((LivingEntity)entitypatch.getOriginal()).m_20185_(), ((LivingEntity)entitypatch.getOriginal()).m_20186_(), ((LivingEntity)entitypatch.getOriginal()).m_20189_(), SoundEvents.f_11928_, SoundSource.MASTER, 0.5f, 0.8f - (new Random().nextFloat() - 0.5f) * 0.1f);
            ((ServerLevel)((LivingEntity)entitypatch.getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, ((LivingEntity)entitypatch.getOriginal()).m_20185_(), ((LivingEntity)entitypatch.getOriginal()).m_20186_() + 1.0, ((LivingEntity)entitypatch.getOriginal()).m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            ((ServerLevel)((LivingEntity)entitypatch.getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, ((LivingEntity)entitypatch.getOriginal()).m_20185_(), ((LivingEntity)entitypatch.getOriginal()).m_20186_() + 1.0, ((LivingEntity)entitypatch.getOriginal()).m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            if (entitypatch.getTarget() != null) {
                Vec2f facing = ReuseableEvents.getYawPitchF(((LivingEntity)entitypatch.getOriginal()).m_146892_(), entitypatch.getTarget().m_146892_());
                Vec3f offset = new Vec3f(ReuseableEvents.getPointInDirection(facing.y, -facing.x, 1.0).m_82520_(0.0, (double)(((LivingEntity)entitypatch.getOriginal()).m_20206_() / 2.0f), 0.0));
                ParticlesTools.particle_circle_server((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 1.5f), entitypatch, (ServerLevel)((LivingEntity)entitypatch.getOriginal()).m_9236_(), null, 50, 2.2f, 0.01f, 0.5f, offset, null, facing, false, false);
            }
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(jumpDir.f_82479_ + deltaMove.f_82479_, jumpDir.f_82480_ + deltaMove.f_82480_, jumpDir.f_82481_ + deltaMove.f_82481_);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)1.0f, (entitypatch, self, params) -> {
            Vec3 deltaMove = ((LivingEntity)entitypatch.getOriginal()).m_20184_();
            Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(((LivingEntity)entitypatch.getOriginal()).m_5686_(1.0f), ((LivingEntity)entitypatch.getOriginal()).m_5675_(1.0f)));
            Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(0.4));
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(jumpDir.f_82479_ + deltaMove.f_82479_, jumpDir.f_82480_ + deltaMove.f_82480_, jumpDir.f_82481_ + deltaMove.f_82481_);
            if (entitypatch.getTarget() != null) {
                entitypatch.rotateTo((Entity)entitypatch.getTarget(), 360.0f, false);
                ((LivingEntity)entitypatch.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, entitypatch.getTarget().m_20182_());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)1.25f, (entitypatch, self, params) -> ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, 0.0, 0.0), (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).newTimePair(0.0f, Float.MAX_VALUE).addStateRemoveOld(EntityState.TURNING_LOCKED, (Object)false));
        EVIL_SKELETON_DOUBLE_SLASH = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_double_slash", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.05f, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature, new AttackAnimation.Phase(0.0f, 0.25f, 0.5f, 0.5f, 0.5f, ((EvilSkeletonArmature)armature.get()).tool_R, null), new AttackAnimation.Phase(0.5f, 0.95f, 1.15f, 1.35f, Float.MAX_VALUE, ((EvilSkeletonArmature)armature.get()).tool_R, null)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.8f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.8f), 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)1.4f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)2.1f), 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE, 1).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(0.5f)));
        EVIL_SKELETON_SPINNING_SLASH = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_spinning_slash", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.05f, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature, new AttackAnimation.Phase(0.0f, 0.5f, 1.0f, 1.2f, Float.MAX_VALUE, ((EvilSkeletonArmature)armature.get()).tool_R, null)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)1.6f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(0.5f)));
        EVIL_SKELETON_OVERHEAD_DIVISION = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_overhead_division", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.05f, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature, new AttackAnimation.Phase(0.0f, 1.85f, 1.95f, 3.65f, 3.65f, ((EvilSkeletonArmature)armature.get()).rootJoint, WOMMobColliders.EVIL_TACHI_OVERHEAD), new AttackAnimation.Phase(3.65f, 3.7f, 3.8f, 6.5f, Float.MAX_VALUE, ((EvilSkeletonArmature)armature.get()).rootJoint, WOMMobColliders.EVIL_TACHI_OVERHEAD_EXPLOSION)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)10.0f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, WOMParticles.ANTITHEUS_HIT_DOWN).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)((SoundEvent)EpicFightSounds.WHOOSH_SHARP.get())).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageTypeTags.GUARD_PUNCTURE, EpicFightDamageTypeTags.FINISHER)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)3.0f), 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)10.0f), 1).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, WOMParticles.ANTITHEUS_PUNCH_HIT, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.KNOCKDOWN, 1).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)SoundEvents.f_12555_, 1).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageTypeTags.BYPASS_DODGE, EpicFightDamageTypeTags.GUARD_PUNCTURE, EpicFightDamageTypeTags.FINISHER), 1).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(0.5f)).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)1.85f, (entitypatch, self, params) -> ReuseableEvents.ground_slam(entitypatch, (AssetAccessor<? extends StaticAnimation>)self, ((EvilSkeletonArmature)armature.get()).tool_R, new Vec3f(0.0f, 0.0f, -1.4f), 0.0, 3.0f), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)3.7f, (entitypatch, self, params) -> {
            ReuseableEvents.ground_slam(entitypatch, (AssetAccessor<? extends StaticAnimation>)self, ((EvilSkeletonArmature)armature.get()).tool_R, new Vec3f(0.0f, 0.0f, -1.4f), 0.0, 7.0f);
            Vec3 position = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(0.0f), ((EvilSkeletonArmature)armature.get()).tool_R).mulFront(OpenMatrix4f.createTranslation((float)((float)position.f_82479_), (float)((float)position.f_82480_), (float)((float)position.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(0.0f))));
            Vec3f offset = new Vec3f(0.0f, 0.0f, -2.0f);
            OpenMatrix4f.transform3v((OpenMatrix4f)transformMatrix, (Vec3f)offset, (Vec3f)offset);
            int n = 80;
            double r = 1.0;
            double t = 0.01;
            for (int i = 0; i < n; ++i) {
                double theta = Math.PI * 2 * new Random().nextDouble();
                double phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                double x = r * Math.cos(phi) * Math.cos(theta);
                double y = r * Math.cos(phi) * Math.sin(theta);
                double z = r * Math.sin(phi);
                Vec3f direction = new Vec3f((float)x, (float)y, (float)z);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_20884_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(90.0), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)(direction.x * 3.0f + offset.x), (double)(direction.y * 3.0f + offset.y - 0.1f), (double)(direction.z * 3.0f + offset.z), (double)(direction.x / 3.0f), (double)(direction.y / 3.0f - 0.02f), (double)(direction.z / 3.0f));
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)(direction.x * 0.7f + offset.x), (double)(direction.y * 0.7f + offset.y + 3.0f), (double)(direction.z * 0.7f + offset.z), (double)(direction.x / 4.0f), (double)(direction.y / 4.0f - 0.02f), (double)(direction.z / 4.0f));
            }
            for (int y = 0; y < 60; ++y) {
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)offset.x + new Random().nextGaussian() / 2.0, (double)offset.y + new Random().nextGaussian() / 2.0, (double)offset.z + new Random().nextGaussian() / 2.0, 0.0, 0.0 + (double)((float)(y * y * y) * 1.0E-5f), 0.0);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)1.85f, (float)3.75f, (entitypatch, self, params) -> {
            float t = entitypatch.getClientAnimator().baseLayer.animationPlayer.getElapsedTime();
            int i = 0;
            while ((float)i < 6.0f * ((t - 1.85f) / 1.9f)) {
                Vec3f direction = new Vec3f(0.0f, 0.0f, -2.0f);
                Vec3 position = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
                OpenMatrix4f rotation = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(0.0f), ((EvilSkeletonArmature)armature.get()).tool_R).mulFront(OpenMatrix4f.createTranslation((float)((float)position.f_82479_), (float)((float)position.f_82480_), (float)((float)position.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(0.0f))));
                rotation.translate(new Vec3f(new Random().nextGaussian() * 1.5, 0.0, new Random().nextGaussian() * 1.5));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                for (int y = 2; y < 12; ++y) {
                    ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)direction.x, (double)(direction.y - 0.6f), (double)direction.z, 0.0, 0.0 + (double)((float)(y * y * y) * 3.0E-4f), 0.0);
                }
                ++i;
            }
            int numberOf = (int)(20.0f * ((t - 1.85f) / 1.9f));
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            for (Joint joint : EvilSkeletonPatch.wings) {
                interpolation = 0.0f;
                for (int i2 = 0; i2 < numberOf; ++i2) {
                    if (joint == null) continue;
                    OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), joint).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20185_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20186_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20189_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(interpolation))));
                    float extent = 1.4f;
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_middle_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_middle_R) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_index_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_index_R)) {
                        extent = 1.6f;
                    }
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_elbow_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_elbow_R)) {
                        extent = 1.6f;
                    }
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_thumb_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_thumb_R)) {
                        extent = 1.0f;
                    }
                    transformMatrix.translate(new Vec3f(0.0f, new Random().nextFloat() * extent, 0.0f));
                    ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)transformMatrix.toTranslationVector().x + new Random().nextGaussian() * (double)0.2f, (double)transformMatrix.toTranslationVector().y + new Random().nextGaussian() * (double)0.2f, (double)transformMatrix.toTranslationVector().z + new Random().nextGaussian() * (double)0.2f, 0.0, (double)(new Random().nextFloat() * -0.05f), 0.0);
                    interpolation += partialScale;
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}));
        EVIL_SKELETON_DEMONIC_BEAM = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_demonic_beam", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.05f, 1.2f, 1.25f, 2.0f, WOMWeaponColliders.NONE, ((EvilSkeletonArmature)armature.get()).rootJoint, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.setter((float)0.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)0.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NEUTRALIZE).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, WOMParticles.ANTITHEUS_PUNCH_HIT).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, null).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, null).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (self, pose, entitypatch, time, partialTicks) -> {
            float pitch = entitypatch.getAttackDirectionPitch();
            Entity patt26305$temp = entitypatch.getOriginal();
            if (patt26305$temp instanceof EvilSkeleton) {
                EvilSkeleton evilskeleton = (EvilSkeleton)patt26305$temp;
                Entity target = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_6815_(evilskeleton.getBeamTarget());
                if (target != null) {
                    pitch = -ReuseableEvents.getYawPitch((Vec3)evilskeleton.m_20318_((float)0.0f), (Vec3)target.m_20318_((float)0.0f)).f_82471_;
                }
            }
            JointTransform chest = pose.orElseEmpty("Torso");
            chest.frontResult(JointTransform.rotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mulAsOriginInverse);
            float xRot = MathUtils.lerpBetween((float)((LivingEntity)entitypatch.getOriginal()).f_19860_, (float)((LivingEntity)entitypatch.getOriginal()).m_146909_(), (float)partialTicks);
            OpenMatrix4f toOriginalRotation = entitypatch.getArmature().getBoundTransformFor(pose, entitypatch.getArmature().searchJointByName("Head")).removeScale().removeTranslation().invert();
            Vec3f xAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.X_AXIS, null);
            OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)xAxis);
            pose.orElseEmpty("Head").frontResult(JointTransform.fromMatrix((OpenMatrix4f)headRotation), OpenMatrix4f::mul);
        }).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)0.0f, (float)1.2f, (entitypatch, animation, params) -> {
            int numberOf = 40;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            float t = entitypatch.getClientAnimator().baseLayer.animationPlayer.getElapsedTime();
            int i = 0;
            while ((float)i < (float)numberOf * (t / 1.0f)) {
                OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), ((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).head).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20185_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20186_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20189_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(interpolation))));
                transformMatrix.translate(new Vec3f(0.0f, 1.0f, -0.3f));
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)transformMatrix.toTranslationVector().x + new Random().nextGaussian() * (double)0.2f * (double)(t / 1.0f), (double)transformMatrix.toTranslationVector().y + new Random().nextGaussian() * (double)0.2f * (double)(t / 1.0f), (double)transformMatrix.toTranslationVector().z + new Random().nextGaussian() * (double)0.2f * (double)(t / 1.0f), 0.0, (double)(new Random().nextFloat() * -0.05f), 0.0);
                interpolation += partialScale;
                ++i;
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.3f, (entitypatch, animation, params) -> entitypatch.playSound((SoundEvent)EpicFightSounds.BUZZ.get(), 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)1.1f, (entitypatch, animation, params) -> {
            EvilSkeleton evilskeleton;
            Entity patt29513$temp = entitypatch.getOriginal();
            if (patt29513$temp instanceof EvilSkeleton && (evilskeleton = (EvilSkeleton)patt29513$temp).m_5448_() != null && evilskeleton.m_5448_().m_6084_()) {
                evilskeleton.setBeamTarget(evilskeleton.m_5448_().m_19879_());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)1.2f, (entitypatch, animation, params) -> {
            OpenMatrix4f rotation;
            Vec3f direction;
            double z;
            double y;
            double x;
            double phi;
            double theta;
            int i;
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7785_(((LivingEntity)entitypatch.getOriginal()).m_20185_(), ((LivingEntity)entitypatch.getOriginal()).m_20186_(), ((LivingEntity)entitypatch.getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.LASER_BLAST.get(), SoundSource.HOSTILE, 1.0f, 0.9f, false);
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(0.0f), ((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).head).mulFront(OpenMatrix4f.createTranslation((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_())).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(0.0f))));
            transformMatrix.translate(new Vec3f(0.0f, 1.0f, -0.3f));
            Vec3 ray = new OpenMatrix4f(transformMatrix).translate(new Vec3f(0.0f, 10.0f, 0.0f)).toTranslationVector().toDoubleVector();
            Entity patt30837$temp = entitypatch.getOriginal();
            if (patt30837$temp instanceof EvilSkeleton) {
                EvilSkeleton evilskeleton = (EvilSkeleton)patt30837$temp;
                Entity target = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_6815_(evilskeleton.getBeamTarget());
                if (target != null) {
                    ray = new Vec3(target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)(target.m_20206_() / 2.0f), target.m_20182_().f_82481_);
                }
            }
            Vec3 lentgh = ray.m_82546_(transformMatrix.toTranslationVector().toDoubleVector());
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7107_((ParticleOptions)WOMParticles.BLACK_LASER.get(), (double)transformMatrix.toTranslationVector().x, (double)transformMatrix.toTranslationVector().y, (double)transformMatrix.toTranslationVector().z, ray.f_82479_, ray.f_82480_, ray.f_82481_);
            int n = 40;
            double r = 0.5;
            double t = 0.02;
            for (i = 0; i < n; ++i) {
                theta = Math.PI * 2 * new Random().nextDouble();
                phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                x = r * Math.cos(phi) * Math.cos(theta);
                y = r * Math.cos(phi) * Math.sin(theta);
                z = r * Math.sin(phi);
                direction = new Vec3f((float)x, (float)y, (float)z);
                rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82470_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82471_), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(direction.x * 2.0f + transformMatrix.toTranslationVector().x) + lentgh.f_82479_ * 0.1, (double)(direction.y * 2.0f + transformMatrix.toTranslationVector().y) + lentgh.f_82480_ * 0.1, (double)(direction.z * 2.0f + transformMatrix.toTranslationVector().z) + lentgh.f_82481_ * 0.1, (double)(direction.x / 4.0f), (double)(direction.y / 4.0f), (double)(direction.z / 4.0f));
            }
            for (i = 0; i < n; ++i) {
                theta = Math.PI * 2 * new Random().nextDouble();
                phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                x = r * Math.cos(phi) * Math.cos(theta);
                y = r * Math.cos(phi) * Math.sin(theta);
                z = r * Math.sin(phi);
                direction = new Vec3f((float)x, (float)y, (float)z);
                rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82470_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82471_), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(direction.x * 1.0f + transformMatrix.toTranslationVector().x) + lentgh.f_82479_ * 0.4, (double)(direction.y * 1.0f + transformMatrix.toTranslationVector().y) + lentgh.f_82480_ * 0.4, (double)(direction.z * 1.0f + transformMatrix.toTranslationVector().z) + lentgh.f_82481_ * 0.4, (double)(direction.x / 8.0f), (double)(direction.y / 8.0f), (double)(direction.z / 8.0f));
            }
            int numberOf = 40;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            for (Joint joint : EvilSkeletonPatch.wings) {
                interpolation = 0.0f;
                for (int i2 = 0; i2 < numberOf; ++i2) {
                    if (joint == null) continue;
                    transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), joint).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20185_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20186_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20189_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(interpolation))));
                    float extent = 1.4f;
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_middle_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_middle_R) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_index_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_index_R)) {
                        extent = 1.6f;
                    }
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_elbow_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_elbow_R)) {
                        extent = 1.6f;
                    }
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_thumb_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_thumb_R)) {
                        extent = 1.0f;
                    }
                    transformMatrix.translate(new Vec3f(0.0f, new Random().nextFloat() * extent, 0.0f));
                    ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)transformMatrix.toTranslationVector().x + new Random().nextGaussian() * (double)0.2f, (double)transformMatrix.toTranslationVector().y + new Random().nextGaussian() * (double)0.2f, (double)transformMatrix.toTranslationVector().z + new Random().nextGaussian() * (double)0.2f, 0.0, (double)(new Random().nextFloat() * -0.05f), 0.0);
                    interpolation += partialScale;
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)1.2f, (entitypatch, animation, params) -> {
            LivingEntity livingEntity = (LivingEntity)entitypatch.getOriginal();
            ArrayList hurted = Lists.newArrayList();
            if (entitypatch.getTarget() != null) {
                Vec3 laserDestination = new Vec3(entitypatch.getTarget().m_20182_().f_82479_, entitypatch.getTarget().m_20182_().f_82480_ + (double)entitypatch.getTarget().m_20192_(), entitypatch.getTarget().m_20182_().f_82481_);
                LivingEntity headTarget = entitypatch.getTarget();
                OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(0.0f), ((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).head).mulFront(OpenMatrix4f.createTranslation((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_())).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(0.0f))));
                transformMatrix.translate(new Vec3f(0.0f, 1.0f, -0.3f));
                if (headTarget != null) {
                    double x = transformMatrix.toTranslationVector().x;
                    double y = transformMatrix.toTranslationVector().y;
                    double z = transformMatrix.toTranslationVector().z;
                    Vec3 direction = laserDestination.m_82492_(x, y, z);
                    Vec3 start = new Vec3(x, y, z);
                    Vec3 destination = start.m_82549_(direction.m_82541_().m_82490_(200.0));
                    BlockHitResult hitResult = livingEntity.m_9236_().m_45547_(new ClipContext(start, destination, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                    Vec3 hitLocation = hitResult.m_82450_();
                    double xLength = hitLocation.f_82479_ - x;
                    double yLength = hitLocation.f_82480_ - y;
                    double zLength = hitLocation.f_82481_ - z;
                    double horizontalDistance = Math.sqrt(xLength * xLength + zLength * zLength);
                    double length = Math.sqrt(xLength * xLength + yLength * yLength + zLength * zLength);
                    float yRot = (float)(-Math.atan2(zLength, xLength) * 57.29577951308232) - 90.0f;
                    float xRot = (float)(Math.atan2(yLength, horizontalDistance) * 57.29577951308232);
                    OBBCollider collider = new OBBCollider(0.5, 0.5, length * 0.5, 0.0, 0.0, length * 0.5);
                    collider.transform(OpenMatrix4f.createTranslation((float)((float)(-x)), (float)((float)y), (float)((float)(-z))).rotateDeg(yRot, Vec3f.Y_AXIS).rotateDeg(-xRot, Vec3f.X_AXIS));
                    List hitEntities = collider.getCollideEntities((Entity)livingEntity);
                    EpicFightDamageSource damagesource = entitypatch.getDamageSource(EVIL_SKELETON_DEMONIC_BEAM, InteractionHand.MAIN_HAND);
                    damagesource.setStunType(StunType.NEUTRALIZE);
                    damagesource.addRuntimeTag(EpicFightDamageTypeTags.GUARD_PUNCTURE);
                    damagesource.addRuntimeTag(EpicFightDamageTypeTags.FINISHER);
                    damagesource.setBaseArmorNegation(0.8f);
                    hitEntities.forEach(entity -> {
                        if (!hurted.contains(entity)) {
                            hurted.add(entity);
                            if (!(entity instanceof EvilSkeleton)) {
                                if (entitypatch.attack((EpicFightDamageSource)damagesource, (Entity)entity, (InteractionHand)InteractionHand.MAIN_HAND).resultType == AttackResult.ResultType.SUCCESS) {
                                    ((ServerLevel)livingEntity.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)WOMParticles.ANTITHEUS_PUNCH.get()), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                                }
                                if (!(entity instanceof Player)) {
                                    entity.m_7618_(EntityAnchorArgument.Anchor.FEET, livingEntity.m_20182_());
                                }
                            }
                        }
                    });
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
        EVIL_SKELETON_BLACKOUT = builder.nextAccessor("evil_skeleton/living/evil_skeleton_blackout", accessor -> (LongHitAnimation)new LongHitAnimation(0.15f, accessor, armature).newTimePair(0.0f, Float.MAX_VALUE).addStateRemoveOld(EntityState.MOVEMENT_LOCKED, (Object)true).addStateRemoveOld(EntityState.TURNING_LOCKED, (Object)true).newTimePair(4.0f, Float.MAX_VALUE).addState(EntityState.CAN_BASIC_ATTACK, (Object)true));
        EVIL_SKELETON_DEATH = builder.nextAccessor("evil_skeleton/combat/evil_skeleton_death", accessor -> (BasicMultipleAttackAnimation)new BasicMultipleAttackAnimation(0.05f, 4.0f, 4.05f, 10.0f, WOMWeaponColliders.KICK, ((EvilSkeletonArmature)armature.get()).head, (AnimationManager.AnimationAccessor<? extends BasicMultipleAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)armature).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.setter((float)0.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.setter((float)0.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.KNOCKDOWN).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, WOMParticles.ANTITHEUS_PUNCH_HIT).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, null).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, null).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.MOVE_VERTICAL, (Object)true).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)true).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.0f, Float.MAX_VALUE})).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)2.5f, (float)7.55f, (entitypatch, animation, params) -> {
            int numberOf = 90;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            float elapsed_time = entitypatch.getClientAnimator().baseLayer.animationPlayer.getElapsedTime();
            float t = (entitypatch.getClientAnimator().baseLayer.animationPlayer.getElapsedTime() - 2.5f) / 5.05f;
            float spread = 0.8f * t;
            int i = 0;
            while ((float)i < (float)numberOf * t) {
                OpenMatrix4f transformMatrix = OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20185_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)(MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20186_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation) + 7.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20189_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation));
                if (elapsed_time > 6.7f) {
                    transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), ((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).head).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20185_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20186_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20189_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(interpolation))));
                    transformMatrix.translate(new Vec3f(0.0f, 2.0f, -0.3f));
                }
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)transformMatrix.toTranslationVector().x + new Random().nextGaussian() * (double)spread, (double)transformMatrix.toTranslationVector().y + new Random().nextGaussian() * (double)spread, (double)transformMatrix.toTranslationVector().z + new Random().nextGaussian() * (double)spread, 0.0, (double)(new Random().nextFloat() * -0.05f), 0.0);
                interpolation += partialScale;
                ++i;
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InPeriodEvent.create((float)0.0f, (float)Float.MAX_VALUE, (entitypatch, animation, params) -> {
            int numberOf = 3;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            float t = Math.min(entitypatch.getClientAnimator().baseLayer.animationPlayer.getElapsedTime() / 3.0f, 1.0f);
            for (Joint joint : EvilSkeletonPatch.wings) {
                interpolation = 0.0f;
                for (int i = 0; i < numberOf; ++i) {
                    if (joint == null) continue;
                    Random random = new Random();
                    if (!(random.nextFloat() < t)) continue;
                    OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), joint).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20185_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20186_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20189_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(interpolation))));
                    float extent = 1.4f;
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_middle_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_middle_R) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_index_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_index_R)) {
                        extent = 1.6f;
                    }
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_elbow_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_elbow_R)) {
                        extent = 1.6f;
                    }
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_thumb_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_thumb_R)) {
                        extent = 1.0f;
                    }
                    transformMatrix.translate(new Vec3f(0.0f, new Random().nextFloat() * extent, 0.0f));
                    ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)transformMatrix.toTranslationVector().x + new Random().nextGaussian() * (double)0.1f, (double)transformMatrix.toTranslationVector().y + new Random().nextGaussian() * (double)0.1f, (double)transformMatrix.toTranslationVector().z + new Random().nextGaussian() * (double)0.1f, 0.0, (double)(new Random().nextFloat() * -0.05f), 0.0);
                    interpolation += partialScale;
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)6.45f, (entitypatch, animation, params) -> ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_6269_(null, entitypatch.getOriginal(), (SoundEvent)EpicFightSounds.BUZZ.get(), SoundSource.HOSTILE, 1.5f, 0.5f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)7.45f, (entitypatch, animation, params) -> {
            EvilSkeleton evilskeleton;
            Entity patt48946$temp = entitypatch.getOriginal();
            if (patt48946$temp instanceof EvilSkeleton && (evilskeleton = (EvilSkeleton)patt48946$temp).m_5448_() != null && evilskeleton.m_5448_().m_6084_()) {
                evilskeleton.setBeamTarget(evilskeleton.m_5448_().m_19879_());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)7.55f, (entitypatch, animation, params) -> {
            OpenMatrix4f rotation;
            Vec3f direction;
            double z;
            double y;
            double x;
            double phi;
            double theta;
            int i;
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7785_(((LivingEntity)entitypatch.getOriginal()).m_20185_(), ((LivingEntity)entitypatch.getOriginal()).m_20186_(), ((LivingEntity)entitypatch.getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.LASER_BLAST.get(), SoundSource.HOSTILE, 1.5f, 0.5f, false);
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(0.0f), ((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).head).mulFront(OpenMatrix4f.createTranslation((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_())).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(0.0f))));
            transformMatrix.translate(new Vec3f(0.0f, 2.0f, -0.3f));
            Vec3 ray = new OpenMatrix4f(transformMatrix).translate(new Vec3f(0.0f, 10.0f, 0.0f)).toTranslationVector().toDoubleVector();
            Entity patt50271$temp = entitypatch.getOriginal();
            if (patt50271$temp instanceof EvilSkeleton) {
                EvilSkeleton evilskeleton = (EvilSkeleton)patt50271$temp;
                Entity target = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_6815_(evilskeleton.getBeamTarget());
                if (target != null) {
                    ray = new Vec3(target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)(target.m_20206_() / 2.0f), target.m_20182_().f_82481_);
                }
            }
            Vec3 lentgh = ray.m_82546_(transformMatrix.toTranslationVector().toDoubleVector());
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7107_((ParticleOptions)WOMParticles.BLACK_RAY.get(), (double)transformMatrix.toTranslationVector().x, (double)transformMatrix.toTranslationVector().y, (double)transformMatrix.toTranslationVector().z, ray.f_82479_, ray.f_82480_, ray.f_82481_);
            int n = 80;
            double r = 1.5;
            double t = 0.02;
            for (i = 0; i < n; ++i) {
                theta = Math.PI * 2 * new Random().nextDouble();
                phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                x = r * Math.cos(phi) * Math.cos(theta);
                y = r * Math.cos(phi) * Math.sin(theta);
                z = r * Math.sin(phi);
                direction = new Vec3f((float)x, (float)y, (float)z);
                rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82470_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82471_), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)(direction.x * 3.0f + transformMatrix.toTranslationVector().x) + lentgh.f_82479_ * 0.1, (double)(direction.y * 3.0f + transformMatrix.toTranslationVector().y) + lentgh.f_82480_ * 0.1, (double)(direction.z * 3.0f + transformMatrix.toTranslationVector().z) + lentgh.f_82481_ * 0.1, (double)(direction.x / 8.0f), (double)(direction.y / 8.0f - 0.1f), (double)(direction.z / 8.0f));
            }
            for (i = 0; i < n; ++i) {
                theta = Math.PI * 2 * new Random().nextDouble();
                phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                x = r * Math.cos(phi) * Math.cos(theta);
                y = r * Math.cos(phi) * Math.sin(theta);
                z = r * Math.sin(phi);
                direction = new Vec3f((float)x, (float)y, (float)z);
                rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82470_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82471_), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)(direction.x * 2.0f + transformMatrix.toTranslationVector().x) + lentgh.f_82479_ * 0.3, (double)(direction.y * 2.0f + transformMatrix.toTranslationVector().y) + lentgh.f_82480_ * 0.3, (double)(direction.z * 2.0f + transformMatrix.toTranslationVector().z) + lentgh.f_82481_ * 0.3, (double)(direction.x / 16.0f), (double)(direction.y / 16.0f - 0.1f), (double)(direction.z / 16.0f));
            }
            for (i = 0; i < n; ++i) {
                theta = Math.PI * 2 * new Random().nextDouble();
                phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                x = r * Math.cos(phi) * Math.cos(theta);
                y = r * Math.cos(phi) * Math.sin(theta);
                z = r * Math.sin(phi);
                direction = new Vec3f((float)x, (float)y, (float)z);
                rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82470_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(ReuseableEvents.getYawPitch((Vec3)transformMatrix.toTranslationVector().toDoubleVector(), (Vec3)ray).f_82471_), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)(direction.x * 1.0f + transformMatrix.toTranslationVector().x) + lentgh.f_82479_ * 0.5, (double)(direction.y * 1.0f + transformMatrix.toTranslationVector().y) + lentgh.f_82480_ * 0.5, (double)(direction.z * 1.0f + transformMatrix.toTranslationVector().z) + lentgh.f_82481_ * 0.5, (double)(direction.x / 24.0f), (double)(direction.y / 24.0f - 0.1f), (double)(direction.z / 24.0f));
            }
            int numberOf = 60;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            for (Joint joint : EvilSkeletonPatch.wings) {
                interpolation = 0.0f;
                for (int i2 = 0; i2 < numberOf; ++i2) {
                    if (joint == null) continue;
                    transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), joint).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20185_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20186_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entitypatch.getOriginal()).m_20189_() + ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(interpolation))));
                    float extent = 1.4f;
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_middle_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_middle_R) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_index_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_index_R)) {
                        extent = 1.6f;
                    }
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_elbow_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_elbow_R)) {
                        extent = 1.6f;
                    }
                    if (joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_thumb_L) || joint.equals((Object)((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).wing_thumb_R)) {
                        extent = 1.0f;
                    }
                    transformMatrix.translate(new Vec3f(0.0f, new Random().nextFloat() * extent, 0.0f));
                    ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)transformMatrix.toTranslationVector().x + new Random().nextGaussian() * (double)0.4f, (double)transformMatrix.toTranslationVector().y + new Random().nextGaussian() * (double)0.4f, (double)transformMatrix.toTranslationVector().z + new Random().nextGaussian() * (double)0.4f, new Random().nextGaussian() * (double)0.02f, new Random().nextGaussian() * (double)0.02f + (double)(new Random().nextFloat() * -0.05f), new Random().nextGaussian() * (double)0.02f);
                    interpolation += partialScale;
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)7.55f, (entitypatch, animation, params) -> {
            LivingEntity livingEntity = (LivingEntity)entitypatch.getOriginal();
            ArrayList hurted = Lists.newArrayList();
            if (entitypatch.getTarget() != null) {
                Vec3 laserDestination = new Vec3(entitypatch.getTarget().m_20182_().f_82479_, entitypatch.getTarget().m_20182_().f_82480_ + (double)entitypatch.getTarget().m_20192_(), entitypatch.getTarget().m_20182_().f_82481_);
                LivingEntity headTarget = entitypatch.getTarget();
                OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(0.0f), ((EvilSkeletonArmature)WOMArmatures.EVIL_SKELETON.get()).head).mulFront(OpenMatrix4f.createTranslation((float)((float)((LivingEntity)entitypatch.getOriginal()).m_20185_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20189_())).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(0.0f))));
                transformMatrix.translate(new Vec3f(0.0f, 1.0f, -0.3f));
                if (headTarget != null) {
                    double x = transformMatrix.toTranslationVector().x;
                    double y = transformMatrix.toTranslationVector().y;
                    double z = transformMatrix.toTranslationVector().z;
                    Vec3 direction = laserDestination.m_82492_(x, y, z);
                    Vec3 start = new Vec3(x, y, z);
                    Vec3 destination = start.m_82549_(direction.m_82541_().m_82490_(200.0));
                    BlockHitResult hitResult = livingEntity.m_9236_().m_45547_(new ClipContext(start, destination, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                    Vec3 hitLocation = hitResult.m_82450_();
                    double xLength = hitLocation.f_82479_ - x;
                    double yLength = hitLocation.f_82480_ - y;
                    double zLength = hitLocation.f_82481_ - z;
                    double horizontalDistance = Math.sqrt(xLength * xLength + zLength * zLength);
                    double length = Math.sqrt(xLength * xLength + yLength * yLength + zLength * zLength);
                    float yRot = (float)(-Math.atan2(zLength, xLength) * 57.29577951308232) - 90.0f;
                    float xRot = (float)(Math.atan2(yLength, horizontalDistance) * 57.29577951308232);
                    OBBCollider collider = new OBBCollider(1.5, 1.5, length * 0.5, 0.0, 0.0, length * 0.5);
                    collider.transform(OpenMatrix4f.createTranslation((float)((float)(-x)), (float)((float)y), (float)((float)(-z))).rotateDeg(yRot, Vec3f.Y_AXIS).rotateDeg(-xRot, Vec3f.X_AXIS));
                    List hitEntities = collider.getCollideEntities((Entity)livingEntity);
                    EpicFightDamageSource damagesource = entitypatch.getDamageSource(EVIL_SKELETON_DEATH, InteractionHand.MAIN_HAND);
                    damagesource.setStunType(StunType.KNOCKDOWN);
                    damagesource.addRuntimeTag(EpicFightDamageTypeTags.BYPASS_DODGE);
                    damagesource.addRuntimeTag(EpicFightDamageTypeTags.GUARD_PUNCTURE);
                    damagesource.addRuntimeTag(EpicFightDamageTypeTags.FINISHER);
                    damagesource.setBaseArmorNegation(0.8f);
                    damagesource.attachDamageModifier(ValueModifier.multiplier((float)10.0f));
                    hitEntities.forEach(entity -> {
                        if (!hurted.contains(entity)) {
                            hurted.add(entity);
                            if (!(entity instanceof EvilSkeleton)) {
                                if (entitypatch.attack((EpicFightDamageSource)damagesource, (Entity)entity, (InteractionHand)InteractionHand.MAIN_HAND).resultType == AttackResult.ResultType.SUCCESS) {
                                    ((ServerLevel)livingEntity.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)WOMParticles.ANTITHEUS_BLACKHOLE_END.get()), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                                }
                                if (!(entity instanceof Player)) {
                                    entity.m_7618_(EntityAnchorArgument.Anchor.FEET, livingEntity.m_20182_());
                                }
                            }
                        }
                    });
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)7.65f, (entitypatch, animation, params) -> {
            Entity patt63316$temp = entitypatch.getOriginal();
            if (patt63316$temp instanceof EvilSkeleton) {
                EvilSkeleton evilskeleton = (EvilSkeleton)patt63316$temp;
                evilskeleton.setBeamTarget(0);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
    }
}

