/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.main;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import reascer.wom.config.WOMConfigManager;
import reascer.wom.config.WOMConfigurationIngame;
import reascer.wom.gameasset.WOMArmatures;
import reascer.wom.gameasset.WOMEnchantment;
import reascer.wom.gameasset.WOMSounds;
import reascer.wom.particle.WOMParticles;
import reascer.wom.potion.WOMPotions;
import reascer.wom.potion.WomBrewingRecipe;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.ai.attribute.WOMAttributes;
import reascer.wom.world.gamerules.WOMGamerules;
import reascer.wom.world.item.WOMCreativeTabs;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.main.EpicFightExtensions;

@Mod(value="wom")
public class WeaponsOfMinecraft {
    public static final String MODID = "wom";
    public static final String CONFIG_FILE_PATH = "wom.toml";
    public static final Logger LOGGER = LogManager.getLogger((String)"wom");
    public static WOMConfigurationIngame CLIENT_INGAME_CONFIG;

    public WeaponsOfMinecraft(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)WOMConfigManager.CLIENT_CONFIG);
        IEventBus bus = context.getModEventBus();
        bus.addListener(this::doClientStuff);
        bus.addListener(this::doCommonStuff);
        bus.addListener(WOMAttributes::modifyExistingMobs);
        WOMItems.ITEMS.register(bus);
        WOMParticles.PARTICLES.register(bus);
        WOMEnchantment.ENCHANTEMENTS.register(bus);
        WOMEntities.ENTITIES.register(bus);
        WOMSounds.SOUNDS.register(bus);
        WOMCreativeTabs.TABS.register(bus);
        WOMSkillDataKeys.DATA_KEYS.register(bus);
        WOMPotions.POTIONS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        WOMConfigManager.loadConfig(WOMConfigManager.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("wom-client.toml").toString());
        WOMConfigManager.loadConfig(WOMConfigManager.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE_PATH).toString());
        context.registerExtensionPoint(EpicFightExtensions.class, () -> new EpicFightExtensions(WOMCreativeTabs.ITEMS));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        CLIENT_INGAME_CONFIG = new WOMConfigurationIngame();
        event.enqueueWork(() -> {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43604_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_NIGHT_VISION.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43606_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_INVISIBILITY.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43609_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_JUMP_BOOST.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43608_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_JUMP_BOOST.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43611_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_FIRE_RESISTANCE.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43614_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_SPEED.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43613_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_SPEED.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43617_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_SLOWNESS.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43616_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_SLOWNESS.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43622_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_WATER_BREATHING.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43581_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_INSTANT_HEALTH.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43583_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_INSTANT_DAMAGE.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43586_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_POISON.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43585_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_POISON.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43589_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_REGENERATION.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43588_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_REGENERATION.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43592_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_STRENGTH.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43591_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_STRENGTH.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43594_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_WEAKNESS.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43597_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_SLOW_FALLING.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43620_, WOMItems.ClAW.get(), (Potion)WOMPotions.STRONGER_TURTLE_MASTER.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WomBrewingRecipe(Potions.f_43619_, WOMItems.FUR.get(), (Potion)WOMPotions.LONGER_TURTLE_MASTER.get()));
        });
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(WOMGamerules::registerRules);
        event.enqueueWork(WOMArmatures::registerEntityTypes);
    }

    @NotNull
    public static ResourceLocation identifier(@NotNull String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

