/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.particle;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.ReuseableEvents;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ParticlesTools {
    public static OpenMatrix4f getJointPos(Joint joint, LivingEntityPatch<?> entityPatch, float interpolation) {
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(interpolation), joint).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20185_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20186_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20189_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entityPatch.getModelMatrix(interpolation))));
        return transformMatrix;
    }

    public static void particle_aura(ParticleOptions particle, LivingEntityPatch<?> entityPatch, Joint joint, int amount, Vec3f offset, Vec3f spread, boolean gaussian) {
        float partialScale = 1.0f / (float)(amount - 1);
        float interpolation = 0.0f;
        if (offset == null) {
            offset = new Vec3f(0.0f, 0.0f, 0.0f);
        }
        if (spread == null) {
            spread = new Vec3f(0.0f, 0.0f, 0.0f);
        }
        for (int i = 0; i < amount; ++i) {
            OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(interpolation), joint).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20185_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82479_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20186_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82480_)), (float)interpolation), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20189_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82481_)), (float)interpolation)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entityPatch.getModelMatrix(interpolation))));
            transformMatrix.translate(new Vec3f((double)offset.x + (gaussian ? new Random().nextGaussian() : (double)(new Random().nextFloat() - 0.5f)) * (double)spread.x, (double)offset.y + (gaussian ? new Random().nextGaussian() : (double)(new Random().nextFloat() - 0.5f)) * (double)spread.y, (double)offset.z + (gaussian ? new Random().nextGaussian() : (double)(new Random().nextFloat() - 0.5f)) * (double)spread.z));
            ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particle, (double)transformMatrix.toTranslationVector().x, (double)transformMatrix.toTranslationVector().y, (double)transformMatrix.toTranslationVector().z, 0.0, 0.0, 0.0);
            interpolation += partialScale;
        }
    }

    public static void particle_circle(ParticleOptions particle, LivingEntityPatch<?> entityPatch, Level level, Joint joint, int amount, float radius, float thickness, float expend, Vec3f offset, Vec3f spread, Vec2f facing, boolean gaussian, boolean fill) {
        if (offset == null) {
            offset = new Vec3f(0.0f, 0.0f, 0.0f);
        }
        if (spread == null) {
            spread = new Vec3f(0.0f, 0.0f, 0.0f);
        }
        if (facing == null) {
            facing = new Vec2f(0.0f, 10.0f);
        }
        OpenMatrix4f transformMatrix = new OpenMatrix4f();
        if (joint != null && entityPatch != null) {
            if (level == null) {
                level = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
            }
            transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(0.0f), joint).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20185_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82479_)), (float)0.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20186_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82480_)), (float)0.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20189_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82481_)), (float)0.0f)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entityPatch.getModelMatrix(0.0f))));
        } else if (entityPatch != null) {
            transformMatrix = new OpenMatrix4f(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20185_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82479_)), (float)0.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20186_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82480_)), (float)0.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20189_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82481_)), (float)0.0f)));
        }
        int n = amount;
        double r = radius;
        double e = expend;
        double t = thickness;
        for (int i = 0; i < n; ++i) {
            if (fill) {
                r = (double)radius * Math.sqrt(new Random().nextFloat());
                e = (double)expend * Math.sqrt(new Random().nextFloat());
            }
            double theta = Math.PI * 2 * new Random().nextDouble();
            double phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
            if (gaussian) {
                theta = Math.PI * 2 * (double)((float)i / (float)n);
                phi = ((double)((float)i / (float)n) - 0.5) * Math.PI * t / r;
            }
            double x = r * Math.cos(phi) * Math.cos(theta);
            double y = r * Math.cos(phi) * Math.sin(theta);
            double z = r * Math.sin(phi);
            double xE = e * Math.cos(phi) * Math.cos(theta);
            double yE = e * Math.cos(phi) * Math.sin(theta);
            double zE = e * Math.sin(phi);
            Vec3f direction = new Vec3f((float)x + offset.x, (float)y + offset.y, (float)z + offset.z);
            Vec3f directionE = new Vec3f((float)xE, (float)yE, (float)zE);
            OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(facing.x)), new Vec3f(0.0f, 1.0f, 0.0f));
            rotation.rotate((float)Math.toRadians(facing.y), new Vec3f(1.0f, 0.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
            OpenMatrix4f rotationE = new OpenMatrix4f().rotate(-((float)Math.toRadians(facing.x)), new Vec3f(0.0f, 1.0f, 0.0f));
            rotationE.rotate((float)Math.toRadians(facing.y), new Vec3f(1.0f, 0.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotationE, (Vec3f)directionE, (Vec3f)directionE);
            level.m_7106_(particle, (double)(direction.x + transformMatrix.toTranslationVector().x), (double)(direction.y + transformMatrix.toTranslationVector().y), (double)(direction.z + transformMatrix.toTranslationVector().z), (double)(directionE.x + spread.x), (double)(directionE.y + spread.y), (double)(directionE.z + spread.z));
        }
    }

    public static void particle_circle_server(ParticleOptions particle, LivingEntityPatch<?> entityPatch, ServerLevel level, Joint joint, int amount, float radius, float thickness, float expend, Vec3f offset, Vec3f spread, Vec2f facing, boolean gaussian, boolean fill) {
        if (offset == null) {
            offset = new Vec3f(0.0f, 0.0f, 0.0f);
        }
        if (spread == null) {
            spread = new Vec3f(0.0f, 0.0f, 0.0f);
        }
        OpenMatrix4f transformMatrix = new OpenMatrix4f();
        if (joint != null && entityPatch != null) {
            transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(0.0f), joint).mulFront(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20185_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82479_)), (float)0.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20186_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82480_)), (float)0.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20189_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82481_)), (float)0.0f)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entityPatch.getModelMatrix(0.0f))));
        } else if (entityPatch != null) {
            transformMatrix = new OpenMatrix4f(OpenMatrix4f.createTranslation((float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20185_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20185_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82479_)), (float)0.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20186_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20186_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82480_)), (float)0.0f), (float)MathUtils.lerpBetween((float)((float)((LivingEntity)entityPatch.getOriginal()).m_20189_()), (float)((float)(((LivingEntity)entityPatch.getOriginal()).m_20189_() + ((LivingEntity)entityPatch.getOriginal()).m_20184_().f_82481_)), (float)0.0f)));
        }
        transformMatrix.translate(new Vec3f((double)offset.x + (gaussian ? new Random().nextGaussian() : (double)(new Random().nextFloat() - 0.5f)) * (double)spread.x, (double)offset.y + (gaussian ? new Random().nextGaussian() : (double)(new Random().nextFloat() - 0.5f)) * (double)spread.y, (double)offset.z + (gaussian ? new Random().nextGaussian() : (double)(new Random().nextFloat() - 0.5f)) * (double)spread.z));
        if (facing == null) {
            facing = new Vec2f();
            Vec3 ray = new OpenMatrix4f(transformMatrix).translate(new Vec3f(0.0f, 0.0f, 10.0f)).toTranslationVector().toDoubleVector();
            facing = ReuseableEvents.getYawPitchF(transformMatrix.toTranslationVector().toDoubleVector(), ray);
        }
        int n = amount;
        double r = radius;
        double t = thickness;
        for (int i = 0; i < n; ++i) {
            if (fill) {
                r = (double)radius * Math.sqrt(new Random().nextFloat());
            }
            double theta = Math.PI * 2 * new Random().nextDouble();
            double phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
            double x = r * Math.cos(phi) * Math.cos(theta);
            double y = r * Math.cos(phi) * Math.sin(theta);
            double z = r * Math.sin(phi);
            Vec3f direction = new Vec3f((float)x, (float)y, (float)z);
            OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(facing.x)), new Vec3f(0.0f, 1.0f, 0.0f));
            rotation.rotate((float)Math.toRadians(facing.y), new Vec3f(1.0f, 0.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
            level.m_8767_(particle, (double)(direction.x + transformMatrix.toTranslationVector().x), (double)(direction.y + transformMatrix.toTranslationVector().y), (double)(direction.z + transformMatrix.toTranslationVector().z), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

