/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.animation.dodges.CancelableDodgeAnimation;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class EnderStepSkill
extends DodgeSkill {
    public EnderStepSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(SkillContainer container, FriendlyByteBuf args) {
        PlayerPatch entitypatch = container.getExecutor();
        Player entity = (Player)entitypatch.getOriginal();
        ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)EpicFightParticles.WHITE_AFTERIMAGE.get(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Double.longBitsToDouble(entity.m_19879_()), 0.0, 0.0);
        Input input = ((LocalPlayer)container.getExecutor().getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)container.getExecutor().getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        Minecraft instance = Minecraft.m_91087_();
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = instance.f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        int animation = vertic == 0 ? (horizon == 0 ? 0 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPSkillRequest packet = new CPSkillRequest(container.getSlot());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        container.activate();
        int i = args.readInt();
        float yaw = args.readFloat();
        ServerPlayerPatch entitypatch = container.getServerExecutor();
        Player entity = (Player)entitypatch.getOriginal();
        ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123789_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 60, (double)(entity.m_20205_() / 2.0f), (double)entity.m_20206_() * 0.5, (double)(entity.m_20205_() / 2.0f), 0.1);
        entity.m_9236_().m_6263_(null, entity.f_19854_, entity.f_19855_ + 1.0, entity.f_19856_, SoundEvents.f_11852_, entity.m_5720_(), 2.0f, 1.0f - (new Random().nextFloat() - 0.5f) * 0.2f);
        if (container.getExecutor().getSkill(WOMSkills.ENDER_ARCANE) != null) {
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.animations[i], -0.1f - 0.15f * ((float)((Integer)entitypatch.getSkill(WOMSkills.ENDER_ARCANE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STRENGHT.get())).intValue() / 40.0f));
        } else {
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.animations[i], 0.0f);
        }
        container.getExecutor().setModelYRot(yaw, true);
    }

    public boolean canExecute(SkillContainer container) {
        boolean isDodging = false;
        PlayerPatch playerpatch = container.getExecutor();
        if (playerpatch.isLogicalClient()) {
            if (playerpatch.getClientAnimator().baseLayer.animationPlayer.getAnimation().get() instanceof CancelableDodgeAnimation) {
                isDodging = true;
            }
        } else if (playerpatch.getServerAnimator().animationPlayer.getAnimation().get() instanceof CancelableDodgeAnimation) {
            isDodging = true;
        }
        return !isDodging && super.canExecute(container);
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.STEP;
    }
}

