/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.animation.dodges.CancelableDodgeAnimation;
import reascer.wom.gameasset.WOMSkills;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class ShadowStepSkill
extends DodgeSkill {
    public ShadowStepSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.STEP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(SkillContainer skillConatainer, FriendlyByteBuf args) {
        Input input = ((LocalPlayer)skillConatainer.getClientExecutor().getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)skillConatainer.getExecutor().getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        Minecraft instance = Minecraft.m_91087_();
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = instance.f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        int animation = vertic == 0 ? (horizon == 0 ? 0 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPSkillRequest packet = new CPSkillRequest(skillConatainer.getSlot());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        container.activate();
        int i = args.readInt();
        float yRot = args.readFloat();
        if (container.getExecutor().getSkill(WOMSkills.DEMONIC_ASCENSION) != null) {
            Player entity = (Player)container.getExecutor().getOriginal();
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, entity.f_19854_, entity.f_19855_ + 1.0, entity.f_19856_, 40, 0.0, 0.0, 0.0, 0.1);
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity.f_19854_, entity.f_19855_ + 1.0, entity.f_19856_, 10, 0.45, 0.45, 0.45, 0.05);
            entity.m_9236_().m_6263_(null, entity.f_19854_, entity.f_19855_ + 1.0, entity.f_19856_, SoundEvents.f_12558_, entity.m_5720_(), 1.0f, 1.0f - (new Random().nextFloat() - 0.5f) * 0.2f);
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.animations[i], -0.2f);
        } else {
            container.getExecutor().playAnimationSynchronized((AssetAccessor)this.animations[i], 0.0f);
        }
        container.getExecutor().setModelYRot(yRot, true);
    }

    public boolean canExecute(SkillContainer container) {
        boolean isDodging = false;
        PlayerPatch playerpatch = container.getExecutor();
        if (playerpatch.isLogicalClient()) {
            if (playerpatch.getClientAnimator().baseLayer.animationPlayer.getAnimation().get() instanceof CancelableDodgeAnimation) {
                isDodging = true;
            }
        } else if (playerpatch.getServerAnimator().animationPlayer.getAnimation().get() instanceof CancelableDodgeAnimation) {
            isDodging = true;
        }
        return !isDodging && super.canExecute(container);
    }
}

