/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.animation.attacks.UltimateAttackAnimation;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class TimeTravelSkill
extends DodgeSkill {
    private static final UUID EVENT_UUID = UUID.fromString("691d9d1e-05ce-11ed-b939-0242ac120002");

    public TimeTravelSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.REGISTERED_HEALTH.get(), (Object)Float.valueOf(((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.REGISTERED_HEALTH.get())).floatValue() + event.getDamage())));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0) {
            container.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, 12.0f);
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)100);
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.REGISTERED_POSITION.get(), (Object)new Vec3f((float)((Player)container.getExecutor().getOriginal()).m_20182_().f_82479_, (float)((Player)container.getExecutor().getOriginal()).m_20182_().f_82480_, (float)((Player)container.getExecutor().getOriginal()).m_20182_().f_82481_));
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.REGISTERED_HEALTH.get(), (Object)Float.valueOf(((Player)container.getExecutor().getOriginal()).m_21223_()));
        } else {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get())));
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)1);
        }
    }

    public Skill getPriorSkill() {
        return WOMSkills.SHADOWSTEP;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        if (executer.getStamina() < 12.0f && executer.getStamina() != 0.0f) {
            executer.setStamina(0.0f);
            return true;
        }
        if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
            if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0) {
                return executer.getEntityState().canBasicAttack() && executer.getEntityState().canUseSkill();
            }
            return true;
        }
        ((Player)executer.getOriginal()).m_5496_(SoundEvents.f_12031_, 1.0f, 2.0f);
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0 || (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getSkillTexture());
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String damage = String.valueOf((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) / 20 + 1);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            damage = String.valueOf((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) / 20 + 1);
        }
        guiGraphics.drawString(gui.getFont(), damage, x + 9.0f, y + 7.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.cooldown.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.cooldown.consume", (Object[])new Object[]{ItemStack.f_41584_.format(3.0)}), SkillBookScreen.COOLDOWN_TEXTURE_INFO);
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.stamina.consume", (Object[])new Object[]{ItemStack.f_41584_.format(this.consumption)}), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0 && !(container.getExecutor().getServerAnimator().animationPlayer.getAnimation() instanceof UltimateAttackAnimation)) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1));
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0) {
                    container.getExecutor().playAnimationSynchronized(WOMAnimations.TIME_TRAVEL, 0.0f);
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)100);
                    }
                }
                if (((Player)container.getExecutor().getOriginal()).m_6047_()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)0);
                }
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
            }
        } else if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
            Vec3f posVec3f = (Vec3f)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.REGISTERED_POSITION.get());
            int n = 5;
            double r = 2.0;
            double t = 0.01;
            int timer = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get());
            for (int i = 0; i < n; ++i) {
                double theta = Math.PI * 2 * (double)(((float)i + 1.0f) / (float)n) + ((double)((float)timer * 0.07f) + Math.sin((float)timer * 0.05f)) * 2.0;
                double phi = (double)(((float)i + 1.0f) / (float)n - 0.5f) * Math.PI * t / r;
                double x = r * Math.cos(phi) * Math.cos(theta);
                double y = r * Math.cos(phi) * Math.sin(theta);
                double z = r * Math.sin(phi);
                Vec3f direction = new Vec3f((float)x, (float)y, (float)z);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate((float)Math.toRadians(90.0), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                Minecraft mc = Minecraft.m_91087_();
                Particle end_rod = mc.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123809_, (double)(posVec3f.x + direction.x), (double)(posVec3f.y + 5.0f), (double)(posVec3f.z + direction.z), 0.0, -5.0, 0.0);
                end_rod.m_6569_(2.0f);
            }
        }
    }
}

