/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.identity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.action.InputAction;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class AvatarOfMightSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("e55978de-4a66-4e4a-b1fb-0e31ee89a031");

    public AvatarOfMightSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) != 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)120);
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 40 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0 && container.getExecutor().getStamina() > 0.0f) {
                if (!container.getExecutor().hasStamina(12.0f)) {
                    container.getExecutor().setStamina(0.0f);
                } else {
                    container.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, 12.0f);
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)0);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)120);
                if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21195_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get());
                }
                ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 100, 0, true, false, false));
                container.getExecutor().playAnimationSynchronized(WOMAnimations.AVATAR_OF_MIGHT, 0.0f);
                DamageSource patt3309$temp = event.getDamageSource();
                if (patt3309$temp instanceof EpicFightDamageSource) {
                    EpicFightDamageSource efds = (EpicFightDamageSource)patt3309$temp;
                    efds.setStunType(StunType.NONE);
                }
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_12359_, ((Player)container.getExecutor().getOriginal()).m_5720_(), 2.0f, 1.6f);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_() + 0.75, ((Player)container.getExecutor().getOriginal()).m_20189_(), 60, 0.0, 0.0, 0.0, 0.5);
                AABB box = AABB.m_165882_((Vec3)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_(), (double)20.0, (double)20.0, (double)20.0);
                List list = ((Player)container.getExecutor().getOriginal()).m_9236_().m_45933_(container.getExecutor().getOriginal(), box);
                for (Entity entity : list) {
                    if (!(entity.m_20270_(container.getExecutor().getOriginal()) < 10.0f)) continue;
                    double power = 1.0;
                    double d1 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7096_() - entity.m_20185_();
                    double d2 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7098_() - entity.m_20186_();
                    double d0 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7094_() - entity.m_20189_();
                    while (d1 * d1 + d0 * d0 < 1.0E-4) {
                        d1 = (Math.random() - Math.random()) * 0.01;
                        d0 = (Math.random() - Math.random()) * 0.01;
                    }
                    if (!(entity instanceof LivingEntity) || entity instanceof OwnableEntity) continue;
                    entity.f_19812_ = true;
                    Vec3 vec3 = entity.m_20184_();
                    Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power *= 1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_));
                    entity.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getSkillTexture());
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
            int value = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get());
            String string = String.valueOf(value / 20 + "." + value % 20 / 2);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.drawString(gui.getFont(), string, x + 12.0f - (float)(gui.getFont().m_92895_(string) / 2), y + 13.0f, 0xFFFFFF, true);
        } else {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            }
            guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int value = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get());
                String string = String.valueOf(value / 20 + "." + value % 20 / 2);
                guiGraphics.drawString(gui.getFont(), string, x + 12.0f - (float)(gui.getFont().m_92895_(string) / 2), y + 13.0f, 0xFFFFFF, true);
            }
        }
        poseStack.m_85849_();
    }

    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.cooldown.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.cooldown.consume", (Object[])new Object[]{ItemStack.f_41584_.format(6.0)}), SkillBookScreen.COOLDOWN_TEXTURE_INFO);
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.stamina.consume", (Object[])new Object[]{ItemStack.f_41584_.format(12L)}), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient()) {
            if (InputManager.isActionActive((InputAction)MinecraftInputAction.SNEAK) && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) < 40) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) + 1));
                }
            } else if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) != 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)0);
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
            }
        }
    }
}

