/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.identity;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.item.BraceletsItem;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ShootingStyleSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("c7ed25cc-62fb-4ad6-8543-4034448376aa");
    public static AnimationManager.AnimationAccessor<? extends AttackAnimation>[] combo;

    public ShootingStyleSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
        combo = this.setAnimations(WOMAnimations.KICK_AUTO_1, WOMAnimations.KICK_AUTO_2, WOMAnimations.KICK_AUTO_3);
    }

    @SafeVarargs
    private AnimationManager.AnimationAccessor<? extends AttackAnimation>[] setAnimations(AnimationManager.AnimationAccessor<? extends AttackAnimation> ... animations) {
        return animations;
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            ItemStack mainhandItemStack = ((ServerPlayer)container.getServerExecutor().getOriginal()).m_21205_();
            if ((mainhandItemStack.m_41619_() || !mainhandItemStack.m_41619_() && (mainhandItemStack.m_41720_() instanceof BraceletsItem || container.getServerExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.FIST)) && ((ServerPlayer)container.getServerExecutor().getOriginal()).m_36341_() && container.getServerExecutor().getEntityState().canBasicAttack()) {
                event.setCanceled(true);
                container.getServerExecutor().playAnimationSynchronized(combo[(Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get())], 0.0f);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)((1 + (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get())) % 3));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)30));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0);
            }
        }
    }
}

