/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.mover;

import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector3f;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.colliders.WOMWeaponColliders;
import reascer.wom.particle.ParticlesTools;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.action.InputAction;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class NaturalSprinterSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("ff4abdd7-bf45-48fa-902e-7da96af43670");
    private AttributeModifier sprint_movespeed = new AttributeModifier(EVENT_UUID, "natural_sprinter.sprint_movespeed", (double)0.2f, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public NaturalSprinterSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!(event.getAnimation().equals(WOMAnimations.BIPED_SPRINT) || event.getAnimation().equals(WOMAnimations.BIPED_SPRINT_BAREHAND) || event.getAnimation().equals(WOMAnimations.BIPED_SPRINT_LEFT_STEP) || event.getAnimation().equals(WOMAnimations.BIPED_SPRINT_RIGHT_STEP) || event.getAnimation().equals(WOMAnimations.BIPED_SPRINT_LEFT_STEP_BAREHAND) || event.getAnimation().equals(WOMAnimations.BIPED_SPRINT_RIGHT_STEP_BAREHAND) || event.getAnimation().equals(WOMAnimations.BIPED_SPRINT_SLIDE) || event.getAnimation().equals(WOMAnimations.BIPED_SPRINT_JUMP) || event.getAnimation().equals(WOMAnimations.BIPED_SPRINT_STOP))) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((Player)container.getExecutor().getOriginal()).m_20142_() && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
                AssetAccessor current_anim = container.getExecutor().getClientAnimator().baseLayer.animationPlayer.getRealAnimation();
                Minecraft minecraft = Minecraft.m_91087_();
                WeaponCategory inhand = ((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory();
                boolean isBarehand = false;
                if (inhand == CapabilityItem.WeaponCategories.FIST || inhand == CapabilityItem.WeaponCategories.DAGGER || inhand == WOMWeaponCategories.ENDERBLASTER || inhand == CapabilityItem.WeaponCategories.HOE || inhand == CapabilityItem.WeaponCategories.AXE || inhand == CapabilityItem.WeaponCategories.PICKAXE || inhand == CapabilityItem.WeaponCategories.SHOVEL || inhand == CapabilityItem.WeaponCategories.NOT_WEAPON) {
                    isBarehand = true;
                }
                if (((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                    isBarehand = true;
                }
                if (isBarehand) {
                    if (!(current_anim.equals(WOMAnimations.BIPED_SPRINT_BAREHAND) || current_anim.equals(WOMAnimations.BIPED_SPRINT_LEFT_STEP) || current_anim.equals(WOMAnimations.BIPED_SPRINT_RIGHT_STEP) || current_anim.equals(WOMAnimations.BIPED_SPRINT_LEFT_STEP_BAREHAND) || current_anim.equals(WOMAnimations.BIPED_SPRINT_RIGHT_STEP_BAREHAND) || current_anim.equals(WOMAnimations.BIPED_SPRINT_SLIDE) || current_anim.equals(WOMAnimations.BIPED_SPRINT_JUMP) || current_anim.equals(WOMAnimations.BIPED_SPRINT_STOP))) {
                        ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationInClientSide(WOMAnimations.BIPED_SPRINT_BAREHAND, 0.0f);
                    }
                } else if (!(current_anim.equals(WOMAnimations.BIPED_SPRINT) || current_anim.equals(WOMAnimations.BIPED_SPRINT_LEFT_STEP) || current_anim.equals(WOMAnimations.BIPED_SPRINT_RIGHT_STEP) || current_anim.equals(WOMAnimations.BIPED_SPRINT_LEFT_STEP_BAREHAND) || current_anim.equals(WOMAnimations.BIPED_SPRINT_RIGHT_STEP_BAREHAND) || current_anim.equals(WOMAnimations.BIPED_SPRINT_SLIDE) || current_anim.equals(WOMAnimations.BIPED_SPRINT_JUMP) || current_anim.equals(WOMAnimations.BIPED_SPRINT_STOP))) {
                    ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationInClientSide(WOMAnimations.BIPED_SPRINT, 0.0f);
                }
                if (InputManager.isActionActive((InputAction)MinecraftInputAction.SNEAK) && !current_anim.equals(WOMAnimations.BIPED_SPRINT_SLIDE)) {
                    ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(WOMAnimations.BIPED_SPRINT_SLIDE, 0.0f);
                }
                if (InputManager.isActionActive((InputAction)MinecraftInputAction.JUMP) && ((Player)container.getExecutor().getOriginal()).m_20096_()) {
                    Vec3 deltaMove = ((Player)container.getExecutor().getOriginal()).m_20184_();
                    ((Player)container.getExecutor().getOriginal()).m_20334_(deltaMove.f_82479_ * 1.2, 0.45, deltaMove.f_82481_ * 1.2);
                    ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(WOMAnimations.BIPED_SPRINT_JUMP, 0.0f);
                }
                if (InputManager.isActionActive((InputAction)MinecraftInputAction.SPRINT)) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.BUFFING.get(), (Object)true);
                } else {
                    if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BUFFING.get())).booleanValue() && ((Player)container.getExecutor().getOriginal()).m_20096_() && container.getExecutor().hasStamina(2.0f)) {
                        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.VERSO.get())).booleanValue()) {
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.VERSO.get(), (Object)false);
                            if (isBarehand) {
                                ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationInClientSide(WOMAnimations.BIPED_SPRINT_LEFT_STEP_BAREHAND, 0.0f);
                            } else {
                                ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationInClientSide(WOMAnimations.BIPED_SPRINT_LEFT_STEP, 0.0f);
                            }
                        } else {
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.VERSO.get(), (Object)true);
                            if (isBarehand) {
                                ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationInClientSide(WOMAnimations.BIPED_SPRINT_RIGHT_STEP_BAREHAND, 0.0f);
                            } else {
                                ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationInClientSide(WOMAnimations.BIPED_SPRINT_RIGHT_STEP, 0.0f);
                            }
                        }
                    }
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.BUFFING.get(), (Object)false);
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    public void stopSprinting(SkillContainer container) {
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false);
            AssetAccessor current_anim = container.getExecutor().getClientAnimator().baseLayer.animationPlayer.getRealAnimation();
            if (!current_anim.equals(WOMAnimations.BIPED_SPRINT_SLIDE)) {
                container.getExecutor().playAnimationInClientSide((AssetAccessor)Animations.BIPED_IDLE, 0.0f);
            }
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient()) {
            if (((Player)container.getExecutor().getOriginal()).m_20142_() && !((Player)container.getExecutor().getOriginal()).m_6069_() && container.getExecutor().getCurrentLivingMotion() != LivingMotions.CREATIVE_FLY) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) < 40) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) + 1));
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 40) {
                        PlayerPatch entitypatch = container.getExecutor();
                        Vec3 deltaMove = ((Player)entitypatch.getOriginal()).m_20184_();
                        Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(((Player)entitypatch.getOriginal()).m_5686_(1.0f), ((Player)entitypatch.getOriginal()).m_5675_(1.0f)));
                        Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(0.8));
                        ((Player)entitypatch.getOriginal()).m_20334_(jumpDir.f_82479_ + deltaMove.f_82479_, deltaMove.f_82480_, jumpDir.f_82481_ + deltaMove.f_82481_);
                        ((Player)entitypatch.getOriginal()).m_9236_().m_6263_((Player)entitypatch.getOriginal(), ((Player)entitypatch.getOriginal()).m_20185_(), ((Player)entitypatch.getOriginal()).m_20186_(), ((Player)entitypatch.getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.SLAM_LIGHT.get(), ((Player)entitypatch.getOriginal()).m_5720_(), 0.1f, 1.6f + (new Random().nextFloat() - 0.5f) * 0.4f);
                        int n = 10;
                        for (int i = 0; i < n; ++i) {
                            Vec3f direction = new Vec3f(new Random().nextFloat(-0.1f, 0.1f), new Random().nextFloat(-0.0f, 1.0f), new Random().nextFloat(-2.0f, 0.0f));
                            Vec3f direction2 = new Vec3f(0.0f, 0.0f, 0.0f);
                            OpenMatrix4f rotation = new OpenMatrix4f().rotate(-Math.toRadians((float)((Player)entitypatch.getOriginal()).f_20884_), new Vec3f(0.0f, 1.0f, 0.0f));
                            rotation.translate(0.0f, 0.0f, 0.0f);
                            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                            rotation.translate(0.0f, 0.0f, -new Random().nextFloat(0.1f, 0.5f));
                            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction2, (Vec3f)direction2);
                            ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, ((Player)entitypatch.getOriginal()).m_20185_() + (double)direction.x, ((Player)entitypatch.getOriginal()).m_20186_() + (double)direction.y + (double)0.1f, ((Player)entitypatch.getOriginal()).m_20189_() + (double)direction.z, (double)direction2.x, (double)direction2.y, (double)direction2.z);
                        }
                        ParticlesTools.particle_circle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.5f), entitypatch, ((Player)entitypatch.getOriginal()).m_9236_(), null, 50, 1.2f, 0.0f, 0.0f, new Vec3f(0.0f, 0.8f, 0.0f), null, new Vec2f(entitypatch.getYRot(), 0.0f), false, false);
                        Player entity = (Player)entitypatch.getOriginal();
                        ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)EpicFightParticles.WHITE_AFTERIMAGE.get(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Double.longBitsToDouble(entity.m_19879_()), 0.0, 0.0);
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)true);
                    }
                }
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)0);
                this.stopSprinting(container);
            }
        } else if (((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get())).floatValue() > 0.0f && !((Player)container.getExecutor().getOriginal()).m_7500_()) {
            container.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get())).floatValue());
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get(), (Object)Float.valueOf(0.0f));
        }
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            if (((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22111_(EVENT_UUID) == null) {
                ((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22125_(this.sprint_movespeed);
            }
        } else if (((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22111_(EVENT_UUID) != null) {
            ((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(this.sprint_movespeed);
        }
    }
}

