/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.animations.weapons.AnimsEnderblaster;
import reascer.wom.gameasset.animations.weapons.AnimsHerrscher;
import reascer.wom.gameasset.animations.weapons.AnimsMoonless;
import reascer.wom.gameasset.animations.weapons.AnimsNapoleon;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class DopamineSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("cee2afd7-aa0e-4792-a0e2-3b48d2fc2a24");

    public DopamineSkill(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
                AnimationManager.AnimationAccessor attack = event.getDamageSource().getAnimation();
                CapabilityItem itemCap = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
                List attacklist = itemCap.getAutoAttackMotion(event.getPlayerPatch());
                AnimationManager.AnimationAccessor dashAttack = (AnimationManager.AnimationAccessor)attacklist.get(attacklist.size() - 2);
                if (attack.equals(AnimsMoonless.MOONLESS_BYPASS) || attack.equals(AnimsMoonless.MOONLESS_REVERSED_BYPASS) || attack.equals(AnimsHerrscher.GESETZ_KRUMMEN) || attack.equals(AnimsNapoleon.NAPOLEON_AUSTERLITZ) || attack.equals(AnimsEnderblaster.ENDERBLASTER_TWOHAND_PISTOLERO) || attack.equals(AnimsEnderblaster.ENDERBLASTER_ONEHAND_SHOOT_DASH)) {
                    dashAttack = attack;
                }
                if (attack.equals(dashAttack)) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)80);
                    ServerLevel serverLevel = (ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_();
                    ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(((ServerPlayerPatch)event.getPlayerPatch()).getStamina() + event.getAttackDamage() * 2.0f);
                    serverLevel.m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_215743_, ((Player)container.getExecutor().getOriginal()).m_5720_(), 10.0f, 0.8f);
                    serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.86f, 0.69f, 0.19f), 1.0f), ((Player)container.getExecutor().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecutor().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecutor().getOriginal()).m_20189_() - 0.2, 30, 0.3, 1.5, 0.3, (double)0.1f);
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int value = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get());
            String string = String.valueOf(value / 20 + "." + value % 20 / 2);
            guiGraphics.drawString(gui.getFont(), string, x + 12.0f - (float)(gui.getFont().m_92895_(string) / 2), y + 13.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.m_237115_((String)"attribute.name.epicfight.cooldown.consume.tooltip"), (Component)Component.m_237110_((String)"attribute.name.epicfight.cooldown.consume", (Object[])new Object[]{ItemStack.f_41584_.format(80L)}), SkillBookScreen.COOLDOWN_TEXTURE_INFO);
        return true;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
        }
    }
}

