/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LethalFocusSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("2a011da0-0b71-4b3e-b00e-862cda9a8a4f");
    private int max_stack = 80;
    private int stack_increase = 4;

    public LethalFocusSkill(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            int fire = 0;
            int blast = 0;
            for (ItemStack ArmorPiece : ((Player)container.getExecutor().getOriginal()).m_6168_()) {
                fire += ArmorPiece.getEnchantmentLevel(Enchantments.f_44966_);
                blast += ArmorPiece.getEnchantmentLevel(Enchantments.f_44968_);
            }
            if (this.max_stack != 80 + 10 * blast || this.stack_increase != 4 + fire) {
                this.max_stack = 80 + 10 * blast;
                this.stack_increase = 4 + fire;
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) + this.stack_increase < this.max_stack) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STACK.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) + this.stack_increase));
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STACK.get(), (Object)this.max_stack);
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)40);
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            float multiplicator = 1.0f + (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get())).intValue() / 100.0f;
            event.attachValueModifier(ValueModifier.multiplier((float)multiplicator));
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)40));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        int value = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get());
        if (value == this.max_stack) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String string = String.valueOf(value) + "%";
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), string, x + 12.0f - (float)(gui.getFont().m_92895_(string) / 2), y + 7.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%s", this.stack_increase));
        list.add(String.format("%s", this.max_stack));
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient()) {
            int fire = 0;
            int blast = 0;
            for (ItemStack ArmorPiece : ((Player)container.getExecutor().getOriginal()).m_6168_()) {
                fire += ArmorPiece.getEnchantmentLevel(Enchantments.f_44966_);
                blast += ArmorPiece.getEnchantmentLevel(Enchantments.f_44968_);
            }
            if (this.max_stack != 80 + 10 * blast || this.stack_increase != 4 + fire) {
                this.max_stack = 80 + 10 * blast;
                this.stack_increase = 4 + fire;
            }
        }
        if (!container.getExecutor().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1));
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STACK.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) - 1));
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)2);
            }
        }
    }
}

