/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.skill.weaponinnate.TrueBerserkSkill;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.level.block.FractureBlockState;

public class TormentPassiveSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("72eabb8f-f889-4302-80bb-690bb557a008");

    public TormentPassiveSkill(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder.setActivateType(Skill.ActivateType.DURATION_INFINITE));
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.TORMENT && container.getExecutor().getEntityState().canBasicAttack() && container.getExecutor().getStamina() > 0.0f) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                ((Player)container.getExecutor().getOriginal()).m_6858_(false);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.TORMENT && container.getExecutor().getEntityState().canBasicAttack() && container.getExecutor().getStamina() > 0.0f) {
                container.getExecutor().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGE, 0.0f);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)true);
                ((Player)container.getExecutor().getOriginal()).m_6858_(false);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue() || ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue()) {
                event.attachValueModifier(ValueModifier.multiplier((float)3.0f));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation().get() instanceof AttackAnimation) {
                ServerPlayerPatch entitypatch = (ServerPlayerPatch)event.getPlayerPatch();
                AttackAnimation anim = (AttackAnimation)event.getDamageSource().getAnimation().get();
                AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((AssetAccessor)event.getDamageSource().getAnimation());
                float elapsedTime = player.getElapsedTime();
                AttackAnimation.Phase phase = anim.getPhaseByTime(elapsedTime);
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue() && phase == anim.phases[0]) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)false);
                    ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, event.getTarget().m_20185_() - 0.15, event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_() - 0.15, 25, 0.0, 0.0, 0.0, 0.2);
                    ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, event.getTarget().m_20185_() - 0.15, event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_() - 0.15, 25, 0.0, 0.0, 0.0, 1.0);
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)false);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)false);
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get())).booleanValue()) {
                event.attachValueModifier(ValueModifier.multiplier((float)0.7f));
                DamageSource patt6643$temp = event.getDamageSource();
                if (patt6643$temp instanceof EpicFightDamageSource) {
                    EpicFightDamageSource efdg = (EpicFightDamageSource)patt6643$temp;
                    efdg.setStunType(StunType.NONE);
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (event.getAnimation().equals(WOMAnimations.TORMENT_AUTO_1) || event.getAnimation().equals(WOMAnimations.TORMENT_AUTO_2) || event.getAnimation().equals(WOMAnimations.TORMENT_AUTO_3) || !event.getAnimation().equals(WOMAnimations.TORMENT_AUTO_4)) {
                // empty if block
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)false);
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) < 20) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get())));
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)0);
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        if (container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof TrueBerserkSkill) {
            return ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get()) != false || (Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get()) != false || (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) > 0) && (Boolean)container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get()) == false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WOMSkills.TRUE_BERSERK.getSkillTexture());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280411_(WOMSkills.TRUE_BERSERK.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        int charge = 0;
        charge = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) > 0 ? ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) + 10) / 30 : ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) + 10) / 30;
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue()) {
            guiGraphics.drawString(gui.getFont(), String.valueOf(charge), x + 10.0f, y + 4.0f, 0xFFFFFF, true);
            guiGraphics.drawString(gui.getFont(), "x3", x + 7.0f, y + 13.0f, 0xFFFFFF, true);
        } else {
            guiGraphics.drawString(gui.getFont(), String.valueOf(charge), x + 10.0f, y + 6.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch entitypatch;
        if (container.getExecutor().isLogicalClient() && (container.getExecutor().getCurrentLivingMotion() == LivingMotions.WALK || container.getExecutor().getCurrentLivingMotion() == LivingMotions.RUN) && !((Player)container.getExecutor().getOriginal()).m_6117_()) {
            entitypatch = container.getExecutor();
            float interpolation = 0.0f;
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), ((HumanoidArmature)Armatures.BIPED.get()).toolR);
            transformMatrix.translate(new Vec3f(0.0f, -0.0f, -1.2f));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, -(new Random().nextFloat() * 1.0f)));
            float dpx = transformMatrix.m30 + (float)((Player)entitypatch.getOriginal()).m_20185_();
            float dpy = transformMatrix.m31 + (float)((Player)entitypatch.getOriginal()).m_20186_();
            float dpz = transformMatrix.m32 + (float)((Player)entitypatch.getOriginal()).m_20189_();
            BlockState blockstate = ((Player)entitypatch.getOriginal()).m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)dpy, (double)dpz));
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos((double)dpx, (double)dpy, (double)dpz);
            while ((blockstate.m_60734_() instanceof BushBlock || blockstate.m_60795_()) && !blockstate.m_60713_(Blocks.f_50626_)) {
                blockstate = ((Player)entitypatch.getOriginal()).m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)(dpy -= 1.0f), (double)dpz));
            }
            while (blockstate instanceof FractureBlockState) {
                float f = dpy;
                dpy = f - 1.0f;
                blockpos = new BlockPos.MutableBlockPos((double)dpx, (double)f, (double)dpz);
                blockstate = ((Player)entitypatch.getOriginal()).m_9236_().m_8055_(blockpos.m_7495_());
            }
            if ((double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() < (double)(dpy + 1.5f)) {
                for (int i = 0; i < 2; ++i) {
                    ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() - (double)0.2f, (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), (double)((new Random().nextFloat() - 0.5f) * 0.005f), (double)(new Random().nextFloat() * 0.02f), (double)((new Random().nextFloat() - 0.5f) * 0.005f));
                }
            }
        }
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue()) {
            entitypatch = container.getExecutor();
            int numberOf = 2;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            for (int i = 0; i < numberOf; ++i) {
                OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), ((HumanoidArmature)Armatures.BIPED.get()).toolR);
                transformMatrix.translate(new Vec3f(0.0f, 0.0f, -1.0f));
                OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
                transformMatrix.translate(new Vec3f(0.0f, 0.0f, -(new Random().nextFloat() * 1.0f)));
                ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.6f, 0.0f), 1.0f), (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 0.55f), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() + (double)((new Random().nextFloat() - 0.5f) * 0.55f), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 0.55f), 0.0, 0.0, 0.0);
                ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 0.75f), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() + (double)((new Random().nextFloat() - 0.5f) * 0.75f), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 0.75f), 0.0, 0.0, 0.0);
                interpolation += partialScale;
            }
        }
        if (!container.getExecutor().isLogicalClient()) {
            AttributeModifier charging_Movementspeed = new AttributeModifier(EVENT_UUID, "torment.charging_movespeed", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
            ServerPlayerPatch executer = (ServerPlayerPatch)container.getExecutor();
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get())).booleanValue() && !((Player)container.getExecutor().getOriginal()).m_6117_() && container.getExecutor().getEntityState().canBasicAttack()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.MOVESPEED.get(), (Object)true);
                int animation_timer = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get());
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) < 20 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) >= 20) {
                    animation_timer = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get());
                }
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) >= 110) {
                    ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 4, 2, true, false, false));
                    ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.WHOOSH_BIG.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
                    if (!((Player)container.getExecutor().getOriginal()).m_7500_()) {
                        executer.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 3.0f);
                    }
                } else if (animation_timer >= 80) {
                    container.getExecutor().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_3, 0.0f);
                } else if (animation_timer >= 50) {
                    container.getExecutor().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_2, 0.0f);
                } else if (animation_timer >= 20) {
                    container.getExecutor().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_1, 0.0f);
                } else if (((Boolean)container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
                    ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 14, 3, true, false, false));
                    ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.WHOOSH_BIG.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
                    float stamina = container.getExecutor().getStamina();
                    float maxStamina = container.getExecutor().getMaxStamina();
                    float staminaRegen = (float)((Player)container.getExecutor().getOriginal()).m_21133_((Attribute)EpicFightAttributes.STAMINA_REGEN.get());
                    int regenStandbyTime = 900 / (int)(30.0f * staminaRegen);
                    if (container.getExecutor().getTickSinceLastAction() > regenStandbyTime) {
                        if (!((Player)container.getExecutor().getOriginal()).m_7500_()) {
                            float staminaFactor = 1.0f + (float)Math.pow(stamina / (maxStamina - stamina * 0.5f), 2.0);
                            executer.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 2.0f + maxStamina * 0.05f * staminaFactor * staminaRegen);
                        }
                    } else if (!((Player)container.getExecutor().getOriginal()).m_7500_()) {
                        executer.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 2.0f);
                    }
                    container.getExecutor().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_2, 0.0f);
                } else {
                    container.getExecutor().playAnimationSynchronized(WOMAnimations.TORMENT_DASH, 0.0f);
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)false);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)0);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get(), (Object)0);
                ((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get())).booleanValue()) {
                ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
                if (((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22111_(EVENT_UUID) == null && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.MOVESPEED.get())).booleanValue()) {
                    ((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22125_(charging_Movementspeed);
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) + 1));
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) <= 130) {
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 20) {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get(), (Object)0);
                        ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.6f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 50) {
                        ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.65f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 80) {
                        ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.7f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 110) {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)true);
                        ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.5f);
                        ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_11699_, SoundSource.MASTER, 2.5f, 0.5f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 130) {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)0);
                        ((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
                    }
                }
            } else if (((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22109_(charging_Movementspeed)) {
                ((Player)container.getExecutor().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
            }
        }
    }

    public void consume_stamina(SkillContainer container) {
        if (!((Player)container.getExecutor().getOriginal()).m_7500_()) {
            if (container.getExecutor().getStamina() <= 0.0f) {
                ((Player)container.getExecutor().getOriginal()).m_5810_();
            }
            if (!container.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, 3.0f, true, null)) {
                ((Player)container.getExecutor().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecutor().getOriginal()).m_20185_(), ((Player)container.getExecutor().getOriginal()).m_20186_(), ((Player)container.getExecutor().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecutor().getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        }
    }
}

