/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.mob;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import reascer.wom.armature.HollowArmature;
import reascer.wom.gameasset.WOMArmatures;
import reascer.wom.gameasset.animations.entitys.AnimsHollow;
import reascer.wom.particle.ParticlesTools;
import reascer.wom.world.entity.mobpatch.HollowPatch;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class Hollow
extends Monster {
    public static final EntityDataAccessor<Integer> STEP_COOLDOWN = SynchedEntityData.m_135353_(Hollow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> IMMUABLE_RESISTANCE = SynchedEntityData.m_135353_(Hollow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Hollow(EntityType<? extends Hollow> p_34166_, Level p_34167_) {
        super(p_34166_, p_34167_);
        this.f_21364_ = 12;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STEP_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(IMMUABLE_RESISTANCE, (Object)0);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("step_cooldown", ((Integer)this.m_20088_().m_135370_(STEP_COOLDOWN)).intValue());
        compoundTag.m_128405_("immuable_resistance", ((Integer)this.m_20088_().m_135370_(IMMUABLE_RESISTANCE)).intValue());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_20088_().m_135381_(STEP_COOLDOWN, (Object)compoundTag.m_128451_("step_cooldown"));
        this.m_20088_().m_135381_(IMMUABLE_RESISTANCE, (Object)compoundTag.m_128451_("immuable_resistance"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 10.0).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 5.0).m_22268_((Attribute)EpicFightAttributes.IMPACT.get(), 2.0);
    }

    public int getResistance() {
        return (Integer)this.m_20088_().m_135370_(IMMUABLE_RESISTANCE);
    }

    protected float m_6431_(Pose p_34186_, EntityDimensions p_34187_) {
        return 2.4f;
    }

    public boolean m_7301_(MobEffectInstance p_70687_1_) {
        return super.m_7301_(p_70687_1_);
    }

    public boolean m_7327_(Entity p_34169_) {
        return super.m_7327_(p_34169_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, livingentity -> livingentity.m_6336_() == MobType.f_21643_ && livingentity.m_5789_()));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (hurt && (source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268566_))) {
            HollowPatch hollowPatch = (HollowPatch)EpicFightCapabilities.getEntityPatch((Entity)this, HollowPatch.class);
            if (hollowPatch != null && hollowPatch.getEntityState().getLevel() == 3 && this.m_21023_(MobEffects.f_19606_)) {
                int amp = this.m_21124_(MobEffects.f_19606_).m_19564_() - 1;
                if (amp > 0) {
                    this.m_21195_(MobEffects.f_19606_);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, amp, true, false, false));
                }
                if (this.getResistance() < 4) {
                    if (amp % 2 == 0) {
                        hollowPatch.playAnimationSynchronized((AssetAccessor)AnimsHollow.HOLLOW_HURT_LEFT, 0.0f);
                    } else {
                        hollowPatch.playAnimationSynchronized((AssetAccessor)AnimsHollow.HOLLOW_HURT_RIGHT, 0.0f);
                    }
                    if (!this.m_9236_().m_5776_()) {
                        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
                        Joint joint = ((HollowArmature)WOMArmatures.HOLLOW.get()).chest;
                        switch ((Integer)this.m_20088_().m_135370_(IMMUABLE_RESISTANCE)) {
                            case 0: {
                                joint = ((HollowArmature)WOMArmatures.HOLLOW.get()).shoudlerPlate_R;
                                break;
                            }
                            case 1: {
                                joint = ((HollowArmature)WOMArmatures.HOLLOW.get()).hand_L;
                                break;
                            }
                            case 2: {
                                joint = ((HollowArmature)WOMArmatures.HOLLOW.get()).hand_R;
                                break;
                            }
                            case 3: {
                                joint = ((HollowArmature)WOMArmatures.HOLLOW.get()).shoudlerPlate_L;
                            }
                        }
                        Vec3f jointPos = ParticlesTools.getJointPos(joint, hollowPatch, amp).toTranslationVector();
                        serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42416_)), (double)jointPos.x, (double)jointPos.y, (double)jointPos.z, 24, 0.1, 0.1, 0.1, (double)0.2f);
                        for (int i = 0; i < new Random().nextInt(1, 4); ++i) {
                            ItemEntity item = new ItemEntity((Level)serverLevel, (double)jointPos.x, (double)jointPos.y, (double)jointPos.z, new ItemStack((ItemLike)Items.f_42749_), (double)new Random().nextFloat(-0.2f, 0.2f), (double)new Random().nextFloat(-0.2f, 0.2f), (double)new Random().nextFloat(-0.2f, 0.2f));
                            item.m_32010_(20);
                            serverLevel.m_7967_((Entity)item);
                        }
                    }
                }
                this.m_20088_().m_135381_(IMMUABLE_RESISTANCE, (Object)(this.getResistance() + 1));
            }
            this.m_5496_(SoundEvents.f_11668_, 0.5f, 1.4f);
        }
        return hurt;
    }

    protected void m_7355_(BlockPos p_30584_, BlockState block) {
        if (!(block.m_60734_() instanceof LiquidBlock)) {
            BlockState blockstate = this.m_9236_().m_8055_(p_30584_.m_7494_());
            SoundType soundtype = block.getSoundType((LevelReader)this.m_9236_(), p_30584_, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.m_9236_(), p_30584_, (Entity)this);
            }
        }
    }

    public static boolean m_219013_(EntityType<? extends Monster> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Math.sqrt(pos.m_203198_(0.0, 64.0, 0.0)) > 1000.0 && Monster.m_217057_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_213945_(RandomSource p_219154_, DifficultyInstance p_219155_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WOMItems.HOLLOW_LONGSWORD.get()));
        if (new Random().nextBoolean()) {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20184_().m_165924_() > 0.0) {
            this.m_20088_().m_135381_(STEP_COOLDOWN, (Object)((Integer)this.m_20088_().m_135370_(STEP_COOLDOWN) + (int)(this.m_20184_().m_165924_() * 1000.0)));
        } else {
            this.m_20088_().m_135381_(STEP_COOLDOWN, (Object)0);
        }
        if ((Integer)this.m_20088_().m_135370_(STEP_COOLDOWN) > 550) {
            this.m_20088_().m_135381_(STEP_COOLDOWN, (Object)0);
            SoundType soundtype = this.m_20075_().getSoundType((LevelReader)this.m_9236_(), this.m_20097_(), (Entity)this);
            this.m_5496_(SoundEvents.f_12010_, soundtype.m_56773_() * 0.75f, 1.2f);
            this.m_5496_(SoundEvents.f_11668_, soundtype.m_56773_() * 0.15f, 1.2f);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_32146_, DifficultyInstance p_32147_, MobSpawnType p_32148_, @Nullable SpawnGroupData p_32149_, @Nullable CompoundTag p_32150_) {
        p_32149_ = super.m_6518_(p_32146_, p_32147_, p_32148_, p_32149_, p_32150_);
        RandomSource randomsource = p_32146_.m_213780_();
        this.m_213945_(randomsource, p_32147_);
        this.m_213946_(randomsource, p_32147_);
        if (!this.m_21206_().m_41619_() && randomsource.m_188501_() < 0.25f * p_32147_.m_19057_()) {
            this.m_8061_(EquipmentSlot.OFFHAND, EnchantmentHelper.m_220292_((RandomSource)randomsource, (ItemStack)this.m_21205_(), (int)((int)(5.0f + p_32147_.m_19057_() * (float)randomsource.m_188503_(18))), (boolean)false));
        }
        this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 4, true, false, false));
        return p_32149_;
    }
}

