/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.mob;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ServerChatEvent;
import org.joml.Vector3f;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.animations.entitys.AnimsLupus;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.ai.goals.FollowParentOrNearbyPlayerGoal;
import reascer.wom.world.entity.ai.goals.LupusRexOwnerHurtByTargetGoal;
import reascer.wom.world.entity.ai.goals.LupusRexOwnerHurtTargetGoal;
import reascer.wom.world.entity.ai.goals.RangeBreedGoal;
import reascer.wom.world.entity.ai.goals.RiddableFollowOwnerGoal;
import reascer.wom.world.entity.ai.goals.WOMWaterAvoidingRandomStrollGoal;
import reascer.wom.world.entity.ai.goals.WomFloatGoal;
import reascer.wom.world.entity.ai.goals.WomHurtByTargetGoal;
import reascer.wom.world.entity.mobpatch.LupusRexPatch;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class LupusRex
extends AbstractHorse
implements NeutralMob {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final Ingredient LUPUS_FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42580_, Items.f_42579_, Items.f_42582_, Items.f_42581_, Items.f_42659_, Items.f_42658_, Items.f_42486_, Items.f_42485_, Items.f_42583_, Items.f_42526_, Items.f_42530_, Items.f_42527_, Items.f_42531_, Items.f_42437_});
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> RUNNING_AROUND_TARGET = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> PLAYFUL = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TARGETING = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> STRATEGY = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Vector3f> SIT_LOCATION = SynchedEntityData.m_135353_(LupusRex.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    public boolean playingMode;
    public boolean learnJump;
    public boolean learnRunAround;
    public boolean learnDodge;

    public LupusRex(EntityType<? extends LupusRex> entity, Level level) {
        super(entity, level);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.learnJump = false;
        this.learnRunAround = false;
        this.learnDodge = false;
        this.f_21364_ = 30;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(RUNNING_AROUND_TARGET, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(TARGETING, (Object)0);
        this.f_19804_.m_135372_(STRATEGY, (Object)0);
        this.f_19804_.m_135372_(SIT_LOCATION, (Object)new Vector3f());
        this.f_19804_.m_135372_(PLAYFUL, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(AGE, (Object)0);
    }

    protected float m_245547_(Player p_278336_) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (!this.f_30520_.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
        compoundTag.m_128405_("Command", ((Integer)this.m_20088_().m_135370_(COMMAND)).intValue());
        compoundTag.m_128405_("Targeting", ((Integer)this.m_20088_().m_135370_(TARGETING)).intValue());
        compoundTag.m_128405_("Strategy", ((Integer)this.m_20088_().m_135370_(STRATEGY)).intValue());
        compoundTag.m_128379_("Playful", ((Boolean)this.m_20088_().m_135370_(PLAYFUL)).booleanValue());
        compoundTag.m_128379_("Sleeping", ((Boolean)this.m_20088_().m_135370_(SLEEPING)).booleanValue());
        compoundTag.m_128405_("SyncAge", ((Integer)this.m_20088_().m_135370_(AGE)).intValue());
        compoundTag.m_128379_("LearnJump", this.learnJump);
        compoundTag.m_128379_("LearnRunAround", this.learnRunAround);
        compoundTag.m_128379_("LearnDodge", this.learnDodge);
    }

    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemstack;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.m_6010_(itemstack)) {
            this.f_30520_.m_6836_(1, itemstack);
        }
        this.m_7493_();
        this.m_20088_().m_276349_(COMMAND, (Object)compoundTag.m_128451_("Command"), true);
        this.m_20088_().m_276349_(TARGETING, (Object)compoundTag.m_128451_("Targeting"), true);
        this.m_20088_().m_276349_(STRATEGY, (Object)compoundTag.m_128451_("Strategy"), true);
        this.m_20088_().m_276349_(PLAYFUL, (Object)compoundTag.m_128471_("Playful"), true);
        this.m_20088_().m_276349_(SLEEPING, (Object)compoundTag.m_128471_("Sleeping"), true);
        this.m_20088_().m_276349_(SIT_LOCATION, (Object)this.m_20182_().m_252839_(), true);
        this.m_20088_().m_276349_(AGE, (Object)compoundTag.m_128451_("SyncAge"), true);
        this.m_7350_(COMMAND);
        this.m_7350_(PLAYFUL);
        this.m_7350_(SLEEPING);
        this.m_7350_(SIT_LOCATION);
        this.m_7350_(AGE);
        this.learnJump = compoundTag.m_128471_("LearnJump");
        this.learnRunAround = compoundTag.m_128471_("LearnRunAround");
        this.learnDodge = compoundTag.m_128471_("LearnDodge");
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new WomFloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RangeBreedGoal((Animal)this, 1.0, 64.0, LupusRex.class));
        this.f_21345_.m_25352_(4, (Goal)new RiddableFollowOwnerGoal(this, 1.4, 25.0f, 5.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentOrNearbyPlayerGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WOMWaterAvoidingRandomStrollGoal(this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(0, (Goal)new LupusRexOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new LupusRexOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new WomHurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, arg_0 -> ((LupusRex)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public int getSyncAge() {
        return (Integer)this.m_20088_().m_135370_(AGE);
    }

    public boolean m_5803_() {
        return (Boolean)this.m_20088_().m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.m_20088_().m_276349_(SLEEPING, (Object)sleeping, true);
    }

    public boolean isPlayful() {
        return (Boolean)this.m_20088_().m_135370_(PLAYFUL);
    }

    public boolean isOrderedToFollow() {
        return (Integer)this.m_20088_().m_135370_(COMMAND) == 3;
    }

    public boolean isOrderedToCome() {
        return (Integer)this.m_20088_().m_135370_(COMMAND) == 2;
    }

    public int getCommand() {
        return (Integer)this.m_20088_().m_135370_(COMMAND);
    }

    public int getTargeting() {
        return (Integer)this.m_20088_().m_135370_(TARGETING);
    }

    public void setTargeting(int targeting, boolean sync) {
        this.m_20088_().m_276349_(TARGETING, (Object)targeting, sync);
    }

    public int getStrategy() {
        return (Integer)this.m_20088_().m_135370_(STRATEGY);
    }

    public void setStrategy(int strategy, boolean sync) {
        this.m_20088_().m_276349_(STRATEGY, (Object)strategy, sync);
    }

    public boolean isOrderedToStay() {
        LupusRexPatch lupusRexPatch = (LupusRexPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LupusRexPatch.class);
        return (Integer)this.m_20088_().m_135370_(COMMAND) == 1 || (Integer)this.m_20088_().m_135370_(COMMAND) == 4 || (Integer)this.m_20088_().m_135370_(COMMAND) == -1 || !lupusRexPatch.getEntityState().canBasicAttack() || this.m_5803_();
    }

    public void HandleAttackableTarget(Player player) {
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        AABB boxI = AABB.m_165882_((Vec3)this.m_269323_().m_20182_(), (double)60.0, (double)60.0, (double)60.0);
        List listI = this.m_269323_().m_9236_().m_45933_((Entity)player, boxI);
        LivingEntity stored_Target = null;
        for (Entity entity : listI) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity current_target = (LivingEntity)entity;
            Vec3 anchor = player.m_20318_(0.0f);
            boolean validTarget = false;
            boolean untargeted = true;
            if (this.getCommand() == 1) {
                anchor = this.getOriginalSitPosition();
            }
            if (!(Mth.m_14116_((float)((float)current_target.m_20238_(anchor))) < 30.0f)) continue;
            switch (Math.abs(this.getTargeting())) {
                case 0: {
                    validTarget = current_target.m_6095_().m_20674_() == MobCategory.MONSTER;
                    break;
                }
                case 1: {
                    validTarget = current_target.m_6095_().m_20674_() == MobCategory.MONSTER;
                    break;
                }
                case 2: {
                    if (!(current_target instanceof Mob)) break;
                    Mob mob = (Mob)current_target;
                    validTarget = mob.m_5448_().m_20148_().equals(this.m_20148_()) || mob.m_5448_().m_20148_().equals(this.m_21805_());
                    break;
                }
                case 3: {
                    validTarget = true;
                    break;
                }
                default: {
                    validTarget = false;
                }
            }
            if (validTarget) {
                if (this.getTargeting() <= 0) {
                    validTarget = false;
                }
                for (String tag : current_target.m_19880_()) {
                    if (!tag.contains("wom_lupus_target")) continue;
                    if (tag.split(":")[1].equals("any")) {
                        current_target.m_19880_().remove(tag);
                        validTarget = true;
                        break;
                    }
                    if (tag.split(":")[1].equals(this.m_20149_())) {
                        current_target.m_19880_().remove(tag);
                    }
                    untargeted = false;
                    break;
                }
            }
            if (!validTarget) continue;
            if (stored_Target == null && this.getStrategy() != 0) {
                if (untargeted) {
                    current_target.m_20049_("wom_lupus_target:" + this.m_20149_());
                }
                stored_Target = current_target;
                continue;
            }
            switch (this.getStrategy()) {
                case 0: {
                    if (playerPatch == null || playerPatch.getTarget() == null || current_target.m_20148_() != playerPatch.getTarget().m_20148_()) break;
                    stored_Target = current_target;
                    break;
                }
                case 1: {
                    if (playerPatch == null || playerPatch.getTarget() == null || current_target.m_20148_() == playerPatch.getTarget().m_20148_() || !untargeted) break;
                    stored_Target = current_target;
                    break;
                }
                case 2: {
                    if (!new Random().nextBoolean() || !untargeted) break;
                    stored_Target = current_target;
                    break;
                }
                case 3: {
                    if (!(Mth.m_14116_((float)((float)current_target.m_20238_(anchor))) < Mth.m_14116_((float)((float)stored_Target.m_20238_(anchor))))) break;
                    stored_Target = current_target;
                }
            }
        }
        if (stored_Target != null) {
            this.m_6710_(stored_Target);
            this.m_6703_(stored_Target);
            this.m_6925_(stored_Target.m_20148_());
        } else {
            this.m_6703_(null);
            this.m_21335_((Entity)((LivingEntity)null));
            this.m_6925_(null);
            this.m_7870_(0);
            this.m_6710_(null);
        }
    }

    public static void HandleChatCommands(ServerChatEvent event) {
        String[] allcommands = new String[]{"vagare", "mane", "veni", "sequi", "impetus", "custos", "scopus", "consilium"};
        ArrayList<String> splitedMessage = new ArrayList<String>();
        for (String string : event.getRawText().split(" ")) {
            splitedMessage.add(string);
        }
        while (splitedMessage.size() > 0 && !((String)splitedMessage.get(0)).equals("lupus")) {
            splitedMessage.remove(0);
        }
        if (splitedMessage.size() >= 2 && ((String)splitedMessage.get(0)).toLowerCase().equals("lupus")) {
            ServerPlayer player = event.getPlayer();
            AABB box = AABB.m_165882_((Vec3)event.getPlayer().m_20182_(), (double)400.0, (double)400.0, (double)400.0);
            List list = event.getPlayer().m_9236_().m_45976_(LupusRex.class, box);
            for (LupusRex lupus : list) {
                LupusRexPatch lupusRexPatch;
                int command_index;
                if (!(lupus.m_20270_((Entity)player) < 200.0f)) continue;
                boolean targetedCommand = true;
                boolean validTargetedCommand = false;
                for (String command : allcommands) {
                    if (((String)splitedMessage.get(1)).equals(command)) {
                        targetedCommand = false;
                    }
                    if (!lupus.m_8077_() || !command.equals(lupus.m_7770_().getString()) || splitedMessage.size() < 3) continue;
                    targetedCommand = true;
                }
                int n = command_index = targetedCommand ? 2 : 1;
                if (lupus.m_30614_() && lupus.m_21805_().equals(player.m_20148_())) {
                    if (targetedCommand && lupus.m_8077_()) {
                        if (((String)splitedMessage.get(1)).equals(lupus.m_7770_().getString())) {
                            validTargetedCommand = true;
                        }
                    } else {
                        validTargetedCommand = true;
                    }
                }
                if (!validTargetedCommand) continue;
                boolean combination = true;
                switch (((String)splitedMessage.get(command_index)).toLowerCase()) {
                    case "vagare": {
                        lupus.m_20088_().m_276349_(COMMAND, (Object)0, true);
                        break;
                    }
                    case "mane": {
                        lupus.m_20088_().m_276349_(COMMAND, (Object)1, true);
                        lupus.m_20088_().m_135381_(SIT_LOCATION, (Object)lupus.m_20318_(0.0f).m_252839_());
                        lupus.m_6703_(null);
                        lupus.m_21335_((Entity)((LivingEntity)null));
                        lupus.m_6925_(null);
                        lupus.m_7870_(0);
                        lupus.m_6710_(null);
                        break;
                    }
                    case "veni": {
                        AABB boxV = AABB.m_165882_((Vec3)event.getPlayer().m_20182_(), (double)200.0, (double)200.0, (double)200.0);
                        List listV = event.getPlayer().m_9236_().m_45933_((Entity)player, boxV);
                        block16: for (Entity entity : listV) {
                            LivingEntity livingentity;
                            if (!(entity instanceof LivingEntity) || !((livingentity = (LivingEntity)entity).m_20270_((Entity)player) < 100.0f)) continue;
                            for (String tag : livingentity.m_19880_()) {
                                if (!tag.contains("wom_lupus_target")) continue;
                                livingentity.m_19880_().remove(tag);
                                continue block16;
                            }
                        }
                        lupus.setTargeting(-Math.abs(lupus.getTargeting()), true);
                        lupus.m_20088_().m_276349_(COMMAND, (Object)2, true);
                        lupus.m_6703_(null);
                        lupus.m_21335_((Entity)((LivingEntity)null));
                        lupus.m_6925_(null);
                        lupus.m_7870_(0);
                        lupus.m_6710_(null);
                        break;
                    }
                    case "sequi": {
                        lupus.m_20088_().m_276349_(COMMAND, (Object)3, true);
                        break;
                    }
                    default: {
                        LupusRex.handleCombination((Player)player, lupus, splitedMessage, command_index, true);
                        combination = false;
                    }
                }
                if (combination && splitedMessage.size() > command_index + 1) {
                    LupusRex.handleCombination((Player)player, lupus, splitedMessage, command_index + 1, false);
                }
                if ((Integer)lupus.m_20088_().m_135370_(COMMAND) != 4 && (lupusRexPatch = (LupusRexPatch)EpicFightCapabilities.getEntityPatch((Entity)lupus, LupusRexPatch.class)) != null) {
                    lupusRexPatch.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_BARK, 0.1f);
                }
                if (!targetedCommand) continue;
                break;
            }
        }
    }

    public static void handleCombination(Player player, LupusRex lupus, ArrayList<String> splitedMessage, int command_index, boolean handle_default) {
        if (!lupus.m_6162_()) {
            switch (splitedMessage.get(command_index).toLowerCase()) {
                case "impetus": {
                    LupusRex.handleImpetus(player, lupus, splitedMessage, command_index);
                    break;
                }
                case "custos": {
                    LupusRex.handleCustos(lupus, splitedMessage, command_index);
                    break;
                }
                case "scopus": {
                    LupusRex.handleScopus(lupus, splitedMessage, command_index + 1, true);
                    break;
                }
                case "consilium": {
                    LupusRex.handleConsilium(lupus, splitedMessage, command_index + 1, true);
                    break;
                }
                default: {
                    if (!handle_default) break;
                    lupus.m_20088_().m_276349_(COMMAND, (Object)4, true);
                    lupus.m_20088_().m_135381_(SIT_LOCATION, (Object)new Vector3f());
                }
            }
        }
    }

    public static void handleImpetus(Player player, LupusRex lupus, ArrayList<String> splitedMessage, int command_index) {
        AABB boxI = AABB.m_165882_((Vec3)player.m_20182_(), (double)60.0, (double)60.0, (double)60.0);
        List listI = player.m_9236_().m_45933_((Entity)player, boxI);
        for (Entity entity : listI) {
            OwnableEntity ownableEntity;
            LivingEntity livingentity;
            if (!(entity instanceof LivingEntity) || !((livingentity = (LivingEntity)entity).m_20270_((Entity)player) < 30.0f)) continue;
            boolean isTarget = false;
            for (String tag : livingentity.m_19880_()) {
                if (!tag.contains("wom_lupus_target")) continue;
                isTarget = true;
                break;
            }
            if (entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).m_21805_() != player.m_20148_()) {
                isTarget = true;
            }
            if (isTarget) continue;
            livingentity.m_20049_("wom_lupus_target:any");
        }
        if (splitedMessage.size() > command_index + 1) {
            LupusRex.handleScopus(lupus, splitedMessage, command_index + 1, false);
            LupusRex.handleConsilium(lupus, splitedMessage, command_index + 1, false);
        }
        if (splitedMessage.size() > command_index + 2) {
            LupusRex.handleScopus(lupus, splitedMessage, command_index + 2, false);
            LupusRex.handleConsilium(lupus, splitedMessage, command_index + 2, false);
        }
        lupus.setTargeting(-Math.abs(lupus.getTargeting()), true);
    }

    public static void handleCustos(LupusRex lupus, ArrayList<String> splitedMessage, int command_index) {
        if (splitedMessage.size() > command_index + 1) {
            LupusRex.handleScopus(lupus, splitedMessage, command_index + 1, false);
            LupusRex.handleConsilium(lupus, splitedMessage, command_index + 1, false);
        }
        if (splitedMessage.size() > command_index + 2) {
            LupusRex.handleScopus(lupus, splitedMessage, command_index + 2, false);
            LupusRex.handleConsilium(lupus, splitedMessage, command_index + 2, false);
        }
        lupus.setTargeting(Math.abs(lupus.getTargeting()), true);
    }

    public static void handleScopus(LupusRex lupus, ArrayList<String> splitedMessage, int command_index, boolean handle_default) {
        boolean Attacking = lupus.getTargeting() <= 0;
        switch (splitedMessage.get(command_index).toLowerCase()) {
            case "hostilis": {
                lupus.setTargeting(Attacking ? -1 : 1, true);
                break;
            }
            case "minax": {
                lupus.setTargeting(Attacking ? -2 : 2, true);
                break;
            }
            case "omnis": {
                lupus.setTargeting(Attacking ? -3 : 3, true);
                break;
            }
            default: {
                if (!handle_default) break;
                lupus.m_20088_().m_276349_(COMMAND, (Object)4, true);
                lupus.m_20088_().m_135381_(SIT_LOCATION, (Object)new Vector3f());
            }
        }
    }

    public static void handleConsilium(LupusRex lupus, ArrayList<String> splitedMessage, int command_index, boolean handle_default) {
        switch (splitedMessage.get(command_index).toLowerCase()) {
            case "idem": {
                lupus.setStrategy(0, true);
                break;
            }
            case "alius": {
                lupus.setStrategy(1, true);
                break;
            }
            case "vario": {
                lupus.setStrategy(2, true);
                break;
            }
            case "proxi": {
                lupus.setStrategy(3, true);
                break;
            }
            default: {
                if (!handle_default) break;
                lupus.m_20088_().m_276349_(COMMAND, (Object)4, true);
                lupus.m_20088_().m_135381_(SIT_LOCATION, (Object)new Vector3f());
            }
        }
    }

    public boolean isTurningLock() {
        LupusRexPatch lupusRexPatch = (LupusRexPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LupusRexPatch.class);
        if (lupusRexPatch != null) {
            return lupusRexPatch.getEntityState().turningLocked();
        }
        return false;
    }

    public boolean isMovementLock() {
        LupusRexPatch lupusRexPatch = (LupusRexPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LupusRexPatch.class);
        if (lupusRexPatch != null) {
            return lupusRexPatch.getEntityState().movementLocked();
        }
        return false;
    }

    public boolean isWet() {
        LupusRexPatch lupusRexPatch = (LupusRexPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LupusRexPatch.class);
        if (lupusRexPatch != null) {
            return lupusRexPatch.ShakeWaterOffCountDown > 0;
        }
        return false;
    }

    public Vec3 getOriginalSitPosition() {
        if (((Vector3f)this.m_20088_().m_135370_(LupusRex.SIT_LOCATION)).x == 0.0f && ((Vector3f)this.m_20088_().m_135370_(LupusRex.SIT_LOCATION)).y == 0.0f && ((Vector3f)this.m_20088_().m_135370_(LupusRex.SIT_LOCATION)).z == 0.0f) {
            return null;
        }
        return new Vec3((Vector3f)this.m_20088_().m_135370_(SIT_LOCATION));
    }

    protected boolean m_245259_() {
        return false;
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper) && !(p_30389_ instanceof Ghast)) {
            if (p_30389_ instanceof Wolf) {
                Wolf wolf = (Wolf)p_30389_;
                return !wolf.m_21824_() || wolf.m_269323_() != p_30390_;
            }
            if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)p_30389_)) {
                return false;
            }
            if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).m_30614_()) {
                return false;
            }
            return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).m_21824_();
        }
        return false;
    }

    public boolean m_6779_(LivingEntity entity) {
        LupusRex lupus;
        if (entity instanceof LupusRex && (lupus = (LupusRex)entity).m_30614_() && this.m_30614_()) {
            return false;
        }
        return super.m_6779_(entity);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, (double)0.45f).m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22285_, 15.0).m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22277_, 2048.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 4.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 8.0).m_22268_((Attribute)EpicFightAttributes.IMPACT.get(), 6.0);
    }

    protected void m_214179_(RandomSource p_218815_) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)LupusRex.m_271722_(arg_0 -> ((RandomSource)p_218815_).m_188503_(arg_0)));
        this.m_21051_(Attributes.f_22279_).m_22100_(LupusRex.m_271981_(() -> ((RandomSource)p_218815_).m_188500_()));
        this.m_21051_(Attributes.f_22288_).m_22100_(LupusRex.m_272017_(() -> ((RandomSource)p_218815_).m_188500_()));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)LupusRex.generateAttackDamage(() -> ((RandomSource)p_218815_).m_188500_()));
    }

    protected static float generateAttackDamage(DoubleSupplier p_272695_) {
        return 7.0f + (float)p_272695_.getAsDouble() * 2.3f + (float)p_272695_.getAsDouble() * 2.3f + (float)p_272695_.getAsDouble() * 2.3f;
    }

    protected static float m_271722_(IntUnaryOperator p_272695_) {
        return 70.0f + (float)p_272695_.applyAsInt(15) + (float)p_272695_.applyAsInt(15);
    }

    protected static double m_272017_(DoubleSupplier p_272718_) {
        return (double)0.6f + p_272718_.getAsDouble() * 0.2 + p_272718_.getAsDouble() * 0.2 + p_272718_.getAsDouble() * 0.2;
    }

    protected static double m_271981_(DoubleSupplier p_273691_) {
        return ((double)0.95f + p_273691_.getAsDouble() * 0.3 + p_273691_.getAsDouble() * 0.3 + p_273691_.getAsDouble() * 0.3) * 0.25;
    }

    public LivingEntity m_5448_() {
        if (this.isOrderedToCome()) {
            this.m_21661_();
            this.m_6710_(null);
        }
        return super.m_5448_();
    }

    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.m_5448_() == null || this.m_5448_().m_21224_()) {
                this.HandleAttackableTarget(player);
            }
        }
        if (this.m_6162_() && !this.m_9236_().m_5776_() && this.f_146733_ % 20 == 0) {
            this.m_20088_().m_276349_(AGE, (Object)this.f_146733_, true);
        }
        if (this.isTurningLock()) {
            this.f_20883_ = this.f_20884_;
        }
        if (!this.m_9236_().m_5776_()) {
            float f = new Random().nextFloat(0.0f, 100.0f);
            float f2 = this.m_6162_() ? 50.0f : 100.0f;
            if (f < f2) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175829_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, (double)this.m_20205_() * 0.55, (double)this.m_20206_() * 0.75, (double)this.m_20205_() * 0.55, 0.0);
            }
        }
        if (this.m_269323_() != null && (livingEntity = this.m_5448_()) instanceof LupusRex) {
            LupusRex lupus = (LupusRex)livingEntity;
            if (this.m_269323_().equals((Object)lupus.m_269323_())) {
                this.m_21661_();
            }
        }
        if (this.isOrderedToCome() && this.m_269323_() != null && this.m_20280_((Entity)this.m_269323_()) < 9.0) {
            this.m_20088_().m_135381_(COMMAND, (Object)0);
        }
    }

    public boolean m_7559_() {
        return false;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack p_30733_) {
        this.m_8061_(EquipmentSlot.CHEST, p_30733_);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    protected void m_7493_() {
        if (!this.m_9236_().m_5776_()) {
            super.m_7493_();
            this.setArmorEquipment(this.f_30520_.m_8020_(1));
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        }
    }

    private void setArmorEquipment(ItemStack p_30735_) {
        this.setArmor(p_30735_);
        if (!this.m_9236_().m_5776_()) {
            int i;
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            if (this.m_6010_(p_30735_) && (i = ((HorseArmorItem)p_30735_.m_41720_()).m_41368_()) != 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void m_5757_(Container p_30696_) {
        ItemStack itemstack = this.getArmor();
        super.m_5757_(p_30696_);
        ItemStack itemstack1 = this.getArmor();
        if (this.f_19797_ > 20 && this.m_6010_(itemstack1) && itemstack != itemstack1) {
            this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
        }
    }

    protected void m_5877_(SoundType sound) {
        ItemStack stack;
        this.m_5496_(SoundEvents.f_11977_, sound.m_56773_() * 0.15f, 1.6f);
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_5496_(SoundEvents.f_12617_, sound.m_56773_() * 0.6f, sound.m_56774_());
        }
        if (this.m_6010_(stack = this.f_30520_.m_8020_(1))) {
            stack.onHorseArmorTick(this.m_9236_(), (Mob)this);
        }
    }

    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return null;
        }
        if (this.m_5448_() != null) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_30614_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return SoundEvents.f_11912_;
    }

    protected SoundEvent m_7975_(DamageSource p_30720_) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_7871_() {
        return SoundEvents.f_12619_;
    }

    protected void m_7486_() {
        this.m_5496_(SoundEvents.f_12624_, 0.4f, 0.5f);
    }

    public float m_6100_() {
        return this.m_6162_() ? (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.7f : (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.8f;
    }

    protected void m_7355_(BlockPos p_30584_, BlockState block) {
        if (!(block.m_60734_() instanceof LiquidBlock)) {
            BlockState blockstate = this.m_9236_().m_8055_(p_30584_.m_7494_());
            SoundType soundtype = block.getSoundType((LevelReader)this.m_9236_(), p_30584_, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.m_9236_(), p_30584_, (Entity)this);
            }
            if (this.m_20160_() && this.f_30523_) {
                ++this.f_30524_;
                if (this.f_30524_ > 5 && this.f_30524_ % 3 == 0) {
                    this.m_5877_(soundtype);
                } else if (this.f_30524_ <= 5) {
                    this.m_5496_(SoundEvents.f_12624_, soundtype.m_56773_() * 0.15f, 0.5f);
                }
            } else {
                this.m_5496_(SoundEvents.f_12624_, soundtype.m_56773_() * 0.15f, 0.5f);
            }
        }
    }

    public boolean m_142535_(float height, float damping, DamageSource damageSource) {
        int i;
        if (height > 1.0f) {
            this.m_5496_(SoundEvents.f_12624_, 0.4f, 0.5f);
        }
        if ((i = this.m_5639_(height, damping)) <= 0) {
            return false;
        }
        this.m_6469_(damageSource, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(damageSource, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected int m_5639_(float height, float damping) {
        return Mth.m_14167_((float)((height * 0.1f - 3.0f) * damping));
    }

    protected boolean m_5994_(Player player, ItemStack itemstack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        if (itemstack.m_150930_(Items.f_42437_)) {
            f = 20.0f;
            i = 240;
            j = 10;
            this.m_21661_();
            if ((this.m_21223_() < this.m_21233_() * 0.3f || this.isPlayful() && this.learnJump && this.learnRunAround && this.learnDodge) && !this.m_30614_()) {
                this.m_20088_().m_135381_(COMMAND, (Object)-1);
                this.m_30637_(player);
            } else if (!this.m_9236_().m_5776_() && this.m_146764_() == 0 && !this.m_27593_()) {
                flag = true;
                this.m_27595_(player);
            }
        } else {
            f = 4.0f;
            i = 60;
            j = 3;
            if (this.m_5448_() == player) {
                this.m_6710_(null);
            }
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
        }
        flag = true;
        if (this.m_6162_() && i > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().m_5776_()) {
                this.m_146758_(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.m_30614_()) && this.m_30624_() < this.m_7555_()) {
            flag = true;
            if (!this.m_9236_().m_5776_()) {
                this.m_30653_(j);
            }
        }
        if (flag) {
            this.m_30610_();
            this.m_146850_(GameEvent.f_157806_);
        }
        return flag;
    }

    public boolean m_6898_(ItemStack itemstack) {
        return LUPUS_FOOD_ITEMS.test(itemstack);
    }

    private void m_30610_() {
        SoundEvent soundevent;
        this.m_30612_();
        if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, 0.6f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
    }

    private void m_30612_() {
        if (!this.m_9236_().m_5776_()) {
            this.m_30597_(64, true);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean flag = this.m_30614_() && player.m_36341_();
        LupusRexPatch lupusRexPatch = (LupusRexPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LupusRexPatch.class);
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (this.m_5803_()) {
            return InteractionResult.FAIL;
        }
        if ((Integer)this.m_20088_().m_135370_(COMMAND) == -2 && itemstack.m_41619_() && this.m_6162_()) {
            this.m_20088_().m_135381_(COMMAND, (Object)0);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (!this.m_20160_() && this.m_30614_() && (itemstack.m_41720_() instanceof SwordItem || itemstack.m_41720_() instanceof DiggerItem || itemstack.m_41720_() == Items.f_42398_)) {
            if (this.isOrderedToStay()) {
                this.m_20088_().m_276349_(COMMAND, (Object)2, true);
            } else if (this.isOrderedToFollow()) {
                this.m_20088_().m_276349_(COMMAND, (Object)1, true);
                this.m_20088_().m_276349_(SIT_LOCATION, (Object)this.m_20318_(0.0f).m_252839_(), true);
            } else {
                this.m_20088_().m_276349_(COMMAND, (Object)3, true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (!this.m_20160_() && !flag) {
            if (!itemstack.m_41619_()) {
                if (this.m_6898_(itemstack)) {
                    if ((this.m_21223_() < this.m_21233_() * 0.3f || this.isPlayful() && this.learnJump && this.learnRunAround && this.learnDodge) && !this.m_30614_()) {
                        this.m_21573_().m_26573_();
                        this.m_21563_().m_148051_((Entity)player);
                        lupusRexPatch.rotateTo((Entity)player, 360.0f, true);
                        if (lupusRexPatch != null && !lupusRexPatch.isLogicalClient() && itemstack.m_150930_(Items.f_42437_)) {
                            lupusRexPatch.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_OATH, 0.0f);
                        }
                    } else {
                        this.m_21573_().m_26573_();
                        this.m_21563_().m_148051_((Entity)player);
                        lupusRexPatch.rotateTo((Entity)player, 360.0f, true);
                        if (lupusRexPatch != null && !lupusRexPatch.isLogicalClient() && !lupusRexPatch.getServerAnimator().animationPlayer.getAnimation().equals(AnimsLupus.LUPUS_REX_EAT)) {
                            float convertion = 0.0f;
                            if (lupusRexPatch.getCurrentLivingMotion() != LivingMotions.IDLE) {
                                convertion = 0.3f;
                            }
                            lupusRexPatch.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_EAT, convertion);
                        }
                    }
                    return this.m_30580_(player, itemstack);
                }
                if (!this.m_30614_()) {
                    return InteractionResult.FAIL;
                }
            }
            if (this.m_30614_() && this.m_21805_() != null && this.m_21805_().equals(player.m_20148_())) {
                if (this.isOrderedToStay()) {
                    this.m_20088_().m_276349_(COMMAND, (Object)3, true);
                }
                this.m_6703_(null);
                this.m_21335_((Entity)((LivingEntity)null));
                this.m_6925_(null);
                this.m_7870_(0);
                this.m_6710_(null);
                if (player.m_6047_()) {
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
                if (player.m_6047_() || serverPlayerPatch != null && !lupusRexPatch.isLogicalClient() && serverPlayerPatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimations.BIPED_PET_LUPUS)) {
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                return super.m_6071_(player, hand);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.m_30614_()) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
            if (player.m_6047_() && this.m_20270_((Entity)player) < 4.0f && itemstack.m_41619_()) {
                if (lupusRexPatch != null && !lupusRexPatch.isLogicalClient() && serverPlayerPatch != null) {
                    this.m_21573_().m_26573_();
                    this.m_21563_().m_148051_((Entity)player);
                    lupusRexPatch.rotateTo((Entity)player, 360.0f, true);
                    if (!this.m_6162_()) {
                        lupusRexPatch.playAnimationSynchronized((AssetAccessor)AnimsLupus.LUPUS_REX_PET, 0.0f);
                        serverPlayerPatch.rotateTo((Entity)this, 360.0f, true);
                        serverPlayerPatch.playAnimationSynchronized(WOMAnimations.BIPED_PET_LUPUS, 0.0f);
                    }
                    Object messageBuilder = " Your ";
                    if (this.m_8077_()) {
                        messageBuilder = (String)messageBuilder + "companion named ";
                        messageBuilder = (String)messageBuilder + this.m_7770_().getString();
                    } else {
                        messageBuilder = (String)messageBuilder + "unnamed companion";
                    }
                    messageBuilder = (String)messageBuilder + " is ";
                    switch (this.getCommand()) {
                        case 0: {
                            messageBuilder = (String)messageBuilder + "ordered to roam.";
                            break;
                        }
                        case 1: {
                            messageBuilder = (String)messageBuilder + "ordered to stay.";
                            break;
                        }
                        case 2: {
                            messageBuilder = (String)messageBuilder + "ordered to come.";
                            break;
                        }
                        case 3: {
                            messageBuilder = (String)messageBuilder + "ordered to follow.";
                            break;
                        }
                        default: {
                            messageBuilder = (String)messageBuilder + "confused on your order.";
                        }
                    }
                    if (!this.m_6162_()) {
                        messageBuilder = (String)messageBuilder + "\n He will ";
                        if (this.getTargeting() < 0) {
                            messageBuilder = (String)messageBuilder + "attack ";
                        } else {
                            messageBuilder = (String)messageBuilder + "defend ";
                            messageBuilder = this.getCommand() != 1 ? (String)messageBuilder + "you " : (String)messageBuilder + "his position ";
                            messageBuilder = (String)messageBuilder + "from ";
                        }
                        switch (Math.abs(this.getTargeting())) {
                            case 0: {
                                messageBuilder = (String)messageBuilder + "hostile creatures ";
                                break;
                            }
                            case 1: {
                                messageBuilder = (String)messageBuilder + "hostile creatures ";
                                break;
                            }
                            case 2: {
                                messageBuilder = (String)messageBuilder + "threatening foes ";
                                break;
                            }
                            case 3: {
                                messageBuilder = (String)messageBuilder + "anything alive ";
                                break;
                            }
                            default: {
                                messageBuilder = (String)messageBuilder + "nothing ";
                            }
                        }
                        if (this.getTargeting() < 0) {
                            messageBuilder = (String)messageBuilder + "on demand ";
                        }
                        messageBuilder = (String)messageBuilder + "and, will ";
                        switch (this.getStrategy()) {
                            case 0: {
                                messageBuilder = (String)messageBuilder + "mainly choose the same target as you.";
                                break;
                            }
                            case 1: {
                                messageBuilder = (String)messageBuilder + "mainly choose another target than you.";
                                break;
                            }
                            case 2: {
                                messageBuilder = (String)messageBuilder + "switch between targets.";
                                break;
                            }
                            case 3: {
                                messageBuilder = (String)messageBuilder + "mainly choose the closest target from ";
                                messageBuilder = this.getCommand() != 1 ? (String)messageBuilder + "you." : (String)messageBuilder + "his position.";
                            }
                        }
                    }
                    if (this.isPlayful()) {
                        messageBuilder = (String)messageBuilder + "\n Oh! It seams that he likes to play.";
                    }
                    player.m_5661_((Component)Component.m_237113_((String)messageBuilder).m_130940_(ChatFormatting.GOLD), false);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (player.m_6047_() || serverPlayerPatch != null && !lupusRexPatch.isLogicalClient() && serverPlayerPatch.getServerAnimator().animationPlayer.getAnimation().equals(WOMAnimations.BIPED_PET_LUPUS)) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return super.m_6071_(player, hand);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public boolean m_7848_(Animal p_30698_) {
        if (p_30698_ == this) {
            return false;
        }
        if (!(p_30698_ instanceof LupusRex)) {
            return false;
        }
        return this.m_30628_() && ((LupusRex)p_30698_).m_30628_();
    }

    protected boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        LupusRex lupsRexBaby = (LupusRex)((EntityType)WOMEntities.LUPUS_REX.get()).m_20615_((Level)level);
        if (lupsRexBaby != null) {
            this.m_149508_(mob, lupsRexBaby);
            lupsRexBaby.m_30586_(this.m_21805_());
        }
        return lupsRexBaby;
    }

    protected void m_149508_(AgeableMob p_149509_, AbstractHorse p_149510_) {
        this.m_272015_(p_149509_, p_149510_, Attributes.f_22276_, LupusRex.m_271722_(param -> 0), LupusRex.m_271722_(param -> param - 1));
        this.m_272015_(p_149509_, p_149510_, Attributes.f_22288_, LupusRex.m_272017_(() -> 0.0), LupusRex.m_272017_(() -> 1.0));
        this.m_272015_(p_149509_, p_149510_, Attributes.f_22279_, LupusRex.m_271981_(() -> 0.0), LupusRex.m_271981_(() -> 1.0));
        this.m_272015_(p_149509_, p_149510_, Attributes.f_22281_, LupusRex.generateAttackDamage(() -> 0.0), LupusRex.generateAttackDamage(() -> 1.0));
    }

    private void m_272015_(AgeableMob p_273163_, AbstractHorse p_273784_, Attribute p_273681_, double p_272663_, double p_273405_) {
        double d0 = LupusRex.m_271715_(this.m_21172_(p_273681_), p_273163_.m_21172_(p_273681_), p_272663_, p_273405_, this.f_19796_);
        p_273784_.m_21051_(p_273681_).m_22100_(d0);
    }

    static double m_271715_(double p_272685_, double p_273709_, double p_273376_, double p_273030_, RandomSource p_272743_) {
        double d3;
        if (p_273030_ <= p_273376_) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        p_272685_ = Mth.m_14008_((double)p_272685_, (double)p_273376_, (double)p_273030_);
        p_273709_ = Mth.m_14008_((double)p_273709_, (double)p_273376_, (double)p_273030_);
        double d0 = 0.15 * (p_273030_ - p_273376_);
        double d2 = (p_272685_ + p_273709_) / 2.0;
        double d1 = Math.abs(p_272685_ - p_273709_) + d0 * 2.0;
        double d4 = d2 + d1 * (d3 = (p_272743_.m_188500_() + p_272743_.m_188500_() + p_272743_.m_188500_()) / 3.0 - 0.5);
        if (d4 > p_273030_) {
            double d6 = d4 - p_273030_;
            return p_273030_ - d6;
        }
        if (d4 < p_273376_) {
            double d5 = p_273376_ - d4;
            return p_273376_ + d5;
        }
        return d4;
    }

    public boolean m_7482_() {
        return true;
    }

    public boolean m_6010_(ItemStack p_30731_) {
        return p_30731_.m_41720_() instanceof HorseArmorItem;
    }

    protected void m_19956_(Entity p_289569_, Entity.MoveFunction p_289558_) {
        if (this.m_20363_(p_289569_)) {
            double d0 = this.m_20186_() + this.m_6048_() + p_289569_.m_6049_();
            p_289558_.m_20372_(p_289569_, this.m_20185_(), d0, this.m_20189_());
        }
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f2 = 0.2f;
        float f3 = 0.0f;
        p_289558_.m_20372_(p_289569_, this.m_20185_() + (double)(f2 * f), this.m_20186_() + this.m_6048_() + p_289569_.m_6049_() + (double)f3, this.m_20189_() - (double)(f2 * f1));
        if (p_289569_ instanceof LivingEntity) {
            ((LivingEntity)p_289569_).f_20883_ = this.f_20883_;
        }
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public boolean canAttack() {
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_30703_, DifficultyInstance p_30704_, MobSpawnType mobSpanType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag p_30707_) {
        if ((mobSpanType == MobSpawnType.NATURAL || mobSpanType == MobSpawnType.CHUNK_GENERATION) && new Random().nextBoolean()) {
            this.m_146762_(-24000);
        }
        spawnGroupData = new AgeableMob.AgeableMobGroupData(false);
        return super.m_6518_(p_30703_, p_30704_, mobSpanType, spawnGroupData, p_30707_);
    }
}

