/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.mobpatch;

import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import reascer.wom.gameasset.animations.entitys.AnimsHollow;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.mob.Hollow;
import reascer.wom.world.entity.mobpatch.WomMobPatch;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class HollowPatch
extends WomMobPatch<Hollow> {
    public HollowPatch() {
        super((Faction)Factions.UNDEAD);
        this.dashAttackAnimation = null;
        this.blackoutAnimation = AnimsHollow.HOLLOW_BLACKOUT;
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add((EntityType)WOMEntities.HOLLOW.get(), (Attribute)EpicFightAttributes.STUN_ARMOR.get(), 12.0);
    }

    protected void initAI() {
        super.initAI();
        ((Hollow)this.original).f_21345_.m_25352_(2, (Goal)new TargetChasingGoal((MobPatch)this, (PathfinderMob)this.original, 1.2, true));
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, AnimsHollow.HOLLOW_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, AnimsHollow.HOLLOW_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, AnimsHollow.HOLLOW_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.RUN, AnimsHollow.HOLLOW_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SNEAK, AnimsHollow.HOLLOW_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SPECTATE, AnimsHollow.HOLLOW_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.JUMP, AnimsHollow.HOLLOW_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, AnimsHollow.HOLLOW_DEATH);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        OpenMatrix4f mat = super.getModelMatrix(partialTicks);
        return OpenMatrix4f.scale((Vec3f)new Vec3f(1.2f, 1.2f, 1.2f), (OpenMatrix4f)mat, (OpenMatrix4f)mat);
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (((Hollow)this.original).m_6084_() && this.getTarget() != null && ((Hollow)this.original).m_6779_(this.getTarget()) && !((Hollow)this.original).m_9236_().m_5776_()) {
            this.AttackPatern();
        }
    }

    public void AttackPatern() {
        if (this.getTarget().m_20270_(this.original) < 3.0f && this.getEntityState().canBasicAttack() && !((Hollow)this.original).m_9236_().m_5776_() && this.getEntityState().canBasicAttack()) {
            if (this.currentAnimation().equals(AnimsHollow.HOLLOW_DIAGONAL_UP_SWING) || this.currentAnimation().equals(AnimsHollow.HOLLOW_SHIELDBUMP)) {
                if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsHollow.HOLLOW_DOWNCUT, 0.0f);
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsHollow.HOLLOW_THRUST, 0.0f);
                }
            } else if (!this.currentAnimation().equals(AnimsHollow.HOLLOW_DIAGONAL_DOWN_SWING)) {
                this.playAnimationSynchronized((AssetAccessor)AnimsHollow.HOLLOW_DIAGONAL_DOWN_SWING, 0.0f);
            } else if (((Hollow)this.getOriginal()).m_21206_().m_41720_() == Items.f_42740_ && new Random().nextBoolean()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsHollow.HOLLOW_SHIELDBUMP, 0.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)AnimsHollow.HOLLOW_DIAGONAL_UP_SWING, 0.0f);
            }
        }
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult attack_success = super.attack(damageSource, target, hand);
        return attack_success;
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (this.getTarget() != null && !damageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE) && (damageSource.m_276093_(DamageTypes.f_268566_) || damageSource.m_276093_(DamageTypes.f_268464_))) {
            if (!this.currentAnimation().equals(AnimsHollow.HOLLOW_SHIELD)) {
                return super.tryHurt(damageSource, amount);
            }
            Vec3 deltaMove = ((Hollow)this.getOriginal()).m_20184_();
            Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(((Hollow)this.getOriginal()).m_5686_(1.0f), ((Hollow)this.getOriginal()).m_5675_(1.0f)));
            Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(-0.05));
            if (this.getElapsedTime() > 0.3f) {
                ((Hollow)this.getOriginal()).m_20334_(jumpDir.f_82479_ + deltaMove.f_82479_, jumpDir.f_82480_ + deltaMove.f_82480_, jumpDir.f_82481_ + deltaMove.f_82481_);
            }
            if (!this.isLogicalClient()) {
                ((Hollow)this.getOriginal()).m_9236_().m_6263_(null, ((Hollow)this.getOriginal()).m_20185_(), ((Hollow)this.getOriginal()).m_20186_(), ((Hollow)this.getOriginal()).m_20189_(), SoundEvents.f_12346_, SoundSource.MASTER, 0.5f, 1.0f - (new Random().nextFloat() - 0.5f) * 0.2f);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)((Hollow)this.getOriginal()).m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, this.getOriginal(), damageSource.m_7640_());
            }
            return AttackResult.blocked((float)amount);
        }
        return super.tryHurt(damageSource, amount);
    }
}

