/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.mobpatch;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.living.LivingEvent;
import reascer.wom.gameasset.animations.entitys.AnimsLycanth;
import reascer.wom.world.entity.ai.goals.DashAttackGoal;
import reascer.wom.world.entity.ai.goals.RunAroundTargetGoal;
import reascer.wom.world.entity.ai.goals.WOMRandomLookAroundGoal;
import reascer.wom.world.entity.mob.Lycanth;
import reascer.wom.world.entity.mobpatch.WomMobPatch;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class LycanthPatch
extends WomMobPatch<Lycanth> {
    public boolean canHowl;

    public LycanthPatch() {
        super((Faction)Factions.NEUTRAL);
        this.dashAttackAnimation = AnimsLycanth.LYCANTH_GUTS_REAPER;
        this.blackoutAnimation = AnimsLycanth.LYCANTH_BLACKOUT;
        this.canHowl = true;
    }

    protected void initAI() {
        super.initAI();
        ((Lycanth)this.original).f_21345_.m_25352_(0, new RunAroundTargetGoal<LycanthPatch>(this, 100, 200, 40, 120, AnimsLycanth.LYCANTH_RUN));
        if (((Lycanth)this.original).isUnholy()) {
            ((Lycanth)this.original).f_21345_.m_25352_(1, (Goal)new DashAttackGoal(this, (PathfinderMob)this.original, 3.5, false, 7.0, false));
            ((Lycanth)this.original).f_21345_.m_25352_(2, (Goal)new TargetChasingGoal((MobPatch)this, (PathfinderMob)this.original, 1.0, true));
        } else {
            ((Lycanth)this.original).f_21345_.m_25352_(1, (Goal)new DashAttackGoal(this, (PathfinderMob)this.original, 1.8, false, 5.0, false));
            ((Lycanth)this.original).f_21345_.m_25352_(2, (Goal)new TargetChasingGoal((MobPatch)this, (PathfinderMob)this.original, 1.4, true));
        }
        if (!((Lycanth)this.original).isUnholy()) {
            ((Lycanth)this.original).f_21345_.m_25352_(10, (Goal)new WOMRandomLookAroundGoal(this));
        }
    }

    public void modifyLivingMotionByCurrentItem(boolean onStartTracking) {
        HashMap newLivingAnimations = Maps.newHashMap();
        boolean hasChange = false;
        if (((Lycanth)this.getOriginal()).isUnholy()) {
            newLivingAnimations.put(LivingMotions.IDLE, AnimsLycanth.UNHOLY_LYCANTH_IDLE);
            newLivingAnimations.put(LivingMotions.WALK, AnimsLycanth.UNHOLY_LYCANTH_WALK);
            newLivingAnimations.put(LivingMotions.CHASE, AnimsLycanth.LYCANTH_RUN);
            newLivingAnimations.put(LivingMotions.RUN, AnimsLycanth.UNHOLY_LYCANTH_RUN);
            newLivingAnimations.put(LivingMotions.SNEAK, AnimsLycanth.LYCANTH_IDLE);
            newLivingAnimations.put(LivingMotions.SPECTATE, AnimsLycanth.LYCANTH_IDLE);
            newLivingAnimations.put(LivingMotions.JUMP, AnimsLycanth.UNHOLY_LYCANTH_WALK);
            newLivingAnimations.put(LivingMotions.DEATH, AnimsLycanth.LYCANTH_DEATH);
            hasChange = true;
            this.dashAttackAnimation = AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH_REVERSE;
            this.dissableRunAroundTarget = true;
        } else {
            newLivingAnimations.put(LivingMotions.IDLE, AnimsLycanth.LYCANTH_IDLE);
            newLivingAnimations.put(LivingMotions.WALK, AnimsLycanth.LYCANTH_WALK);
            newLivingAnimations.put(LivingMotions.CHASE, AnimsLycanth.LYCANTH_RUN);
            newLivingAnimations.put(LivingMotions.RUN, AnimsLycanth.LYCANTH_RUN);
            newLivingAnimations.put(LivingMotions.SNEAK, AnimsLycanth.LYCANTH_IDLE);
            newLivingAnimations.put(LivingMotions.SPECTATE, AnimsLycanth.LYCANTH_IDLE);
            newLivingAnimations.put(LivingMotions.JUMP, AnimsLycanth.UNHOLY_LYCANTH_WALK);
            newLivingAnimations.put(LivingMotions.DEATH, AnimsLycanth.LYCANTH_DEATH);
            hasChange = true;
        }
        if (hasChange || onStartTracking) {
            this.getAnimator().resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> ((Animator)this.getAnimator()).addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((Lycanth)this.original).m_19879_());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)msg, (Entity)this.original, (Object[])new Object[0]);
        }
    }

    public void onStartTracking(ServerPlayer trackingPlayer) {
        this.modifyLivingMotionByCurrentItem(true);
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, AnimsLycanth.LYCANTH_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, AnimsLycanth.LYCANTH_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, AnimsLycanth.LYCANTH_RUN);
        animator.addLivingAnimation((LivingMotion)LivingMotions.RUN, AnimsLycanth.LYCANTH_RUN);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SNEAK, AnimsLycanth.LYCANTH_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SPECTATE, AnimsLycanth.LYCANTH_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.JUMP, AnimsLycanth.LYCANTH_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, AnimsLycanth.LYCANTH_DEATH);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
        if (((Lycanth)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else if (((Lycanth)this.original).f_267362_.m_267731_() > 0.01f) {
            this.currentLivingMotion = ((Lycanth)this.original).m_20184_().m_165924_() > ((Lycanth)this.original).m_21133_(Attributes.f_22279_) * (double)0.8f ? LivingMotions.RUN : LivingMotions.WALK;
        }
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        OpenMatrix4f mat = super.getModelMatrix(partialTicks);
        if (((Lycanth)this.getOriginal()).isUnholy()) {
            return OpenMatrix4f.scale((Vec3f)new Vec3f(1.25f, 1.25f, 1.25f), (OpenMatrix4f)mat, (OpenMatrix4f)mat);
        }
        return OpenMatrix4f.scale((Vec3f)new Vec3f(1.4f, 1.4f, 1.4f), (OpenMatrix4f)mat, (OpenMatrix4f)mat);
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (this.getTarget() != null && ((Lycanth)this.getOriginal()).m_6084_()) {
            if (this.canHowl && !((Lycanth)this.original).isUnholy()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.LYCANTH_HOWL, new Random().nextFloat(0.0f, 0.4f));
                this.canHowl = false;
            }
        } else {
            this.canHowl = true;
        }
        if (((Lycanth)this.original).m_6084_() && this.getTarget() != null && ((Lycanth)this.original).m_6779_(this.getTarget()) && !((Lycanth)this.original).m_9236_().m_5776_()) {
            this.AttackPatern();
        }
    }

    public void AttackPatern() {
        if (((Lycanth)this.getOriginal()).isUnholy()) {
            boolean isKnockdown = false;
            LivingEntityPatch livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.getTarget(), LivingEntityPatch.class);
            if (livingEntityPatch != null && livingEntityPatch.getEntityState().knockDown()) {
                isKnockdown = true;
            }
            if (!isKnockdown) {
                if (this.currentAnimation().equals(AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH) && this.getEntityState().canBasicAttack()) {
                    if (this.lastAttackResultType == AttackResult.ResultType.MISSED || new Random().nextBoolean()) {
                        if (this.getTarget().m_20270_(this.original) > 5.0f) {
                            this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.LYCANTH_GUTS_REAPER, 0.0f);
                        } else {
                            this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_GUARD_BREAKER, 0.0f);
                        }
                    } else if (this.getTarget().m_20270_(this.original) < 5.0f) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH_REVERSE, 0.0f);
                    }
                }
                if (this.currentAnimation().equals(AnimsLycanth.UNHOLY_LYCANTH_TWISTED_BACKSTEP) && this.getEntityState().canBasicAttack()) {
                    if (this.lastAttackResultType == AttackResult.ResultType.MISSED || new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_GUARD_BREAKER, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_GRASP, 0.0f);
                    }
                }
                if (this.currentAnimation().equals(AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH_REVERSE) && this.getEntityState().canBasicAttack() && this.getTarget().m_20270_(this.original) < 4.0f) {
                    this.rotateTo((Entity)this.getTarget(), 360.0f, false);
                    ((Lycanth)this.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, this.getTarget().m_20182_());
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH, 0.3f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_TWISTED_BACKSTEP, 0.0f);
                    }
                }
                if (this.currentAnimation().equals(AnimsLycanth.UNHOLY_LYCANTH_GUARD_BREAKER) && this.getEntityState().canBasicAttack()) {
                    if (this.lastAttackResultType == AttackResult.ResultType.MISSED || new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_TWISTED_BACKSTEP, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_GRASP, 0.0f);
                    }
                }
                if (this.getTarget().m_20270_(this.original) < 3.0f && this.getEntityState().canBasicAttack() && !((Lycanth)this.original).m_9236_().m_5776_()) {
                    if (new Random().nextBoolean()) {
                        if (!this.currentAnimation().equals(AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH_REVERSE)) {
                            this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH_REVERSE, 0.0f);
                        }
                    } else if (!this.currentAnimation().equals(AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH)) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.UNHOLY_LYCANTH_WIDE_SLASH, 0.0f);
                    }
                }
            }
        } else {
            if (this.getTarget().m_20270_(this.original) < 3.0f && this.getEntityState().canBasicAttack() && !((Lycanth)this.original).m_9236_().m_5776_() && !this.currentAnimation().equals(AnimsLycanth.LYCANTH_LEFT_CLAW)) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.LYCANTH_LEFT_CLAW, 0.0f);
            }
            if (this.currentAnimation().equals(AnimsLycanth.LYCANTH_LEFT_CLAW) && this.getEntityState().canBasicAttack()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.LYCANTH_RIGHT_CLAW, 0.0f);
            }
            if (this.currentAnimation().equals(AnimsLycanth.LYCANTH_RIGHT_CLAW) && this.getEntityState().canBasicAttack()) {
                if (this.getTarget().m_20270_(this.original) < 3.0f) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.LYCANTH_LEFT_CLAW, 0.0f);
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsLycanth.LYCANTH_GUTS_REAPER, 0.0f);
                }
            }
        }
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult attack_success = super.attack(damageSource, target, hand);
        return attack_success;
    }
}

