/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.mobpatch;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import reascer.wom.gameasset.animations.entitys.AnimsSaulomonk;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.ai.goals.DashAttackGoal;
import reascer.wom.world.entity.mob.Saulomonk;
import reascer.wom.world.entity.mobpatch.WomMobPatch;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class SaulomonkPatch
extends WomMobPatch<Saulomonk> {
    public boolean canBeamAttack = true;

    public SaulomonkPatch() {
        super((Faction)Factions.NEUTRAL);
        this.dashAttackAnimation = AnimsSaulomonk.SAULOMONK_ORBIT_REACHING_DASH;
        this.blackoutAnimation = AnimsSaulomonk.SAULOMONK_HIT_BLACKOUT;
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add((EntityType)WOMEntities.HOLLOW.get(), (Attribute)EpicFightAttributes.STUN_ARMOR.get(), 6.0);
    }

    protected void initAI() {
        super.initAI();
        ((Saulomonk)this.original).f_21345_.m_25352_(1, (Goal)new DashAttackGoal(this, (PathfinderMob)this.original, 3.0, false, 6.0, false));
        ((Saulomonk)this.original).f_21345_.m_25352_(2, (Goal)new TargetChasingGoal((MobPatch)this, (PathfinderMob)this.original, 1.0, true));
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, AnimsSaulomonk.SAULOMONK_ORBIT_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, AnimsSaulomonk.SAULOMONK_ORBIT_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, AnimsSaulomonk.SAULOMONK_ORBIT_RUN);
        animator.addLivingAnimation((LivingMotion)LivingMotions.RUN, AnimsSaulomonk.SAULOMONK_ORBIT_RUN);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SNEAK, AnimsSaulomonk.SAULOMONK_ORBIT_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.SPECTATE, AnimsSaulomonk.SAULOMONK_ORBIT_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.JUMP, AnimsSaulomonk.SAULOMONK_ORBIT_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, AnimsSaulomonk.SAULOMONK_DEATH);
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        this.modifyLivingMotionByCurrentItem(false);
        super.updateHeldItem(fromCap, toCap, from, to, hand);
    }

    public void modifyLivingMotionByCurrentItem(boolean onStartTracking) {
        HashMap newLivingAnimations = Maps.newHashMap();
        boolean hasChange = false;
        if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ORBIT.get()) {
            newLivingAnimations.put(LivingMotions.IDLE, AnimsSaulomonk.SAULOMONK_ORBIT_IDLE);
            newLivingAnimations.put(LivingMotions.WALK, AnimsSaulomonk.SAULOMONK_ORBIT_WALK);
            newLivingAnimations.put(LivingMotions.CHASE, AnimsSaulomonk.SAULOMONK_ORBIT_RUN);
            newLivingAnimations.put(LivingMotions.RUN, AnimsSaulomonk.SAULOMONK_ORBIT_RUN);
            newLivingAnimations.put(LivingMotions.SNEAK, AnimsSaulomonk.SAULOMONK_ORBIT_IDLE);
            newLivingAnimations.put(LivingMotions.SPECTATE, AnimsSaulomonk.SAULOMONK_ORBIT_IDLE);
            newLivingAnimations.put(LivingMotions.JUMP, AnimsSaulomonk.SAULOMONK_ORBIT_WALK);
            newLivingAnimations.put(LivingMotions.DEATH, AnimsSaulomonk.SAULOMONK_DEATH);
            hasChange = true;
            this.dashAttackAnimation = AnimsSaulomonk.SAULOMONK_ORBIT_REACHING_DASH;
        } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.NOVA.get()) {
            newLivingAnimations.put(LivingMotions.IDLE, AnimsSaulomonk.SAULOMONK_NOVA_IDLE);
            newLivingAnimations.put(LivingMotions.WALK, AnimsSaulomonk.SAULOMONK_NOVA_WALK);
            newLivingAnimations.put(LivingMotions.CHASE, AnimsSaulomonk.SAULOMONK_ORBIT_RUN);
            newLivingAnimations.put(LivingMotions.RUN, AnimsSaulomonk.SAULOMONK_ORBIT_RUN);
            newLivingAnimations.put(LivingMotions.SNEAK, AnimsSaulomonk.SAULOMONK_NOVA_IDLE);
            newLivingAnimations.put(LivingMotions.SPECTATE, AnimsSaulomonk.SAULOMONK_NOVA_IDLE);
            newLivingAnimations.put(LivingMotions.JUMP, AnimsSaulomonk.SAULOMONK_NOVA_WALK);
            newLivingAnimations.put(LivingMotions.DEATH, AnimsSaulomonk.SAULOMONK_DEATH);
            hasChange = true;
            this.dashAttackAnimation = AnimsSaulomonk.SAULOMONK_NOVA_FAST_STAB;
        } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.BLACKSTAR.get()) {
            newLivingAnimations.put(LivingMotions.IDLE, AnimsSaulomonk.SAULOMONK_BLACKSTAR_IDLE);
            newLivingAnimations.put(LivingMotions.WALK, AnimsSaulomonk.SAULOMONK_BLACKSTAR_WALK);
            newLivingAnimations.put(LivingMotions.CHASE, AnimsSaulomonk.SAULOMONK_ORBIT_RUN);
            newLivingAnimations.put(LivingMotions.RUN, AnimsSaulomonk.SAULOMONK_ORBIT_RUN);
            newLivingAnimations.put(LivingMotions.SNEAK, AnimsSaulomonk.SAULOMONK_BLACKSTAR_IDLE);
            newLivingAnimations.put(LivingMotions.SPECTATE, AnimsSaulomonk.SAULOMONK_BLACKSTAR_IDLE);
            newLivingAnimations.put(LivingMotions.JUMP, AnimsSaulomonk.SAULOMONK_BLACKSTAR_WALK);
            newLivingAnimations.put(LivingMotions.DEATH, AnimsSaulomonk.SAULOMONK_DEATH);
            hasChange = true;
            this.canDashAtack = false;
            this.dissableDashAttack = true;
        }
        if (hasChange || onStartTracking) {
            this.getAnimator().resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> ((Animator)this.getAnimator()).addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((Saulomonk)this.original).m_19879_());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)msg, (Entity)this.original, (Object[])new Object[0]);
        }
    }

    public void onStartTracking(ServerPlayer trackingPlayer) {
        this.modifyLivingMotionByCurrentItem(true);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
        if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else if (((Saulomonk)this.original).f_267362_.m_267731_() > 0.01f) {
            this.currentLivingMotion = ((Saulomonk)this.original).m_20184_().m_165924_() > ((Saulomonk)this.original).m_21133_(Attributes.f_22279_) * (double)0.8f ? LivingMotions.RUN : LivingMotions.WALK;
        }
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        OpenMatrix4f mat = super.getModelMatrix(partialTicks);
        return OpenMatrix4f.scale((Vec3f)new Vec3f(0.9f, 0.9f, 0.9f), (OpenMatrix4f)mat, (OpenMatrix4f)mat);
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        LivingEntityPatch livingEntityPatch;
        super.tick(event);
        if (((Saulomonk)this.getOriginal()).m_6084_() && !((Saulomonk)this.getOriginal()).m_21023_(MobEffects.f_19605_)) {
            ((Saulomonk)this.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19605_, -1, 2, false, false, false));
        }
        if (((Saulomonk)this.getOriginal()).m_19880_().contains("wom_saulomonk_buffed") && ((Saulomonk)this.getOriginal()).m_6084_()) {
            if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.BLACKSTAR.get() && !this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_BLACKSTAR_BUFFING)) {
                if (!((Saulomonk)this.getOriginal()).m_21023_(MobEffects.f_19606_)) {
                    ((Saulomonk)this.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 1, false, true));
                }
            } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.NOVA.get() && !this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_NOVA_BUFFING)) {
                ((Saulomonk)this.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, -1, 0, false, true));
                ((Saulomonk)this.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19598_, -1, 0, false, true));
            } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ORBIT.get() && !this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_BUFFING) && !((Saulomonk)this.getOriginal()).m_21023_(MobEffects.f_19600_)) {
                ((Saulomonk)this.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19600_, -1, 1, false, true));
            }
        }
        Vec3f offeset = new Vec3f(0.0f, 0.0f, 1.5f);
        OpenMatrix4f posrotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((Saulomonk)this.getOriginal()).m_5675_(1.0f))), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.transform3v((OpenMatrix4f)posrotation, (Vec3f)offeset, (Vec3f)offeset);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((double)offeset.x + ((Saulomonk)this.getOriginal()).m_20185_(), (double)offeset.y + ((Saulomonk)this.getOriginal()).m_20186_(), (double)offeset.z + ((Saulomonk)this.getOriginal()).m_20189_());
        BlockState block = ((Saulomonk)this.getOriginal()).m_9236_().m_8055_((BlockPos)pos);
        BlockState block2 = ((Saulomonk)this.getOriginal()).m_9236_().m_8055_(pos.m_7494_());
        if (!(block.m_60713_(Blocks.f_50016_) || block.m_60713_(Blocks.f_49990_) || block.m_60812_((BlockGetter)((Saulomonk)this.getOriginal()).m_9236_(), (BlockPos)pos) == Shapes.m_83040_() || block.m_60812_((BlockGetter)((Saulomonk)this.getOriginal()).m_9236_(), (BlockPos)pos) != Shapes.m_83144_() && !block.m_204336_(BlockTags.f_13031_) && !block.m_204336_(BlockTags.f_13030_) || block.m_204336_(BlockTags.f_13047_) || block.m_60713_(Blocks.f_50375_) || block2.m_60634_((BlockGetter)((Saulomonk)this.getOriginal()).m_9236_(), pos.m_7494_(), this.original) || this.isStunned())) {
            Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(((Saulomonk)this.getOriginal()).m_5686_(1.0f), ((Saulomonk)this.getOriginal()).m_5675_(1.0f)));
            Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(0.1));
            ((Saulomonk)this.getOriginal()).m_20334_(jumpDir.f_82479_, 0.2f, jumpDir.f_82481_);
        }
        this.currentLivingMotion = !((Saulomonk)this.original).m_9236_().m_5776_() && this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_1) || this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_2) ? LivingMotions.BLOCK : LivingMotions.INACTION;
        if (!((Saulomonk)this.original).m_9236_().m_5776_()) {
            if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.BLACKSTAR.get()) {
                if (((Saulomonk)this.getOriginal()).m_21223_() < ((Saulomonk)this.getOriginal()).m_21233_() * 0.5f && ((Saulomonk)this.getOriginal()).m_6084_() && !((Saulomonk)this.getOriginal()).m_19880_().contains("wom_saulomonk_buffed") && !this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_BLACKSTAR_BUFFING)) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_BUFFING, 0.0f);
                }
            } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.NOVA.get()) {
                if (((Saulomonk)this.getOriginal()).m_21223_() < ((Saulomonk)this.getOriginal()).m_21233_() * 0.5f && ((Saulomonk)this.getOriginal()).m_6084_() && !((Saulomonk)this.getOriginal()).m_19880_().contains("wom_saulomonk_buffed") && !this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_NOVA_BUFFING)) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_BUFFING, 0.0f);
                }
            } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ORBIT.get() && ((Saulomonk)this.getOriginal()).m_21223_() < ((Saulomonk)this.getOriginal()).m_21233_() * 0.5f && ((Saulomonk)this.getOriginal()).m_6084_() && !((Saulomonk)this.getOriginal()).m_19880_().contains("wom_saulomonk_buffed") && !this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_BUFFING)) {
                this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_BUFFING, 0.0f);
            }
        }
        if ((livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.getTarget(), LivingEntityPatch.class)) != null && livingEntityPatch.getEntityState().knockDown()) {
            if (this.getEntityState().canBasicAttack() && this.getTarget().m_20270_(this.original) < 5.0f) {
                if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.NOVA.get()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_DODGE_BACKWARD, 0.0f);
                } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ORBIT.get()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_BACKSTEP, 0.0f);
                }
            }
        } else if (((Saulomonk)this.original).m_6084_() && this.getTarget() != null && ((Saulomonk)this.original).m_6779_(this.getTarget()) && !((Saulomonk)this.original).m_9236_().m_5776_()) {
            this.AttackPatern();
            this.beamAttack();
        }
    }

    public void beamAttack() {
        if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.NOVA.get()) {
            if (this.canBeamAttack && this.canDashAtack && this.getEntityState().canBasicAttack()) {
                this.rotateTo((Entity)this.getTarget(), 360.0f, false);
                ((Saulomonk)this.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, this.getTarget().m_20182_());
                this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_GUILEFUL_MUTILATION, 0.0f);
                this.canBeamAttack = false;
            }
            if (!this.canDashAtack) {
                this.canBeamAttack = true;
            }
        } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ORBIT.get()) {
            if (this.canBeamAttack && this.canDashAtack && this.getEntityState().canBasicAttack()) {
                this.rotateTo((Entity)this.getTarget(), 360.0f, false);
                ((Saulomonk)this.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, this.getTarget().m_20182_());
                this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_BEAM, 0.0f);
                this.canBeamAttack = false;
            }
            if (!this.canDashAtack) {
                this.canBeamAttack = true;
            }
        }
    }

    public void AttackPatern() {
        if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.BLACKSTAR.get()) {
            if (this.getEntityState().canBasicAttack() && this.getTarget().m_20270_(this.original) > 6.0f) {
                this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_CHARGING, 0.0f);
            }
            if (this.getEntityState().canBasicAttack() && this.getTarget().m_20270_(this.original) < 4.0f) {
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_BLACKSTAR_BUMPING_THRUST)) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_GRAVITY, new Random().nextFloat(0.05f, 0.35f));
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_FULL_ARC, new Random().nextFloat(0.05f, 0.35f));
                    }
                }
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_BLACKSTAR_CHARGING) && this.getEntityState().canBasicAttack()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_DEMI_ARC, new Random().nextFloat(0.05f, 0.35f));
                }
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_BLACKSTAR_DEMI_ARC) && this.getEntityState().canBasicAttack()) {
                    if (new Random().nextBoolean()) {
                        if (new Random().nextBoolean()) {
                            this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_FULL_ARC, new Random().nextFloat(0.05f, 0.35f));
                        } else {
                            this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_DEMI_ARC, new Random().nextFloat(0.05f, 0.35f));
                        }
                    } else if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_BUMPING_THRUST, new Random().nextFloat(0.05f, 0.35f));
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_GRAVITY, new Random().nextFloat(0.05f, 0.35f));
                    }
                }
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_BLACKSTAR_FULL_ARC) && this.getEntityState().canBasicAttack()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_DEMI_ARC, new Random().nextFloat(0.05f, 0.35f));
                }
                if (this.getEntityState().canBasicAttack()) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_FULL_ARC, new Random().nextFloat(0.05f, 0.35f));
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_BLACKSTAR_BUMPING_THRUST, new Random().nextFloat(0.05f, 0.35f));
                    }
                }
            }
        } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.NOVA.get()) {
            if (this.getEntityState().canBasicAttack() && this.getTarget().m_20270_(this.original) < 6.0f) {
                this.rotateTo((Entity)this.getTarget(), 360.0f, false);
                ((Saulomonk)this.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, this.getTarget().m_20182_());
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_NOVA_FAST_STAB)) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_SPIN_DOUBLE_SLASH, 0.0f);
                }
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_NOVA_DOUBLE_SLASH_AND_STAB)) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_FAST_STAB, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_ANGLED_TORNADO, 0.0f);
                    }
                }
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_NOVA_SPIN_DOUBLE_SLASH) && this.getEntityState().canBasicAttack()) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_DOUBLE_SLASH_AND_STAB, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_GUILEFUL_MUTILATION, 0.0f);
                    }
                }
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_NOVA_SPIN_SLASH)) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_SPIN_DOUBLE_SLASH, 0.0f);
                }
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_NOVA_ANGLED_TORNADO) && this.getEntityState().canBasicAttack()) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_SPIN_SLASH, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_GUILEFUL_MUTILATION, 0.0f);
                    }
                }
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_NOVA_GUILEFUL_MUTILATION) && this.getEntityState().canBasicAttack()) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_SPIN_DOUBLE_SLASH, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_SPIN_SLASH, 0.0f);
                    }
                }
                if (this.getEntityState().canBasicAttack() && this.getTarget().m_20270_(this.original) < 4.0f) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_FAST_STAB, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_SPIN_SLASH, 0.0f);
                    }
                }
            }
        } else if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ORBIT.get()) {
            if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_TRIGGER) && this.getEntityState().canBasicAttack()) {
                this.rotateTo((Entity)this.getTarget(), 360.0f, false);
                ((Saulomonk)this.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, this.getTarget().m_20182_());
                if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_BACKSTEP, 0.0f);
                } else if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_LEFT, 0.0f);
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_RIGHT, 0.0f);
                }
            }
            if (this.getElapsedTime() > 0.65f) {
                if (this.getTarget().m_20270_(this.original) < 6.0f && (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_LEFT) || this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_RIGHT) || this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_FRONTSTEP))) {
                    this.rotateTo((Entity)this.getTarget(), 360.0f, false);
                    ((Saulomonk)this.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, this.getTarget().m_20182_());
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SATELITE, 0.0f);
                } else if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_BACKSTEP) || this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_LEFT) || this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_RIGHT) || this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_FRONTSTEP)) {
                    this.rotateTo((Entity)this.getTarget(), 360.0f, false);
                    ((Saulomonk)this.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.FEET, this.getTarget().m_20182_());
                    if (this.getTarget().m_20270_(this.original) < 5.0f) {
                        if (new Random().nextBoolean()) {
                            this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_BACKSTEP, 0.0f);
                        } else if (new Random().nextBoolean()) {
                            this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_LEFT, 0.0f);
                        } else {
                            this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_RIGHT, 0.0f);
                        }
                    } else if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_FRONTSTEP, 0.0f);
                    } else if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_LEFT, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_SIDESTEP_RIGHT, 0.0f);
                    }
                }
            }
            if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_ARMADA) && this.getElapsedTime() >= 1.5f && !this.canDashAtack) {
                if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_BEAM, 0.3f);
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_SPIN_SLASH, 0.0f);
                }
            }
            if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_ARMADA) && this.getEntityState().canBasicAttack() && !this.canDashAtack) {
                this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_SPIN_SLASH, 0.0f);
            }
            if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_COUNTER) && this.getEntityState().canBasicAttack() && !this.canDashAtack) {
                if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ROTATION_SLASH, 0.0f);
                } else if (new Random().nextBoolean()) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_TRIGGER, 0.0f);
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_REACHING_DASH, 0.0f);
                }
            }
            if (this.getTarget().m_20270_(this.original) < 4.0f && this.getEntityState().canBasicAttack() && !this.canDashAtack) {
                if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_REACHING_DASH)) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_ARMADA, 0.0f);
                } else if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_SPIN_SLASH)) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ROTATION_SLASH, 0.0f);
                    } else if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_TRIGGER, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_REACHING_DASH, 0.0f);
                    }
                } else if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ROTATION_SLASH)) {
                    if (new Random().nextBoolean()) {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_MAD_STANCE_TRIGGER, 0.0f);
                    } else {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_REACHING_DASH, 0.0f);
                    }
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_SPIN_SLASH, 0.0f);
                }
            }
        }
    }

    public boolean applyStun(StunType stunType, float stunTime) {
        ((Saulomonk)this.original).f_20900_ = 0.0f;
        ((Saulomonk)this.original).f_20901_ = 0.0f;
        ((Saulomonk)this.original).f_20902_ = 0.0f;
        ((Saulomonk)this.original).m_20334_(0.0, 0.0, 0.0);
        this.cancelKnockback = true;
        boolean stun_resist = new Random().nextBoolean();
        if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.BLACKSTAR.get() && ((Saulomonk)this.getOriginal()).m_21023_(MobEffects.f_19606_)) {
            boolean bl = stun_resist = new Random().nextInt(0, 100) < 85;
        }
        if (!((Saulomonk)this.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) && !stun_resist) {
            if (stunType == StunType.NONE) {
                if ((double)stunTime <= 1.5) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_HIT_LIGHT, -0.3f * (1.0f - stunTime / 1.35f));
                } else {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_HIT_MEDIUM, Math.min(-2.0f * (1.0f - stunTime / 5.0f), 0.0f));
                }
                return true;
            }
            if (stunType == StunType.SHORT) {
                this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_HIT_HOLD, stunTime - 0.2f);
                return true;
            }
        }
        if (!((Saulomonk)this.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) && stunType == StunType.KNOCKDOWN) {
            this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_HIT_MEDIUM, 0.0f);
            return true;
        }
        return false;
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.NOVA.get()) {
            if (this.getTarget() != null && !damageSource.m_269533_(EpicFightDamageTypeTags.BYPASS_DODGE) && (damageSource.m_276093_(DamageTypes.f_268566_) || damageSource.m_276093_(DamageTypes.f_268464_)) && new Random().nextBoolean() && !this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_HIT_BLACKOUT) && !this.getEntityState().attacking()) {
                switch (new Random().nextInt(1, 4)) {
                    case 1: {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_DODGE_BACKWARD, 0.0f);
                        break;
                    }
                    case 2: {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_DODGE_LEFT, 0.0f);
                        break;
                    }
                    case 3: {
                        this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_NOVA_DODGE_RIGHT, 0.0f);
                    }
                }
                return AttackResult.missed((float)amount);
            }
            return super.tryHurt(damageSource, amount);
        }
        if (((Saulomonk)this.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ORBIT.get() && this.getTarget() != null && !damageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE) && (damageSource.m_276093_(DamageTypes.f_268566_) || damageSource.m_276093_(DamageTypes.f_268464_))) {
            if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_1)) {
                if (this.getElapsedTime() > 0.5f) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_2, 0.0f);
                }
            } else if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_2)) {
                if (this.getElapsedTime() > 0.5f) {
                    this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_COUNTER, -0.2f);
                }
            } else if (this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_COUNTER) && this.getElapsedTime() < 0.3f) {
                this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_COUNTER, -0.2f);
            } else if (new Random().nextInt(0, 100) < 70 && !this.currentAnimation().equals(AnimsSaulomonk.SAULOMONK_HIT_BLACKOUT) && !this.getEntityState().attacking()) {
                this.playAnimationSynchronized((AssetAccessor)AnimsSaulomonk.SAULOMONK_ORBIT_PARRY_1, 0.0f);
            } else {
                Vec3 deltaMove = ((Saulomonk)this.getOriginal()).m_20184_();
                Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(((Saulomonk)this.getOriginal()).m_5686_(1.0f), ((Saulomonk)this.getOriginal()).m_5675_(1.0f)));
                Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(0.2));
                ((Saulomonk)this.getOriginal()).m_20334_(jumpDir.f_82479_ + deltaMove.f_82479_, jumpDir.f_82480_ + deltaMove.f_82480_, jumpDir.f_82481_ + deltaMove.f_82481_);
                return super.tryHurt(damageSource, amount);
            }
            Vec3 deltaMove = ((Saulomonk)this.getOriginal()).m_20184_();
            Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(((Saulomonk)this.getOriginal()).m_5686_(1.0f), ((Saulomonk)this.getOriginal()).m_5675_(1.0f)));
            Vec3 jumpDir = OpenMatrix4f.transform((OpenMatrix4f)OpenMatrix4f.createRotatorDeg((float)0.0f, (Vec3f)Vec3f.Y_AXIS), (Vec3)forwardHorizontal.m_82490_(-0.2));
            if (this.getElapsedTime() > 0.3f) {
                ((Saulomonk)this.getOriginal()).m_20334_(jumpDir.f_82479_ + deltaMove.f_82479_, jumpDir.f_82480_ + deltaMove.f_82480_, jumpDir.f_82481_ + deltaMove.f_82481_);
            }
            if (!this.isLogicalClient()) {
                ((Saulomonk)this.getOriginal()).m_9236_().m_6263_(null, ((Saulomonk)this.getOriginal()).m_20185_(), ((Saulomonk)this.getOriginal()).m_20186_(), ((Saulomonk)this.getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), SoundSource.MASTER, 0.5f, 1.0f - (new Random().nextFloat() - 0.5f) * 0.2f);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)((Saulomonk)this.getOriginal()).m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, this.getOriginal(), damageSource.m_7640_());
            }
            return AttackResult.blocked((float)amount);
        }
        return super.tryHurt(damageSource, amount);
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult attack_success = super.attack(damageSource, target, hand);
        return attack_success;
    }
}

