/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.animation.attacks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import reascer.wom.animation.attacks.BasicMultipleAttackAnimation;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.projectile.AntitheusDarkness;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.StunType;

public class AntitheusShootAttackAnimation
extends BasicMultipleAttackAnimation {
    public AntitheusShootAttackAnimation(float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, antic, antic, contact, recovery, collider, colliderJoint, path, armature);
        this.newTimePair(0.0f, Float.MAX_VALUE);
        this.addStateRemoveOld(EntityState.TURNING_LOCKED, false);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_LOC_TARGET);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!self.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_().m_82549_(attackTarget.m_20184_().m_82490_(8.0));
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 1.2f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.8f, 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale;
                }
                transformSheet.readFrom(transform);
            } else {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        });
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (self, pose, entitypatch, time, partialticks) -> {
            if (self instanceof AttackAnimation) {
                float pitch = (float)Math.toDegrees(((LivingEntity)entitypatch.getOriginal()).m_20252_((float)1.0f).f_82480_);
                JointTransform armR = pose.getOrDefaultTransform("Arm_R");
                armR.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
                if (((AttackAnimation)self).getPhaseByTime((float)1.0f).colliders[0].getFirst() != Armatures.BIPED.armR) {
                    JointTransform armL = pose.getOrDefaultTransform("Arm_L");
                    armL.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
                }
                JointTransform chest = pose.getOrDefaultTransform("Chest");
                chest.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(pitch > 35.0f ? -pitch + 35.0f : 0.0f)), OpenMatrix4f::mul);
            }
        });
    }

    public AntitheusShootAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        super(convertTime, antic, preDelay, contact, recovery, collider, colliderJoint, path, armature);
    }

    public AntitheusShootAttackAnimation(float convertTime, String path, Armature armature, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
    }

    @Override
    public Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, DynamicAnimation dynamicAnimation) {
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        if (entitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(true).booleanValue()) {
            vec3.m_82490_(0.0);
        }
        return vec3;
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (!entitypatch.isLogicalClient()) {
            AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)this);
            float elapsedTime = player.getElapsedTime();
            float prevElapsedTime = player.getPrevElapsedTime();
            EntityState state = this.getState(entitypatch, elapsedTime);
            EntityState prevState = this.getState(entitypatch, prevElapsedTime);
            AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
            if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
                ((Mob)entitypatch.getOriginal()).m_21573_().m_26573_();
                ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
                LivingEntity target = entitypatch.getTarget();
                if (target != null) {
                    entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
                }
            }
            if ((prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) && (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2))) {
                Level worldIn = ((LivingEntity)entitypatch.getOriginal()).m_9236_();
                float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
                float poseTime = state.attacking() ? elapsedTime : phase.contact;
                List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
                ArrayList list2 = new ArrayList(list);
                for (Entity entity : list) {
                    if (entity instanceof Projectile) {
                        list2.remove(entity);
                        continue;
                    }
                    if (entity instanceof LivingEntity) continue;
                    list2.remove(entity);
                }
                if (list2.size() == 0) {
                    Joint joint = (Joint)phase.colliders[0].getFirst();
                    OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getAnimator().getPose(0.0f), joint);
                    transformMatrix.translate(new Vec3f(-0.2f, 0.4f, -0.4f));
                    OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_19859_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
                    Vec3 direction = ((LivingEntity)entitypatch.getOriginal()).m_20252_(1.0f);
                    AntitheusDarkness projectile = new AntitheusDarkness((EntityType<? extends AntitheusDarkness>)((EntityType)WOMEntities.ANTITHEUS_DARKNESS.get()), worldIn);
                    projectile.m_5602_(entitypatch.getOriginal());
                    projectile.m_20343_((double)transformMatrix.m30 + ((LivingEntity)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((LivingEntity)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((LivingEntity)entitypatch.getOriginal()).m_20189_());
                    projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 2.0f, 0.0f);
                    worldIn.m_7967_((Entity)projectile);
                } else if (list2.get(list2.size() - 1) != null) {
                    int entityId = ((Entity)list2.get(list2.size() - 1)).m_19879_();
                    for (Entity entity : list2) {
                        LivingEntity livingEntity;
                        if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_21124_(MobEffects.f_19615_) == null) continue;
                        entityId = livingEntity.m_19879_();
                    }
                    ((LivingEntity)entitypatch.getOriginal()).m_20049_("antitheus_pull:" + entityId);
                    ((ServerLevel)((LivingEntity)entitypatch.getOriginal()).m_9236_()).m_6263_(null, ((LivingEntity)entitypatch.getOriginal()).m_20185_(), ((LivingEntity)entitypatch.getOriginal()).m_20186_(), ((LivingEntity)entitypatch.getOriginal()).m_20189_(), SoundEvents.f_12554_, ((Entity)list2.get(list2.size() - 1)).m_5720_(), 0.4f, 2.0f);
                    ((ServerLevel)((LivingEntity)entitypatch.getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, ((Entity)list2.get(list2.size() - 1)).m_20185_(), ((Entity)list2.get(list2.size() - 1)).m_20186_() + (double)(((Entity)list2.get(list2.size() - 1)).m_20206_() / 2.0f), ((Entity)list2.get(list2.size() - 1)).m_20189_(), 20, 0.0, 0.0, 0.0, (double)0.1f);
                    for (Entity entity : list2) {
                        HurtableEntityPatch hitHurtableEntityPatch = (HurtableEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, HurtableEntityPatch.class);
                        if (hitHurtableEntityPatch == null || !phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent() || phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() != StunType.NONE) continue;
                        float stunTime = (float)((double)0.83f * (1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_)));
                        if (!((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) continue;
                        hitHurtableEntityPatch.setStunReductionOnHit(StunType.LONG);
                        hitHurtableEntityPatch.applyStun(StunType.LONG, stunTime);
                        hitHurtableEntityPatch.knockBackEntity(((LivingEntity)entitypatch.getOriginal()).m_20318_(1.0f), 0.75f);
                    }
                }
            }
        }
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = super.getPoseByTime(entitypatch, time, partialTicks);
        float pitch = (float)Math.toDegrees(((LivingEntity)entitypatch.getOriginal()).m_20252_((float)1.0f).f_82480_);
        JointTransform armR = pose.getOrDefaultTransform("Arm_R");
        armR.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        if (this.getPhaseByTime((float)partialTicks).colliders[0].getFirst() != Armatures.BIPED.armR) {
            JointTransform armL = pose.getOrDefaultTransform("Arm_L");
            armL.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        }
        JointTransform chest = pose.getOrDefaultTransform("Chest");
        chest.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(pitch > 35.0f ? -pitch + 35.0f : 0.0f)), OpenMatrix4f::mul);
        if (entitypatch instanceof PlayerPatch) {
            JointTransform head = pose.getOrDefaultTransform("Head");
            MathUtils.mulQuaternion((Quaternionf)QuaternionUtils.XP.rotationDegrees(-entitypatch.getAttackDirectionPitch()), (Quaternionf)head.rotation(), (Quaternionf)head.rotation());
        }
        return pose;
    }

    @Override
    public boolean isBasicAttackAnimation() {
        return false;
    }
}

