/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.animation.attacks;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.joml.Quaternionf;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public class BasicMultipleAttackAnimation
extends AttackAnimation {
    public BasicMultipleAttackAnimation(float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, antic, antic, contact, recovery, collider, colliderJoint, path, armature);
    }

    public BasicMultipleAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, path, armature, new AttackAnimation.Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, colliderJoint, collider));
    }

    public BasicMultipleAttackAnimation(float convertTime, float antic, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, path, armature, new AttackAnimation.Phase(0.0f, antic, antic, contact, recovery, Float.MAX_VALUE, hand, colliderJoint, collider));
    }

    public BasicMultipleAttackAnimation(float convertTime, String path, Armature armature, boolean Coordsetter, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
    }

    public BasicMultipleAttackAnimation(float convertTime, String path, Armature armature, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
        this.newTimePair(0.0f, Float.MAX_VALUE);
        this.addStateRemoveOld(EntityState.TURNING_LOCKED, false);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_LOC_TARGET);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!self.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_().m_82549_(attackTarget.m_20184_().m_82490_(8.0));
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 1.3f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 1.0f, 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale;
                }
                transformSheet.readFrom(transform);
            } else if (transformSheet != null) {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        });
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
        if (list.size() > 0) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int maxStrikes = this.getMaxStrikes(entitypatch, phase);
            while (entitypatch.getCurrenltyHurtEntities().size() < maxStrikes && hitEntities.next()) {
                Entity hitten = hitEntities.getEntity();
                LivingEntity truehittenEntity = this.getTrueEntity(hitten);
                if (truehittenEntity == null || !truehittenEntity.m_6084_() || entitypatch.getCurrenltyAttackedEntities().contains(truehittenEntity) || entitypatch.isTeammate(hitten) || !(hitten instanceof LivingEntity) && !(hitten instanceof PartEntity) || !entity.m_142582_(hitten)) continue;
                HurtableEntityPatch hitHurtableEntityPatch = (HurtableEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)hitten, HurtableEntityPatch.class);
                EpicFightDamageSource source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                float anti_stunlock = 1.0f;
                if (hitHurtableEntityPatch != null) {
                    if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent()) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE) {
                            if (truehittenEntity instanceof Player) {
                                source.setStunType(StunType.LONG);
                                source.setImpact(source.getImpact() * 8.0f);
                            } else {
                                source.setStunType(StunType.NONE);
                            }
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.HOLD && ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            source.setStunType(StunType.NONE);
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL && ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            source.setStunType(StunType.NONE);
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.KNOCKDOWN && ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            source.setStunType(StunType.NONE);
                        } else {
                            source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                        }
                    } else {
                        source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                    }
                    if (hitHurtableEntityPatch.isStunned()) {
                        for (Object tag : hitten.m_19880_()) {
                            if (!((String)tag).contains("anti_stunlock:")) continue;
                            anti_stunlock = this.applyAntiStunLock(hitten, anti_stunlock, source, phase, (String)tag, elapsedTime);
                            break;
                        }
                    } else {
                        Object tag;
                        boolean firstAttack = true;
                        tag = hitten.m_19880_().iterator();
                        while (tag.hasNext()) {
                            String tag2 = (String)tag.next();
                            if (!tag2.contains("anti_stunlock:")) continue;
                            if (!((float)hitten.f_19797_ - Float.valueOf(tag2.split(":")[2]).floatValue() <= 20.0f)) break;
                            anti_stunlock = this.applyAntiStunLock(hitten, anti_stunlock, source, phase, tag2, elapsedTime);
                            firstAttack = false;
                            break;
                        }
                        if (firstAttack) {
                            int i = 0;
                            while (i < hitten.m_19880_().size()) {
                                if ((String)hitten.m_19880_().toArray()[i] == null) continue;
                                if (((String)hitten.m_19880_().toArray()[i]).contains("anti_stunlock:")) {
                                    hitten.m_19880_().remove(hitten.m_19880_().toArray()[i]);
                                    continue;
                                }
                                ++i;
                            }
                            anti_stunlock = this.applyAntiStunLock(hitten, anti_stunlock, source, phase, null, elapsedTime);
                        }
                    }
                    if (anti_stunlock <= 0.0f) {
                        for (String tag : hitten.m_19880_()) {
                            if (!tag.contains("anti_stunlock:")) continue;
                            hitten.m_20137_(tag);
                            LivingEntityPatch livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)hitten, LivingEntityPatch.class);
                            if (livingEntityPatch == null) break;
                            livingEntityPatch.setStunShield(0.0f);
                            livingEntityPatch.setMaxStunShield(0.0f);
                            break;
                        }
                        source.setStunType(StunType.KNOCKDOWN);
                    }
                }
                int prevInvulTime = hitten.f_19802_;
                hitten.f_19802_ = 0;
                AttackResult attackResult = entitypatch.attack(source, hitten, phase.hand);
                hitten.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    if (source.getStunType() == StunType.KNOCKDOWN) {
                        truehittenEntity.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 60, 0, true, false, false));
                        if (truehittenEntity.m_21023_(MobEffects.f_19591_)) {
                            truehittenEntity.m_21195_(MobEffects.f_19591_);
                        }
                        if (truehittenEntity.m_21023_(MobEffects.f_19620_)) {
                            truehittenEntity.m_21195_(MobEffects.f_19620_);
                        }
                    }
                    hitten.m_9236_().m_6263_(null, hitten.m_20185_(), hitten.m_20186_(), hitten.m_20189_(), this.getHitSound(entitypatch, phase), hitten.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)hitten.m_9236_(), entitypatch, hitten, phase);
                    if (hitHurtableEntityPatch != null && phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent() && !((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE) {
                            float stunTime = (float)((double)(source.getImpact() * 0.6f) * (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) {
                                hitHurtableEntityPatch.applyStun(source.getStunType() == StunType.KNOCKDOWN ? StunType.KNOCKDOWN : StunType.LONG, stunTime);
                                float power = source.getImpact() * 0.25f;
                                double d1 = entity.m_20185_() - hitten.m_20185_();
                                double d0 = entity.m_20189_() - hitten.m_20189_();
                                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                    d1 = (Math.random() - Math.random()) * 0.01;
                                    d0 = (Math.random() - Math.random()) * 0.01;
                                }
                                if (!(truehittenEntity instanceof Player)) {
                                    power = (float)((double)power * (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_)));
                                }
                                if ((double)power > 0.0) {
                                    hitten.f_19812_ = true;
                                    Vec3 vec3 = hitten.m_20184_();
                                    Vec3 vec31 = new Vec3(d1, 0.0, d0).m_82541_().m_82490_((double)power);
                                    if (!(truehittenEntity instanceof Player)) {
                                        hitten.m_7618_(EntityAnchorArgument.Anchor.FEET, entity.m_20182_());
                                        hitten.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, hitten.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0) : 0.0, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                                    }
                                }
                            }
                        }
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL) {
                            float stunTime = (float)((double)(source.getImpact() * 0.6f) * (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) {
                                hitHurtableEntityPatch.applyStun(source.getStunType() == StunType.KNOCKDOWN ? StunType.KNOCKDOWN : StunType.SHORT, stunTime);
                                double power = source.getImpact() * 0.25f;
                                double d1 = entity.m_20185_() - hitten.m_20185_();
                                double d2 = entity.m_20186_() - 8.0 - hitten.m_20186_();
                                double d0 = entity.m_20189_() - hitten.m_20189_();
                                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                    d1 = (Math.random() - Math.random()) * 0.01;
                                    d0 = (Math.random() - Math.random()) * 0.01;
                                }
                                if (!(truehittenEntity instanceof Player)) {
                                    power *= 1.0 - truehittenEntity.m_21133_(Attributes.f_22278_);
                                }
                                if (power > 0.0) {
                                    hitten.f_19812_ = true;
                                    Vec3 vec3 = entity.m_20184_();
                                    Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power);
                                    if (!(truehittenEntity instanceof Player) || !(entitypatch instanceof PlayerPatch)) {
                                        hitten.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                                    }
                                }
                                if (truehittenEntity instanceof Player && entitypatch instanceof PlayerPatch) {
                                    truehittenEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, (int)(power * 4.0 * 6.0), true, false, false));
                                }
                                truehittenEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, (int)(power * 4.0 * 6.0), 20, true, false, false));
                            }
                        }
                    }
                }
                entitypatch.getCurrenltyAttackedEntities().add(truehittenEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrenltyHurtEntities().add(truehittenEntity);
            }
        }
    }

    public void postInit() {
        super.postInit();
        if (!this.properties.containsKey(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED)) {
            float basisSpeed = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(1.0f / this.getTotalTime())));
            this.addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, Float.valueOf(basisSpeed));
        }
    }

    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        boolean stiffAttack = ((GameRules.BooleanValue)((LivingEntity)entitypatch.getOriginal()).m_9236_().m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46223_();
        if (!isEnd && !nextAnimation.isMainFrameAnimation() && entitypatch.isLogicalClient() && !stiffAttack) {
            float playbackSpeed = 0.05f * this.getPlaySpeed(entitypatch, (DynamicAnimation)this);
            entitypatch.getClientAnimator().baseLayer.copyLayerTo(entitypatch.getClientAnimator().baseLayer.getLayer(Layer.Priority.HIGHEST), playbackSpeed);
        }
    }

    public Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, DynamicAnimation dynamicAnimation) {
        if (entitypatch.isLogicalClient()) {
            LocalPlayerPatch localEntityPatch = (LocalPlayerPatch)entitypatch;
            localEntityPatch.setLockOn(false);
        }
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        if (entitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3 = vec3.m_82490_(0.0);
        }
        return vec3;
    }

    public Optional<JointMaskEntry> getJointMaskEntry(LivingEntityPatch<?> entitypatch, boolean useCurrentMotion) {
        if (entitypatch.isLogicalClient() && entitypatch.getClientAnimator().getPriorityFor((DynamicAnimation)this) == Layer.Priority.HIGHEST) {
            return Optional.of(JointMaskEntry.BASIC_ATTACK_MASK);
        }
        return super.getJointMaskEntry(entitypatch, useCurrentMotion);
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }

    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = this.getRawPose(time);
        this.modifyPose((DynamicAnimation)this, pose, entitypatch, time, partialTicks);
        float pitch = ((float)Math.toDegrees(((LivingEntity)entitypatch.getOriginal()).m_20252_((float)0.0f).f_82480_) + 20.0f) / 2.0f;
        JointTransform armR = pose.getOrDefaultTransform("Arm_R");
        armR.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        if (this.getPhaseByTime((float)partialTicks).colliders[0].getFirst() != Armatures.BIPED.armR) {
            JointTransform armL = pose.getOrDefaultTransform("Arm_L");
            armL.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        }
        JointTransform chest = pose.getOrDefaultTransform("Chest");
        chest.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        return pose;
    }

    public float applyAntiStunLock(Entity hitten, float anti_stunlock, EpicFightDamageSource source, AttackAnimation.Phase phase, String tag, float poseTime) {
        boolean isPhaseFromSameAnimnation = false;
        if (tag != null) {
            if (hitten.m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos(hitten.m_20185_(), hitten.m_20186_() - 1.0, hitten.m_20189_())).m_60795_()) {
                if (String.valueOf(this.getId()).equals(tag.split(":")[3].split("-")[0]) && (float)hitten.f_19797_ / 20.0f - poseTime < Float.valueOf(tag.split(":")[3].split("-")[1]).floatValue()) {
                    anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() - 0.02f;
                    isPhaseFromSameAnimnation = true;
                } else {
                    anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() - 0.12f;
                    isPhaseFromSameAnimnation = false;
                }
            } else if (String.valueOf(this.getId()).equals(tag.split(":")[3].split("-")[0]) && (float)hitten.f_19797_ / 20.0f - poseTime < Float.valueOf(tag.split(":")[3].split("-")[1]).floatValue()) {
                anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() - 0.02f;
                isPhaseFromSameAnimnation = true;
            } else {
                anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() - 0.16f;
                isPhaseFromSameAnimnation = false;
            }
        } else {
            anti_stunlock = 1.0f;
            hitten.m_20049_("anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_ + ":" + this.getId() + "-" + ((float)hitten.f_19797_ / 20.0f - poseTime + this.phases[this.phases.length - 1].recovery));
            return anti_stunlock;
        }
        hitten.m_20137_(tag);
        int maxSavedAttack = 5;
        if (((LivingEntity)hitten).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
            anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue();
            isPhaseFromSameAnimnation = true;
        }
        Object replaceTag = "anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_;
        if (isPhaseFromSameAnimnation) {
            maxSavedAttack = 6;
        } else {
            String phaseID = String.valueOf(this.getId());
            for (int i = 3; i < tag.split(":").length && i < maxSavedAttack; ++i) {
                if (!tag.split(":")[i].split("-")[0].equals(phaseID)) continue;
                anti_stunlock -= 0.3f;
            }
            replaceTag = "anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_ + ":" + this.getId() + "-" + ((float)hitten.f_19797_ / 20.0f - poseTime + this.phases[this.phases.length - 1].recovery);
        }
        for (int i = 3; i < tag.split(":").length && i < maxSavedAttack; ++i) {
            replaceTag = ((String)replaceTag).concat(":" + tag.split(":")[i]);
        }
        hitten.m_20049_((String)replaceTag);
        return anti_stunlock;
    }
}

