/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.animation.attacks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.joml.Quaternionf;
import reascer.wom.gameasset.WOMWeaponColliders;
import reascer.wom.world.entity.WOMEntities;
import reascer.wom.world.entity.projectile.EnderBullet;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;

public class EnderblasterShootAttackAnimation
extends AttackAnimation {
    public EnderblasterShootAttackAnimation(float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, antic, antic, contact, recovery, collider, colliderJoint, path, armature);
    }

    public EnderblasterShootAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, path, armature, new AttackAnimation.Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, colliderJoint, collider));
    }

    public EnderblasterShootAttackAnimation(float convertTime, float antic, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, path, armature, new AttackAnimation.Phase(0.0f, antic, antic, contact, recovery, Float.MAX_VALUE, hand, colliderJoint, collider));
    }

    public EnderblasterShootAttackAnimation(float convertTime, String path, Armature armature, boolean Coordsetter, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
    }

    public EnderblasterShootAttackAnimation(float convertTime, String path, Armature armature, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
        this.newTimePair(0.0f, Float.MAX_VALUE);
        this.addStateRemoveOld(EntityState.TURNING_LOCKED, false);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_LOC_TARGET);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!self.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_().m_82549_(attackTarget.m_20184_().m_82490_(8.0));
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 1.2f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.8f, 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale;
                }
                transformSheet.readFrom(transform);
            } else {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        });
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (self, pose, entitypatch, time, partialticks) -> {
            if (self instanceof AttackAnimation) {
                float pitch = (float)Math.toDegrees(((LivingEntity)entitypatch.getOriginal()).m_20252_((float)1.0f).f_82480_);
                JointTransform armR = pose.getOrDefaultTransform("Arm_R");
                armR.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
                if (((AttackAnimation)self).getPhaseByTime((float)1.0f).colliders[0].getFirst() != Armatures.BIPED.armR) {
                    JointTransform armL = pose.getOrDefaultTransform("Arm_L");
                    armL.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
                }
                JointTransform chest = pose.getOrDefaultTransform("Chest");
                chest.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(pitch > 35.0f ? -pitch + 35.0f : 0.0f)), OpenMatrix4f::mul);
                JointTransform head = pose.getOrDefaultTransform("Head");
                head.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(pitch)), OpenMatrix4f::mul);
            }
        });
    }

    public void setLinkAnimation(DynamicAnimation fromAnimation, Pose pose, boolean isOnSameLayer, float timeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        float extTime = Math.max(this.convertTime + timeModifier, 0.0f);
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            AttackAnimation.Phase phase = this.getPhaseByTime(playerpatch.getAnimator().getPlayerFor((DynamicAnimation)this).getElapsedTime());
            extTime *= this.getTotalTime() * playerpatch.getAttackSpeed(phase.getHand());
        }
        extTime = Math.max(extTime - this.convertTime, 0.0f);
        super.setLinkAnimation(fromAnimation, pose, isOnSameLayer, extTime, entitypatch, dest);
    }

    public Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, DynamicAnimation dynamicAnimation) {
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        if (entitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(true).booleanValue()) {
            vec3.m_82490_(0.0);
        }
        return vec3;
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
        if (list.size() > 0) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int maxStrikes = this.getMaxStrikes(entitypatch, phase);
            while (entitypatch.getCurrenltyHurtEntities().size() < maxStrikes && hitEntities.next()) {
                Entity hitten = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(hitten);
                if (trueEntity == null || !trueEntity.m_6084_() || entitypatch.getCurrenltyAttackedEntities().contains(trueEntity) || entitypatch.isTeammate(hitten) || !(hitten instanceof LivingEntity) && !(hitten instanceof PartEntity) || !entity.m_142582_(hitten)) continue;
                HurtableEntityPatch hitHurtableEntityPatch = (HurtableEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)hitten, HurtableEntityPatch.class);
                EpicFightDamageSource source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                float anti_stunlock = 1.0f;
                if (hitHurtableEntityPatch != null) {
                    if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent()) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE) {
                            if (trueEntity instanceof Player) {
                                source.setStunType(StunType.LONG);
                                source.setImpact(source.getImpact() * 5.0f);
                            } else {
                                source.setStunType(StunType.NONE);
                            }
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.HOLD && ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            source.setStunType(StunType.NONE);
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL && ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            source.setStunType(StunType.NONE);
                        } else {
                            source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                        }
                    } else {
                        source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                    }
                    String replaceTag = "anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_ + ":" + this.getId() + "-" + phase.contact;
                    if (hitHurtableEntityPatch.isStunned()) {
                        for (String tag : hitten.m_19880_()) {
                            if (!tag.contains("anti_stunlock:")) continue;
                            anti_stunlock = this.applyAntiStunLock(hitten, anti_stunlock, source, phase, tag, replaceTag);
                            break;
                        }
                    } else {
                        boolean firstAttack = true;
                        for (String tag : hitten.m_19880_()) {
                            if (!tag.contains("anti_stunlock:")) continue;
                            if ((float)hitten.f_19797_ - Float.valueOf(tag.split(":")[2]).floatValue() > 20.0f) {
                                anti_stunlock = 1.0f;
                                break;
                            }
                            anti_stunlock = this.applyAntiStunLock(hitten, anti_stunlock, source, phase, tag, replaceTag);
                            firstAttack = false;
                            break;
                        }
                        if (firstAttack) {
                            int i = 0;
                            while (i < hitten.m_19880_().size()) {
                                if (((String)hitten.m_19880_().toArray()[i]).contains("anti_stunlock:")) {
                                    hitten.m_19880_().remove(hitten.m_19880_().toArray()[i]);
                                    continue;
                                }
                                ++i;
                            }
                            hitten.m_20049_(replaceTag);
                        }
                    }
                    float f = hitten instanceof Player ? 0.3f : 0.2f;
                    if (anti_stunlock < f) {
                        for (String tag : hitten.m_19880_()) {
                            if (!tag.contains("anti_stunlock:")) continue;
                            hitten.m_20137_(tag);
                            break;
                        }
                        source.setStunType(StunType.KNOCKDOWN);
                    }
                    source.setImpact(source.getImpact() * anti_stunlock);
                }
                int prevInvulTime = hitten.f_19802_;
                hitten.f_19802_ = 0;
                AttackResult attackResult = entitypatch.attack(source, hitten, phase.hand);
                hitten.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    if (source.getStunType() == StunType.KNOCKDOWN) {
                        ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 60, 0, true, false, false));
                    }
                    hitten.m_9236_().m_6263_(null, hitten.m_20185_(), hitten.m_20186_(), hitten.m_20189_(), this.getHitSound(entitypatch, phase), hitten.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)hitten.m_9236_(), entitypatch, hitten, phase);
                    if (hitHurtableEntityPatch != null && phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent()) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE && !(trueEntity instanceof Player)) {
                            float stunTime = (float)((double)(source.getImpact() / anti_stunlock * 0.2f) * (1.0 - trueEntity.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) {
                                hitHurtableEntityPatch.applyStun(anti_stunlock > 0.3f ? StunType.LONG : StunType.KNOCKDOWN, stunTime);
                                float power = source.getImpact() / anti_stunlock * 0.25f;
                                double d1 = entity.m_20185_() - hitten.m_20185_();
                                double d0 = entity.m_20189_() - hitten.m_20189_();
                                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                    d1 = (Math.random() - Math.random()) * 0.01;
                                    d0 = (Math.random() - Math.random()) * 0.01;
                                }
                                if (!(trueEntity instanceof Player)) {
                                    power = (float)((double)power * (1.0 - trueEntity.m_21133_(Attributes.f_22278_)));
                                }
                                if ((double)power > 0.0) {
                                    hitten.f_19812_ = true;
                                    Vec3 vec3 = hitten.m_20184_();
                                    Vec3 vec31 = new Vec3(d1, 0.0, d0).m_82541_().m_82490_((double)power);
                                    hitten.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, hitten.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                                }
                            }
                        }
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL) {
                            float stunTime = (float)((double)(source.getImpact() / anti_stunlock * 0.5f) * (1.0 - trueEntity.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) {
                                hitHurtableEntityPatch.applyStun(anti_stunlock > 0.3f ? StunType.SHORT : StunType.KNOCKDOWN, stunTime);
                                double power = source.getImpact() / anti_stunlock * 0.25f;
                                double d1 = entity.m_20185_() - hitten.m_20185_();
                                double d2 = entity.m_20186_() - 8.0 - hitten.m_20186_();
                                double d0 = entity.m_20189_() - hitten.m_20189_();
                                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                    d1 = (Math.random() - Math.random()) * 0.01;
                                    d0 = (Math.random() - Math.random()) * 0.01;
                                }
                                if (!(trueEntity instanceof Player)) {
                                    power *= 1.0 - trueEntity.m_21133_(Attributes.f_22278_);
                                }
                                if (power > 0.0) {
                                    hitten.f_19812_ = true;
                                    Vec3 vec3 = entity.m_20184_();
                                    Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power);
                                    hitten.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                                }
                                if (trueEntity instanceof Player) {
                                    trueEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, (int)(power * 4.0 * 5.0), true, false, false));
                                }
                            }
                        }
                    }
                }
                entitypatch.getCurrenltyAttackedEntities().add(trueEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrenltyHurtEntities().add(trueEntity);
            }
        }
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (!entitypatch.isLogicalClient()) {
            AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)this);
            float elapsedTime = player.getElapsedTime();
            float prevElapsedTime = player.getPrevElapsedTime();
            EntityState state = this.getState(entitypatch, elapsedTime);
            EntityState prevState = this.getState(entitypatch, prevElapsedTime);
            AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
            if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
                ((Mob)entitypatch.getOriginal()).m_21573_().m_26573_();
                ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
                LivingEntity target = entitypatch.getTarget();
                if (target != null) {
                    entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
                }
            }
            if ((prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) && (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2))) {
                Level worldIn = ((LivingEntity)entitypatch.getOriginal()).m_9236_();
                float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
                float poseTime = state.attacking() ? elapsedTime : phase.contact;
                List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
                ArrayList list2 = new ArrayList(list);
                for (Entity entity : list) {
                    if (entity instanceof Projectile) {
                        list2.remove(entity);
                        continue;
                    }
                    if (entity instanceof LivingEntity) continue;
                    list2.remove(entity);
                }
                if (list2.size() == 0) {
                    Joint joint = (Joint)phase.colliders[0].getFirst();
                    Collider collider = (Collider)phase.colliders[0].getSecond();
                    if (joint != Armatures.BIPED.head && joint != Armatures.BIPED.rootJoint && collider != WOMWeaponColliders.ENDER_LASER && collider != WOMWeaponColliders.ENDER_PISTOLERO && collider != WOMWeaponColliders.ENDER_DASH && collider != WOMWeaponColliders.ENDER_BULLET_WIDE) {
                        OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getAnimator().getPose(-0.5f), joint);
                        transformMatrix.translate(new Vec3f(0.0f, -0.6f, -0.3f));
                        OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_19859_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
                        Vec3 direction = ((LivingEntity)entitypatch.getOriginal()).m_20252_(1.0f);
                        EnderBullet projectile = new EnderBullet((EntityType<? extends EnderBullet>)((EntityType)WOMEntities.ENDERBLAST.get()), worldIn);
                        projectile.m_20049_("wom_enderbullet:" + phase.getHand().toString());
                        projectile.m_5602_(entitypatch.getOriginal());
                        projectile.m_20343_((double)transformMatrix.m30 + ((LivingEntity)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((LivingEntity)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((LivingEntity)entitypatch.getOriginal()).m_20189_());
                        projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 2.5f, 0.0f);
                        projectile.life = entitypatch.getValidItemInHand(phase.getHand()).getEnchantmentLevel(Enchantments.f_44961_);
                        worldIn.m_7967_((Entity)projectile);
                    }
                }
            }
        }
    }

    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = this.getRawPose(time);
        this.modifyPose((DynamicAnimation)this, pose, entitypatch, time, partialTicks);
        float pitch = (float)Math.toDegrees(((LivingEntity)entitypatch.getOriginal()).m_20252_((float)1.0f).f_82480_);
        JointTransform armR = pose.getOrDefaultTransform("Arm_R");
        armR.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        if (this.getPhaseByTime((float)partialTicks).colliders[0].getFirst() != Armatures.BIPED.armR) {
            JointTransform armL = pose.getOrDefaultTransform("Arm_L");
            armL.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch)), OpenMatrix4f::mul);
        }
        JointTransform chest = pose.getOrDefaultTransform("Chest");
        chest.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch * 0.5f)), OpenMatrix4f::mul);
        if (entitypatch instanceof PlayerPatch) {
            JointTransform head = pose.getOrDefaultTransform("Head");
            head.frontResult(JointTransform.getRotation((Quaternionf)QuaternionUtils.XP.rotationDegrees(-pitch * 0.5f)), OpenMatrix4f::mul);
        }
        return pose;
    }

    public boolean isBasicAttackAnimation() {
        return false;
    }

    public float applyAntiStunLock(Entity hitten, float anti_stunlock, EpicFightDamageSource source, AttackAnimation.Phase phase, String tag, String replaceTag) {
        boolean isPhaseFromSameAnimnation = false;
        if (hitten.m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos(hitten.m_20185_(), hitten.m_20186_() - 1.0, hitten.m_20189_())).m_60795_() && source.getStunType() != StunType.FALL) {
            if (tag.split(":").length > 3) {
                if (String.valueOf(this.getId()).equals(tag.split(":")[3].split("-")[0]) && !String.valueOf(phase.contact).equals(tag.split(":")[3].split("-")[1])) {
                    anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() * 1.0f;
                    isPhaseFromSameAnimnation = true;
                } else {
                    anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() * 0.9f;
                    isPhaseFromSameAnimnation = false;
                }
            }
        } else if (tag.split(":").length > 3) {
            if (String.valueOf(this.getId()).equals(tag.split(":")[3].split("-")[0]) && !String.valueOf(phase.contact).equals(tag.split(":")[3].split("-")[1])) {
                anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() * 1.0f;
                isPhaseFromSameAnimnation = true;
            } else {
                anti_stunlock = Float.valueOf(tag.split(":")[1]).floatValue() * 0.8f;
                isPhaseFromSameAnimnation = false;
            }
        }
        hitten.m_20137_(tag);
        int maxSavedAttack = 5;
        if (isPhaseFromSameAnimnation) {
            replaceTag = "anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_;
            maxSavedAttack = 6;
        } else {
            replaceTag = "anti_stunlock:" + anti_stunlock + ":" + hitten.f_19797_ + ":" + this.getId() + "-" + phase.contact;
            maxSavedAttack = 5;
        }
        for (int i = 3; i < tag.split(":").length && i < maxSavedAttack; ++i) {
            replaceTag = ((String)replaceTag).concat(":" + tag.split(":")[i]);
        }
        hitten.m_20049_((String)replaceTag);
        return anti_stunlock;
    }
}

