/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.shader.AnimationShaderInstance;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class EntityAfterImageWeaponParticle
extends CustomModelParticle<AnimatedMesh> {
    private OpenMatrix4f[] poseMatrices;
    private Matrix4f modelMatrix;
    private float alphaO;

    public EntityAfterImageWeaponParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, MeshProvider<AnimatedMesh> particleMesh, OpenMatrix4f[] matrices, Matrix4f modelMatrix) {
        super(level, x, y, z, xd, yd, zd, particleMesh);
        this.poseMatrices = matrices;
        this.modelMatrix = modelMatrix;
        this.f_107225_ = 20;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.alphaO = 0.3f;
        this.f_107230_ = 0.3f;
        if (yd != 0.0) {
            this.scale = (float)yd;
        }
    }

    public void m_5989_() {
        super.m_5989_();
        this.alphaO = this.f_107230_;
        this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_ * 0.8f;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        poseStack.m_252931_(RenderSystem.getModelViewMatrix());
        this.setupPoseStack(poseStack, camera, partialTicks);
        poseStack.m_252931_(this.modelMatrix);
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        float alpha = this.alphaO + (this.f_107230_ - this.alphaO) * partialTicks;
        AnimationShaderInstance animShader = EpicFightRenderTypes.getAnimationShader((ShaderInstance)GameRenderer.m_172832_());
        ((AnimatedMesh)this.particleMeshProvider.get()).drawWithShader(poseStack, animShader, this.m_6355_(partialTicks), this.f_107227_, this.f_107228_, this.f_107229_, alpha, OverlayTexture.f_118083_, null, this.poseMatrices);
    }

    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Entity entity = level.m_6815_((int)Double.doubleToLongBits(xSpeed));
            LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
            if (entitypatch != null && ClientEngine.getInstance().renderEngine.hasRendererFor(entitypatch.getOriginal())) {
                PatchedEntityRenderer renderer = ClientEngine.getInstance().renderEngine.getEntityRenderer(entitypatch.getOriginal());
                Armature armature = entitypatch.getArmature();
                PoseStack poseStack = new PoseStack();
                renderer.mulPoseStack(poseStack, armature, (LivingEntity)entitypatch.getOriginal(), entitypatch, 0.0f);
                OpenMatrix4f[] matrices = renderer.getPoseMatrices(entitypatch, armature, 0.0f, true);
                MeshProvider mesh = ClientEngine.getInstance().renderEngine.getEntityRenderer(entitypatch.getOriginal()).getMeshProvider(entitypatch);
                EntityAfterImageWeaponParticle particle = new EntityAfterImageWeaponParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, (MeshProvider<AnimatedMesh>)mesh, matrices, poseStack.m_85850_().m_252922_());
                return particle;
            }
            return null;
        }
    }
}

