/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.events;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import reascer.wom.animation.attacks.UltimateAttackAnimation;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMEnchantment;
import reascer.wom.particle.WOMParticles;
import reascer.wom.wold.gamerules.WOMGamerules;
import reascer.wom.world.entity.mob.LupusRex;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.DeathHarvestOrb;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.item.EpicFightItems;

@Mod.EventBusSubscriber(modid="wom", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WOMLivingEntityEvents {
    private static final Map<EquipmentSlot, UUID> STAMINAR_ADD = WOMLivingEntityEvents.makeUUIDMap("wom_staminar_add");

    private static Map<EquipmentSlot, UUID> makeUUIDMap(String key) {
        EnumMap<EquipmentSlot, UUID> map = new EnumMap<EquipmentSlot, UUID>(EquipmentSlot.class);
        for (EquipmentSlot type : EquipmentSlot.values()) {
            map.put(type, UUID.nameUUIDFromBytes((key + type.m_20751_()).getBytes()));
        }
        return map;
    }

    @SubscribeEvent
    public static void onSpawnEvent(MobSpawnEvent event) {
        EntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), EntityPatch.class);
        if (entitypatch != null && entitypatch.isInitialized() && !event.getEntity().m_19880_().contains("wom-bow-replaced")) {
            if (event.getEntity() instanceof Skeleton && event.getEntity().m_21205_().m_41720_() == Items.f_42411_ && !event.getEntity().m_19880_().contains("wom-bow-replaced")) {
                ItemStack weapon = Items.f_42411_.m_7968_();
                boolean no_change = true;
                if (Math.abs(new Random().nextInt()) % 100 < event.getEntity().m_9236_().m_46469_().m_46215_(WOMGamerules.SKELETON_MELEE_PERCENTAGE)) {
                    no_change = false;
                    switch (Math.abs(new Random().nextInt()) % 4) {
                        case 0: {
                            weapon = Items.f_42425_.m_7968_();
                            break;
                        }
                        case 1: {
                            weapon = Items.f_42428_.m_7968_();
                            break;
                        }
                        case 2: {
                            weapon = ((Item)EpicFightItems.STONE_SPEAR.get()).m_7968_();
                            break;
                        }
                        case 3: {
                            weapon = ((Item)EpicFightItems.STONE_GREATSWORD.get()).m_7968_();
                        }
                    }
                }
                if (!no_change) {
                    event.getEntity().m_21008_(InteractionHand.MAIN_HAND, weapon);
                }
                event.getEntity().m_20049_("wom-bow-replaced");
            }
            float distance_from_zero = (float)Math.sqrt(event.getEntity().m_20275_(0.0, event.getEntity().m_20186_(), 0.0));
            int block_distance = 1000;
            double health_multiplier = 1.2;
            double damage_multiplier = 1.2;
            if (distance_from_zero / (float)block_distance > 1.0f && !event.getEntity().m_19880_().contains("wom-stronger-mob") && event.getEntity().m_9236_().m_46469_().m_46207_(WOMGamerules.SPAWN_STONGER_MOB_OVER_DISTANCE)) {
                AttributeInstance entity_max_health = event.getEntity().m_21051_(Attributes.f_22276_);
                AttributeModifier boosted_health = new AttributeModifier(UUID.fromString("5a70f02c-7ca0-43c5-a766-2be3d68461a2"), "wom.wom_stronger_health", (double)Math.round(Math.pow(health_multiplier, distance_from_zero / (float)block_distance) - 1.0), AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (entity_max_health != null) {
                    entity_max_health.m_22130_(boosted_health);
                    entity_max_health.m_22125_(boosted_health);
                }
                AttributeInstance entity_attack_damage = event.getEntity().m_21051_(Attributes.f_22281_);
                AttributeModifier boosted_damage = new AttributeModifier(UUID.fromString("5a70f02c-7ca0-43c5-a766-2be3d68461a2"), "wom.wom_stronger_damage", (double)Math.round(Math.pow(damage_multiplier, distance_from_zero / (float)block_distance) - 1.0), AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (entity_attack_damage != null) {
                    entity_attack_damage.m_22130_(boosted_damage);
                    entity_attack_damage.m_22125_(boosted_damage);
                }
                event.getEntity().m_5634_(event.getEntity().m_21233_());
                event.getEntity().m_20049_("wom-stronger-mob");
            }
        }
    }

    @SubscribeEvent
    public static void onkillEvent(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof Player) && !(event.getEntity() instanceof Animal) && !(event.getEntity() instanceof Npc) && event.getEntity().m_9236_().m_46469_().m_46207_(WOMGamerules.STONGER_MOB_DROP_EMERALDS)) {
            int i = 1;
            while ((float)i < event.getEntity().m_21233_() / 20.0f) {
                if (Math.abs(new Random().nextInt()) % 5 == 0) {
                    double d0 = EntityType.f_20461_.m_20678_();
                    double d1 = 1.0 - d0;
                    double d2 = d0 / 2.0;
                    double d3 = Math.floor(event.getEntity().m_20185_()) + new Random().nextDouble() * d1 + d2;
                    double d4 = Math.floor(event.getEntity().m_20186_()) + new Random().nextDouble() * d1;
                    double d5 = Math.floor(event.getEntity().m_20189_()) + new Random().nextDouble() * d1 + d2;
                    ItemStack itemStack = Items.f_42616_.m_7968_();
                    ItemEntity itementity = new ItemEntity(event.getEntity().m_9236_(), d3, d4, d5, itemStack);
                    itementity.m_32060_();
                    itementity.m_20334_(new Random().nextGaussian() * (double)0.05f, new Random().nextGaussian() * (double)0.05f + (double)0.2f, new Random().nextGaussian() * (double)0.05f);
                    event.getEntity().m_9236_().m_7967_((Entity)itementity);
                }
                ++i;
            }
        }
    }

    @SubscribeEvent
    public static void onDropedExpPoint(LivingExperienceDropEvent event) {
        if (!(event.getEntity() instanceof Player) && event.getEntity().m_9236_().m_46469_().m_46207_(WOMGamerules.STONGER_MOB_GIVE_MORE_EXP)) {
            event.setDroppedExperience((int)((float)event.getDroppedExperience() * (event.getEntity().m_21233_() / 20.0f)));
        }
    }

    @SubscribeEvent
    public static void itemAttributeModifiers(ItemAttributeModifierEvent event) {
        float invigoration = 0.0f;
        ItemStack stack = event.getItemStack();
        EquipmentSlot slot = event.getSlotType();
        if (slot == LivingEntity.m_147233_((ItemStack)stack)) {
            invigoration += (float)stack.getEnchantmentLevel((Enchantment)WOMEnchantment.INVIGORATION.get());
        }
        if (invigoration != 0.0f) {
            event.addModifier((Attribute)EpicFightAttributes.MAX_STAMINA.get(), new AttributeModifier(STAMINAR_ADD.get(slot), "invigoration_stamina_add", (double)(invigoration * 2.0f), AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public static void onChangeTarget(LivingChangeTargetEvent event) {
        LupusRex lupus;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LupusRex && (lupus = (LupusRex)livingEntity).isOrderedToCome()) {
            event.setNewTarget(null);
        }
    }

    @SubscribeEvent
    public static void onChatMessage(ServerChatEvent event) {
        String[] splitedMessage = event.getRawText().split(" ");
        if ((splitedMessage.length == 2 || splitedMessage.length == 3) && splitedMessage[0].toLowerCase().equals("lupus")) {
            ServerPlayer player = event.getPlayer();
            AABB box = AABB.m_165882_((Vec3)event.getPlayer().m_20182_(), (double)400.0, (double)400.0, (double)400.0);
            List list = event.getPlayer().m_9236_().m_45976_(LupusRex.class, box);
            for (LupusRex lupus : list) {
                if (!(lupus.m_20270_((Entity)player) < 200.0f)) continue;
                boolean targetedCommand = false;
                boolean validTargetedCommand = false;
                if (splitedMessage.length == 3) {
                    targetedCommand = true;
                }
                if (lupus.m_30614_() && lupus.m_21805_().equals(player.m_20148_())) {
                    if (targetedCommand && lupus.m_8077_()) {
                        if (event.getRawText().toLowerCase().contains(lupus.m_7770_().getString().toLowerCase())) {
                            validTargetedCommand = true;
                        }
                    } else {
                        validTargetedCommand = true;
                    }
                }
                if (!validTargetedCommand) continue;
                switch (splitedMessage[targetedCommand ? 2 : 1].toLowerCase()) {
                    case "vagare": {
                        lupus.m_20088_().m_135381_(LupusRex.COMMAND, (Object)0);
                        break;
                    }
                    case "mane": {
                        lupus.m_20088_().m_135381_(LupusRex.COMMAND, (Object)1);
                        lupus.m_20088_().m_135381_(LupusRex.SIT_LOCATION, (Object)lupus.m_20318_(0.0f).m_252839_());
                        lupus.m_6703_(null);
                        lupus.m_21335_((Entity)((LivingEntity)null));
                        lupus.m_6925_(null);
                        lupus.m_7870_(0);
                        lupus.m_6710_(null);
                        break;
                    }
                    case "veni": {
                        lupus.m_20088_().m_135381_(LupusRex.COMMAND, (Object)2);
                        lupus.m_6703_(null);
                        lupus.m_21335_((Entity)((LivingEntity)null));
                        lupus.m_6925_(null);
                        lupus.m_7870_(0);
                        lupus.m_6710_(null);
                        break;
                    }
                    case "sequi": {
                        lupus.m_20088_().m_135381_(LupusRex.COMMAND, (Object)3);
                        break;
                    }
                    default: {
                        lupus.m_20088_().m_135381_(LupusRex.COMMAND, (Object)4);
                        lupus.m_20088_().m_135381_(LupusRex.SIT_LOCATION, (Object)new Vector3f());
                    }
                }
                if (!targetedCommand) continue;
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onUpdateEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity e = event.getEntity();
        if (e instanceof Player) {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)e, PlayerPatch.class);
            for (String tag : event.getEntity().m_19880_()) {
                if (!tag.contains("wom_ultimate_Invulnerable")) continue;
                if (playerPatch.isLogicalClient() || playerPatch == null || playerPatch.getServerAnimator().animationPlayer.getAnimation() instanceof UltimateAttackAnimation) break;
                e.m_20331_(false);
                event.getEntity().m_19880_().remove(tag);
                break;
            }
            for (String tag : event.getEntity().m_19880_()) {
                if (!tag.contains("wom_health_fix:")) continue;
                if (!(Float.valueOf(tag.substring(15)).floatValue() <= event.getEntity().m_21233_())) break;
                event.getEntity().m_21153_(Float.valueOf(tag.substring(15)).floatValue());
                event.getEntity().m_19880_().remove(tag);
                break;
            }
            if (event.getEntity().m_21223_() > event.getEntity().m_21233_()) {
                event.getEntity().m_21153_(event.getEntity().m_21233_());
            }
        }
        for (String tag : event.getEntity().m_19880_()) {
            LivingEntityPatch livingEntityPatch;
            if (!tag.contains("anti_stunlock:") || (livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)e, LivingEntityPatch.class)) == null) continue;
            if ((float)e.f_19797_ - Float.valueOf(tag.split(":")[2]).floatValue() > 20.0f && !livingEntityPatch.isStunned() || Float.valueOf(tag.split(":")[2]).floatValue() > (float)(e.f_19797_ + 20)) {
                livingEntityPatch.setStunShield(0.0f);
                livingEntityPatch.setMaxStunShield(0.0f);
                break;
            }
            if (livingEntityPatch == null) continue;
            livingEntityPatch.setStunShield(Float.valueOf(tag.split(":")[1]).floatValue() * 100.0f);
            livingEntityPatch.setMaxStunShield(100.0f);
        }
        for (String tag : event.getEntity().m_19880_()) {
            boolean gesshoku;
            if (!tag.contains("timed_katana_slashes:") || e == null || !e.m_6084_()) continue;
            boolean bl = gesshoku = Integer.valueOf(tag.split(":")[7]) == 1 && Integer.valueOf(tag.split(":")[2]) == 0 && Integer.valueOf(tag.split(":")[4]) == 0;
            if (gesshoku) {
                int n = (int)((float)Integer.valueOf(tag.split(":")[1]).intValue() * 0.2f);
                double r = (double)Integer.valueOf(tag.split(":")[1]).intValue() * 0.04;
                double t = 0.01;
                for (int i = 0; i < n; ++i) {
                    double theta = Math.PI * 2 * new Random().nextDouble();
                    double phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                    double x = r * Math.cos(phi) * Math.cos(theta);
                    double y = r * Math.cos(phi) * Math.sin(theta);
                    double z = r * Math.sin(phi);
                    Vec3f direction = new Vec3f((float)x, (float)y, (float)z);
                    OpenMatrix4f rotation = new OpenMatrix4f().rotate((float)Math.toRadians(90.0), new Vec3f(1.0f, 0.0f, 0.0f));
                    OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                    ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, event.getEntity().m_20185_() + (double)direction.x, event.getEntity().m_20186_() + (double)(event.getEntity().m_20206_() / 2.0f), event.getEntity().m_20189_() + (double)direction.z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (Integer.valueOf(tag.split(":")[1]) > 0) {
                String replacetag = new String(tag);
                e.m_20137_(tag);
                e.m_20049_("timed_katana_slashes:" + (Integer.valueOf(replacetag.split(":")[1]) - 1) + ":" + Integer.valueOf(replacetag.split(":")[2]) + ":" + Integer.valueOf(replacetag.split(":")[3]) + ":" + Integer.valueOf(replacetag.split(":")[4]) + ":" + Float.valueOf(replacetag.split(":")[5]) + ":" + Integer.valueOf(replacetag.split(":")[6]) + ":" + Integer.valueOf(replacetag.split(":")[7]));
                break;
            }
            if (Integer.valueOf(tag.split(":")[2]) > 0) {
                String replacetag = new String(tag);
                e.m_20137_(tag);
                e.m_20049_("timed_katana_slashes:" + Integer.valueOf(replacetag.split(":")[1]) + ":" + (Integer.valueOf(replacetag.split(":")[2]) - 1) + ":" + Integer.valueOf(replacetag.split(":")[3]) + ":" + Integer.valueOf(replacetag.split(":")[4]) + ":" + Float.valueOf(replacetag.split(":")[5]) + ":" + Integer.valueOf(replacetag.split(":")[6]) + ":" + Integer.valueOf(replacetag.split(":")[7]));
                break;
            }
            if (Integer.valueOf(tag.split(":")[3]) > 0) {
                String replacetag = new String(tag);
                e.m_20137_(tag);
                ServerPlayerPatch player = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)e.m_9236_().m_6815_(Integer.valueOf(replacetag.split(":")[6]).intValue()), ServerPlayerPatch.class);
                if (player == null) break;
                EpicFightDamageSource epicFightDamageSource = player.getDamageSource(WOMAnimations.KATANA_SAKURA_TIMED_SLASH, InteractionHand.MAIN_HAND);
                epicFightDamageSource.setImpact(2.0f);
                epicFightDamageSource.setArmorNegation(0.3f);
                epicFightDamageSource.setStunType(gesshoku ? StunType.FALL : StunType.HOLD);
                e.f_19802_ = 0;
                float attackDamage = Float.valueOf(replacetag.split(":")[5]).floatValue();
                if (e.m_6469_((DamageSource)epicFightDamageSource, attackDamage)) {
                    ((ServerLevel)event.getEntity().m_9236_()).m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 0.75, event.getEntity().m_20189_(), gesshoku ? (SoundEvent)EpicFightSounds.WHOOSH_SHARP.get() : (SoundEvent)EpicFightSounds.BLADE_HIT.get(), event.getEntity().m_5720_(), 1.0f, gesshoku ? 0.7f : 1.0f);
                    if (gesshoku) {
                        ((ServerLevel)event.getEntity().m_9236_()).m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 0.75, event.getEntity().m_20189_(), (SoundEvent)EpicFightSounds.WHOOSH_SHARP.get(), event.getEntity().m_5720_(), 1.0f, 0.9f);
                        ((ServerLevel)event.getEntity().m_9236_()).m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 0.75, event.getEntity().m_20189_(), SoundEvents.f_12556_, event.getEntity().m_5720_(), 0.3f, 2.0f);
                    }
                    ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)(gesshoku ? WOMParticles.TELEPORT_REVERSE : WOMParticles.KATANA_SHEATHED_HIT).get()), event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)event.getEntity().m_20206_() * 0.6, event.getEntity().m_20189_(), 1, gesshoku ? 0.0 : (double)(event.getEntity().m_20205_() / 5.0f), gesshoku ? 0.0 : (double)(event.getEntity().m_20206_() / 10.0f), gesshoku ? 0.0 : (double)(event.getEntity().m_20205_() / 5.0f), 0.0);
                    LivingEntityPatch targetpatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)e, LivingEntityPatch.class);
                    if (targetpatch != null && targetpatch.getArmature() instanceof HumanoidArmature && gesshoku) {
                        targetpatch.playAnimationSynchronized(WOMAnimations.BIPED_BLACKOUT, 0.15f);
                    }
                }
                e.m_20049_("timed_katana_slashes:" + Integer.valueOf(replacetag.split(":")[1]) + ":" + Integer.valueOf(replacetag.split(":")[4]) + ":" + (Integer.valueOf(replacetag.split(":")[3]) - 1) + ":" + Integer.valueOf(replacetag.split(":")[4]) + ":" + Float.valueOf(replacetag.split(":")[5]) + ":" + Integer.valueOf(replacetag.split(":")[6]) + ":" + Integer.valueOf(replacetag.split(":")[7]));
                if (!event.getEntity().m_21224_() || player.getSkill(EpicFightSkills.DEATH_HARVEST) == null) break;
                if (gesshoku) {
                    for (int i = 0; i < 3; ++i) {
                        DeathHarvestOrb harvestOrb = new DeathHarvestOrb((Player)player.getOriginal(), event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)event.getEntity().m_20206_() * 0.5, event.getEntity().m_20189_(), (int)(Float.valueOf(replacetag.split(":")[5]).floatValue() / 9.0f));
                        ((ServerPlayer)player.getOriginal()).m_9236_().m_7967_((Entity)harvestOrb);
                    }
                } else {
                    int i = 0;
                    while ((float)i < (float)Integer.valueOf(replacetag.split(":")[7]).intValue() / 5.0f) {
                        DeathHarvestOrb harvestOrb = new DeathHarvestOrb((Player)player.getOriginal(), event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)event.getEntity().m_20206_() * 0.5, event.getEntity().m_20189_(), (int)(Float.valueOf(replacetag.split(":")[5]).floatValue() * 2.0f));
                        ((ServerPlayer)player.getOriginal()).m_9236_().m_7967_((Entity)harvestOrb);
                        ++i;
                    }
                }
                break;
            }
            e.m_20137_(tag);
            break;
        }
        for (String tag : event.getEntity().m_19880_()) {
            if (!tag.contains("lunar_eclipse:")) continue;
            if (!event.getEntity().m_21023_(MobEffects.f_19610_)) break;
            int blindness_amp = event.getEntity().m_21124_(MobEffects.f_19610_).m_19564_();
            if (event.getEntity().m_21124_(MobEffects.f_19610_).m_19557_() != 1 && !event.getEntity().m_21224_()) break;
            Entity player = event.getEntity().m_9236_().m_6815_(Integer.valueOf(tag.split(":")[1]).intValue());
            PlayerPatch playerpatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerpatch;
            if (serverPlayerPatch == null) {
                event.getEntity().m_19880_().remove(tag);
                break;
            }
            float lunar_power = Float.valueOf(tag.split(":")[2]).floatValue() + Float.valueOf(tag.split(":")[2]).floatValue() * ((float)blindness_amp / 300.0f);
            EpicFightDamageSource epicFightDamageSource = serverPlayerPatch.getDamageSource(WOMAnimations.MOONLESS_LUNAR_ECLIPSE, InteractionHand.MAIN_HAND);
            epicFightDamageSource.setImpact(4.0f);
            epicFightDamageSource.setStunType(StunType.HOLD);
            if (event.getEntity().m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                epicFightDamageSource.setStunType(StunType.NONE);
            }
            epicFightDamageSource.addRuntimeTag(EpicFightDamageType.WEAPON_INNATE);
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 0.25 * (double)((int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f)))), event.getEntity().m_20189_(), 5 * (int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f))), 0.1, 0.5 * (double)((int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f)))), 0.1, 0.0);
            ((ServerLevel)player.m_9236_()).m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 0.75, event.getEntity().m_20189_(), SoundEvents.f_11738_, event.getEntity().m_5720_(), 4.0f, 2.0f);
            int glowing_amp = 0;
            if (event.getEntity().m_21023_(MobEffects.f_19619_)) {
                glowing_amp = event.getEntity().m_21124_(MobEffects.f_19619_).m_19564_();
                event.getEntity().m_21195_(MobEffects.f_19619_);
            }
            AABB box = AABB.m_165882_((Vec3)event.getEntity().m_20182_(), (double)((20 + Math.min(120, glowing_amp)) * 2), (double)((20 + Math.min(120, glowing_amp)) * 2), (double)((20 + Math.min(120, glowing_amp)) * 2));
            List list = event.getEntity().m_9236_().m_45933_(player, box);
            LivingEntity livingEntityLowestHP = null;
            int targetType = 0;
            float distance_to_stored_target = -1.0f;
            for (Entity entity : list) {
                if (entity instanceof ExperienceOrb || entity instanceof ItemEntity) {
                    entity.m_6021_(player.m_20208_(0.5), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20262_(0.5));
                }
                if (!(entity instanceof LivingEntity) || !(event.getEntity().m_20270_(entity) < (float)(20 + Math.min(120, glowing_amp)))) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.m_21023_(MobEffects.f_19610_)) {
                    int Aoe_blindness_amp = livingEntity.m_21124_(MobEffects.f_19610_).m_19564_();
                    int Aoe_blindness_dur = livingEntity.m_21124_(MobEffects.f_19610_).m_19557_();
                    if (Aoe_blindness_dur < 140) {
                        livingEntity.m_21195_(MobEffects.f_19610_);
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 140, Aoe_blindness_amp, true, false, false));
                    }
                }
                if (livingEntity.m_21023_(MobEffects.f_19619_)) {
                    int Aoe_glowing_amp = livingEntity.m_21124_(MobEffects.f_19619_).m_19564_();
                    int Aoe_glowing_dur = livingEntity.m_21124_(MobEffects.f_19619_).m_19557_();
                    if (Aoe_glowing_dur < 140) {
                        livingEntity.m_21195_(MobEffects.f_19619_);
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 140, Aoe_glowing_amp, true, false, false));
                    }
                }
                if (livingEntity.equals((Object)event.getEntity())) {
                    if (!livingEntity.m_6084_() || !e.m_6469_((DamageSource)epicFightDamageSource, lunar_power)) continue;
                    ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 5 * (1 + (int)lunar_power / 10), 0.5 * (double)(1 + (int)lunar_power / 20), 0.5 * (double)(1 + (int)lunar_power / 20), 0.5 * (double)(1 + (int)lunar_power / 20), 0.0);
                    continue;
                }
                if (livingEntity instanceof Animal || !livingEntity.m_6084_() || livingEntity instanceof Npc) continue;
                if (livingEntityLowestHP == null) {
                    livingEntityLowestHP = livingEntity;
                    distance_to_stored_target = livingEntity.m_20270_((Entity)event.getEntity());
                    continue;
                }
                float distance_to_current_target = livingEntity.m_20270_((Entity)event.getEntity());
                if (livingEntity.m_21023_(MobEffects.f_19619_) || livingEntity.m_21023_(MobEffects.f_19610_)) {
                    if (targetType == 3) {
                        if (distance_to_current_target < distance_to_stored_target) {
                            livingEntityLowestHP = livingEntity;
                            distance_to_stored_target = distance_to_current_target;
                        }
                    } else {
                        livingEntityLowestHP = livingEntity;
                        distance_to_stored_target = distance_to_current_target;
                        targetType = 3;
                    }
                }
                if (targetType >= 3 || !(livingEntity.m_21223_() < livingEntityLowestHP.m_21223_())) continue;
                livingEntityLowestHP = livingEntity;
                distance_to_stored_target = distance_to_current_target;
                targetType = 2;
            }
            if (event.getEntity().m_21224_() && livingEntityLowestHP != null) {
                ((ServerLevel)player.m_9236_()).m_6263_(null, player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_(), SoundEvents.f_11686_, event.getEntity().m_5720_(), 0.5f, 2.0f);
                String replacetag = new String(tag);
                livingEntityLowestHP.m_20049_(replacetag.split(":")[0] + ":" + replacetag.split(":")[1] + ":" + lunar_power * 0.95f);
                int lowestHP_blindness_amp = 0;
                int lowestHP_glowing_amp = 0;
                if (livingEntityLowestHP.m_21023_(MobEffects.f_19610_)) {
                    lowestHP_blindness_amp = livingEntityLowestHP.m_21124_(MobEffects.f_19610_).m_19564_();
                    livingEntityLowestHP.m_21195_(MobEffects.f_19610_);
                }
                if (livingEntityLowestHP.m_21023_(MobEffects.f_19619_)) {
                    lowestHP_glowing_amp = livingEntityLowestHP.m_21124_(MobEffects.f_19619_).m_19564_();
                    livingEntityLowestHP.m_21195_(MobEffects.f_19619_);
                    livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10, glowing_amp + lowestHP_glowing_amp, true, false, false));
                } else if (glowing_amp > 0) {
                    livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10, glowing_amp, true, false, false));
                }
                livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 3, lowestHP_blindness_amp, true, false, false));
                if (playerpatch.getSkill(EpicFightSkills.DEATH_HARVEST) != null) {
                    DeathHarvestOrb harvestOrb = new DeathHarvestOrb((Player)playerpatch.getOriginal(), event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)event.getEntity().m_20206_() * 0.5, event.getEntity().m_20189_(), (int)lunar_power);
                    ((Player)playerpatch.getOriginal()).m_9236_().m_7967_((Entity)harvestOrb);
                }
            }
            event.getEntity().m_21195_(MobEffects.f_19610_);
            event.getEntity().m_19880_().remove(tag);
            break;
        }
        for (String tag : event.getEntity().m_19880_()) {
            if (!tag.contains("solar_ignited:")) continue;
            if (event.getEntity().m_6060_()) {
                if (new Random().nextBoolean()) {
                    ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 1.0, event.getEntity().m_20189_(), 1, 0.5, 0.8, 0.5, 0.2);
                }
                if (Integer.valueOf(tag.split(":")[1]) != 2) continue;
                ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123745_, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 1.0, event.getEntity().m_20189_(), 1, 0.5, 0.8, 0.5, 0.01);
                continue;
            }
            event.getEntity().m_19880_().remove(tag);
            break;
        }
        for (String tag : event.getEntity().m_19880_()) {
            if (!tag.contains("WoM_blackout")) continue;
            LivingEntityPatch target = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
            if (target != null && target.getArmature() instanceof HumanoidArmature) {
                target.playAnimationSynchronized(WOMAnimations.BIPED_BLACKOUT, 0.0f);
            }
            event.getEntity().m_19880_().remove(tag);
            break;
        }
    }

    @SubscribeEvent
    public static void onleaveEvent(EntityLeaveLevelEvent event) {
        Entity e = event.getEntity();
        if (e instanceof Player) {
            Player p = (Player)e;
            for (String tag : p.m_19880_()) {
                if (!tag.contains("wom_health_fix:")) continue;
                p.m_19880_().remove(tag);
                break;
            }
            if (p.m_6084_()) {
                p.m_20049_("wom_health_fix:" + p.m_21223_());
            }
        }
    }

    @SubscribeEvent
    public static void onDisconectEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Player e = event.getEntity();
        if (e instanceof Player) {
            Player p = e;
            for (String tag : p.m_19880_()) {
                if (!tag.contains("wom_health_fix:")) continue;
                p.m_19880_().remove(tag);
                break;
            }
            if (p.m_6084_()) {
                p.m_20049_("wom_health_fix:" + p.m_21223_());
            }
        }
    }
}

