/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class EnderObscurisSkill
extends DodgeSkill {
    private static final UUID EVENT_UUID = UUID.fromString("38cb04e1-9751-445f-82bd-fb61426a58c7");

    public EnderObscurisSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_HURT, EVENT_UUID, event -> container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get(), (Object)event.getTarget().m_19879_(), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_HURT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executer.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = Minecraft.m_91087_().f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        int animation = vertic == 0 ? (horizon == 0 ? 4 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        executer.getSkill((Skill)this).activate();
        int i = args.readInt();
        float yaw = args.readFloat();
        boolean tag = false;
        LivingEntity target = (LivingEntity)((ServerPlayer)executer.getOriginal()).m_9236_().m_6815_(((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get())).intValue());
        if (target != null) {
            if (target.m_20270_(executer.getOriginal()) < 30.0f) {
                tag = true;
            }
            if (!tag) {
                i = 1;
            }
        }
        executer.playAnimationSynchronized(this.animations[i].get(), 0.0f);
        executer.setModelYRot(yaw, true);
    }

    public Skill getPriorSkill() {
        return WOMSkills.ENDERSTEP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        LivingEntity target = (LivingEntity)((Player)container.getExecuter().getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get())).intValue());
        boolean tag = false;
        if (target != null && target.m_20270_(container.getExecuter().getOriginal()) < 30.0f) {
            tag = true;
        }
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getSkillTexture());
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        Entity target;
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient() && container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get()) != null && (target = ((Player)container.getExecuter().getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get())).intValue())) != null && target instanceof LivingEntity && ((LivingEntity)target).m_21224_()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get(), (Object)-1, (ServerPlayer)container.getExecuter().getOriginal());
        }
    }
}

