/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RavangerForceSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("0c413ee2-663b-4d30-8e27-e3217fb45aa1");
    protected final StaticAnimationProvider animations;

    public static Builder createChargeBuilder() {
        return new Builder().setCategory((SkillCategory)SkillCategories.DODGE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    public RavangerForceSkill(Builder builder) {
        super((Skill.Builder)builder);
        this.animations = builder.animations;
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SUPER_ARMOR.get())).booleanValue()) {
                event.setAmount(event.getAmount() * 0.6f);
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.executeOnServer(executer, args);
        executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SUPER_ARMOR.get(), (Object)true, (ServerPlayer)executer.getOriginal());
        executer.playAnimationSynchronized(WOMAnimations.BULL_CHARGE, 0.0f);
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.ROLL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgs(List<Object> list) {
        list.add(ItemStack.f_41584_.format(this.consumption));
        return list;
    }

    public static class Builder
    extends Skill.Builder<RavangerForceSkill> {
        protected StaticAnimationProvider animations;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setAnimations(StaticAnimationProvider animations) {
            this.animations = animations;
            return this;
        }
    }
}

