/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMWeaponColliders;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.GesetzCapability;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class PerfectBulwarkSkill
extends GuardSkill {
    private static final UUID EVENT_UUID = UUID.fromString("8665b153-4bc3-4480-adb4-96bdd66e35e6");

    public static GuardSkill.Builder createCounterAttackBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> itemCap.getStyle((LivingEntityPatch)playerpatch) == CapabilityItem.Styles.ONE_HAND ? Animations.SWEEPING_EDGE : Animations.SWORD_DUAL_AUTO3).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> Animations.LONGSWORD_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> Animations.TACHI_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR, (itemCap, playerpatch) -> Animations.SPEAR_DASH).addAdvancedGuardMotion((WeaponCategory)WOMWeaponCategories.AGONY, (itemCap, playerpatch) -> WOMAnimations.AGONY_CLAWSTRIKE).addAdvancedGuardMotion((WeaponCategory)WOMWeaponCategories.RUINE, (itemCap, playerpatch) -> WOMAnimations.RUINE_COUNTER).addAdvancedGuardMotion((WeaponCategory)WOMWeaponCategories.STAFF, (itemCap, playerpatch) -> WOMAnimations.STAFF_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.UCHIGATANA, (itemCap, playerpatch) -> WOMAnimations.KATANA_SHEATHED_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.GREATSWORD, (itemCap, playerpatch) -> Animations.GREATSWORD_DASH).addGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SHIELD, (itemCap, playerpatch) -> playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability ? WOMAnimations.HERRSCHER_GUARD_HIT : Animations.BIPED_HIT_SHIELD).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SHIELD, (itemCap, playerpatch) -> playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability ? WOMAnimations.HERRSCHER_TRANE : Animations.SWEEPING_EDGE);
    }

    public PerfectBulwarkSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    public void setPenalizer(float penalizer) {
        this.penalizer = penalizer;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, GuardSkill.EVENT_UUID, 1);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            } else if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PARRYING.get())).booleanValue() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) >= 5) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) * 20), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
                StaticAnimation animation = switch (new Random().nextInt() % 3) {
                    case 0 -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                    case 1 -> Animations.SWORD_GUARD_ACTIVE_HIT2;
                    case 2 -> Animations.SWORD_GUARD_ACTIVE_HIT3;
                    default -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                };
                if (itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.TWO_HAND) {
                    animation = new Random().nextBoolean() ? Animations.LONGSWORD_GUARD_ACTIVE_HIT1 : Animations.LONGSWORD_GUARD_ACTIVE_HIT2;
                }
                float convert = 0.15f;
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.AGONY) {
                    animation = WOMAnimations.AGONY_GUARD_HIT_1;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.RUINE) {
                    animation = Animations.LONGSWORD_GUARD_HIT;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.KATANA) {
                    animation = WOMAnimations.KATANA_GUARD_HIT;
                    convert = -0.05f;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.HERSCHER && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
                    animation = WOMAnimations.HERRSCHER_GUARD_PARRY;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                    animation = WOMAnimations.MOONLESS_GUARD_HIT_1;
                }
                if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                    animation = WOMAnimations.SOLAR_GUARD_PARRY;
                }
                ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, 3.0f, true);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 0.5f);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 0.75, ((Player)container.getExecuter().getOriginal()).m_20189_(), 60, 0.0, 0.0, 0.0, 0.5);
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
                AABB box = AABB.m_165882_((Vec3)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_(), (double)20.0, (double)20.0, (double)20.0);
                List list = ((Player)container.getExecuter().getOriginal()).m_9236_().m_45933_(container.getExecuter().getOriginal(), box);
                for (Entity entity : list) {
                    if (!(entity.m_20270_(container.getExecuter().getOriginal()) < 10.0f)) continue;
                    double power = 1.0;
                    double d1 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7096_() - entity.m_20185_();
                    double d2 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7098_() - 1.0 - entity.m_20186_();
                    double d0 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7094_() - entity.m_20189_();
                    while (d1 * d1 + d0 * d0 < 1.0E-4) {
                        d1 = (Math.random() - Math.random()) * 0.01;
                        d0 = (Math.random() - Math.random()) * 0.01;
                    }
                    if (!(entity instanceof LivingEntity) || entity instanceof OwnableEntity) continue;
                    entity.f_19812_ = true;
                    Vec3 vec3 = entity.m_20184_();
                    Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power *= 1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_));
                    EpicFightDamageSource damage = container.getExecuter().getDamageSource(animation, InteractionHand.MAIN_HAND);
                    damage.setStunType(StunType.LONG);
                    damage.setImpact(3.0f);
                    LivingEntity target = (LivingEntity)entity;
                    target.m_6469_((DamageSource)damage, (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) * 2));
                    entity.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7655_());
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6117_() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) == 0 && event.getResult() != AttackResult.ResultType.MISSED) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)(1 + (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get())), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) >= 5) {
                    ((ServerLevel)((Player)container.getExecuter().getOriginal()).m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.75f, 0.65f), 1.0f), ((Player)container.getExecuter().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecuter().getOriginal()).m_20189_() - 0.2, 30, 0.6, 0.0, 0.6, 0.05);
                }
                float impact = 0.5f;
                float knockback = 0.25f;
                Object patt13162$temp = event.getDamageSource();
                if (patt13162$temp instanceof EpicFightDamageSource) {
                    EpicFightDamageSource epicfightDamageSource = (EpicFightDamageSource)patt13162$temp;
                    if (epicfightDamageSource.m_269533_(EpicFightDamageType.GUARD_PUNCTURE)) {
                        return;
                    }
                    impact = ((EpicFightDamageSource)event.getDamageSource()).getImpact();
                    knockback += Math.min(impact * 0.1f, 1.0f);
                }
                this.guard(container, itemCapability, (HurtEvent.Pre)event, knockback, impact, true);
            }
        }, 0);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 0);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID);
        super.onRemoved(container);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource = (DamageSource)event.getDamageSource();
        if (this.isBlockableSource(damageSource, advanced) && !damageSource.m_276093_(DamageTypes.f_268515_) && !damageSource.m_276093_(DamageTypes.f_268530_) && !damageSource.m_276093_(DamageTypes.f_268493_)) {
            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 0.9f + 0.15f * (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get())).intValue());
            ServerPlayer serveerPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)serveerPlayer.m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serveerPlayer, damageSource.m_7640_());
            if (damageSource.m_7640_() instanceof LivingEntity) {
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)((LivingEntity)damageSource.m_7640_())) * 0.1f;
            }
            float penalty = ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue() + this.getPenalizer(itemCapability);
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
            boolean enoughStamina = ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, penalty * impact);
            container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), (Object)Float.valueOf(penalty), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            GuardSkill.BlockType blockType = enoughStamina ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK;
            StaticAnimation animation = this.getGuardMotion(event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent(event.getPlayerPatch(), event, advanced);
        }
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.m_276093_(DamageTypes.f_268482_) && advanced || damageSource.m_276093_(DamageTypes.f_268684_) && advanced || damageSource.m_269533_(DamageTypeTags.f_268415_) && advanced || damageSource.m_269533_(DamageTypeTags.f_268524_) && advanced || damageSource.m_276093_(DamageTypes.f_268428_) && advanced || damageSource.m_276093_(DamageTypes.f_268448_) && advanced || damageSource.m_276093_(DamageTypes.f_268679_) && advanced || damageSource.m_276093_(DamageTypes.f_268656_) && advanced || damageSource.m_276093_(DamageTypes.f_268714_) && advanced || damageSource.m_276093_(DamageTypes.f_268641_) && advanced || damageSource.m_276093_(DamageTypes.f_268556_) && advanced || super.isBlockableSource(damageSource, false);
    }

    @Nullable
    protected StaticAnimation getGuardMotion(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        if (blockType == GuardSkill.BlockType.GUARD) {
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.AGONY) {
                return new Random().nextBoolean() ? WOMAnimations.AGONY_GUARD_HIT_1 : WOMAnimations.AGONY_GUARD_HIT_2;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.KATANA) {
                return WOMAnimations.KATANA_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.HERSCHER && playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
                return WOMAnimations.HERRSCHER_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                return WOMAnimations.SOLAR_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMWeaponColliders.MOONLESS) {
                switch (new Random().nextInt() % 3) {
                    case 0: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_1;
                    }
                    case 1: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_2;
                    }
                    case 2: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_3;
                    }
                }
                return WOMAnimations.MOONLESS_GUARD_HIT_1;
            }
        }
        return super.getGuardMotion(playerpatch, itemCapability, blockType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) > 0 || (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getSkillTexture());
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
        }
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String string = "";
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            string = String.valueOf((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) / 20 + 1);
        } else {
            string = String.valueOf(container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()));
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) == 0) {
                string = "";
            }
        }
        guiGraphics.drawString(gui.font, string, x + 9.0f, y + 7.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.GUARD;
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.clear();
        list.add(String.format("%s, %s, %s, %s, %s, %s, %s, %s", new Object[]{CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI, CapabilityItem.WeaponCategories.SPEAR, WOMWeaponCategories.AGONY, WOMWeaponCategories.RUINE, WOMWeaponCategories.STAFF}).toLowerCase());
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            container.getDataManager().setData((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1));
        }
    }
}

