/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ShulkerCloakSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("0344a9f3-22c9-4edf-9279-e00500205686");

    public ShulkerCloakSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((EpicFightDamageSource)event.getDamageSource()).m_7639_() != ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) > 0) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) - 1), (ServerPlayer)container.getExecuter().getOriginal());
                    event.setAmount(event.getAmount() * 0.4f);
                    int n = 40;
                    double r = 1.0;
                    for (int i = 0; i < n; ++i) {
                        double theta = Math.PI * 2 * new Random().nextDouble();
                        double phi = Math.acos(2.0 * new Random().nextDouble() - 1.0);
                        double x = r * Math.sin(phi) * Math.cos(theta);
                        double y = r * Math.sin(phi) * Math.sin(theta);
                        double z = r * Math.cos(phi);
                        ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, ((Player)container.getExecuter().getOriginal()).m_20185_() + x, ((Player)container.getExecuter().getOriginal()).m_20186_() + y + 1.0, ((Player)container.getExecuter().getOriginal()).m_20189_() + z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_5594_(null, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20183_(), SoundEvents.f_12415_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 2.0f, 0.5f);
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)0, (ServerPlayer)container.getExecuter().getOriginal());
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)0, (ServerPlayer)container.getExecuter().getOriginal());
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        int charge = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get());
        RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - (float)charge / 5.0f), (float)1.0f, (float)1.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) < 5) {
            String damage = String.valueOf(5 - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) / 20);
            guiGraphics.drawString(gui.font, damage, x + 12.0f - (float)(damage.length() * 2), y + 8.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        if (container.getExecuter().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) < 100 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) < 5) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) + 1), (LocalPlayer)container.getExecuter().getOriginal());
            } else {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) < 5) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) + 1), (LocalPlayer)container.getExecuter().getOriginal());
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)0, (LocalPlayer)container.getExecuter().getOriginal());
            }
        }
    }
}

