/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.particle.WOMParticles;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SoulProtectionSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("ad93bcb3-1e4a-4041-ae26-d48a1a583def");

    public SoulProtectionSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((EpicFightDamageSource)event.getDamageSource()).m_7639_() != ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) > 2) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) - 3), (ServerPlayer)container.getExecuter().getOriginal());
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)0, (ServerPlayer)container.getExecuter().getOriginal());
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)20, (ServerPlayer)container.getExecuter().getOriginal());
                event.setAmount(event.getAmount() * (0.8f - (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get())).intValue() * 0.01f));
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String damage = String.valueOf(20 + (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()));
        guiGraphics.drawString(gui.font, damage + "%", x + 4.0f, y + 7.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) - 1), (ServerPlayer)container.getExecuter().getOriginal());
            } else {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) < 30) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) + 1), (ServerPlayer)container.getExecuter().getOriginal());
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)20, (ServerPlayer)container.getExecuter().getOriginal());
            }
        } else if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) == 0) {
            PlayerPatch entitypatch = container.getExecuter();
            int n = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGE.get()) / 3;
            double r = 0.6;
            double t = 0.01;
            float yAngle = entitypatch.getCameraYRot();
            float xAngle = 90.0f;
            Vec3f position = new Vec3f(0.0f, 0.4f, 0.0f);
            for (int i = 0; i < n; ++i) {
                double theta = Math.PI * 2 * (double)(((float)i + 1.0f) / (float)n);
                double phi = (double)(((float)i + 1.0f) / (float)n - 0.5f) * Math.PI * t / r;
                double x = r * Math.cos(phi) * Math.cos(theta);
                double y = r * Math.cos(phi) * Math.sin(theta);
                double z = r * Math.sin(phi);
                Vec3f direction = new Vec3f((float)x, (float)y, (float)z);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(yAngle)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(xAngle), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)WOMParticles.SOUL_PROTECTION.get(), (double)(direction.x + position.x), (double)(direction.y + position.y), (double)(direction.z + position.z), (double)((Player)entitypatch.getOriginal()).m_19879_(), (double)(direction.y + 0.1f), 0.0);
            }
        }
    }
}

