/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.identity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BackAndForthSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("05e61b67-4531-4127-b973-9f572acede5c");

    public BackAndForthSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get(), (Object)event.getTarget().m_19879_(), (ServerPlayer)container.getExecuter().getOriginal());
            if (event.getDamageSource().getAnimation().equals((Object)WOMAnimations.STRONG_PUNCH)) {
                Boolean no_blackout_tag = true;
                for (String tag : event.getTarget().m_19880_()) {
                    if (!tag.contains("WoM_blackout")) continue;
                    no_blackout_tag = false;
                    break;
                }
                if (no_blackout_tag.booleanValue()) {
                    event.getTarget().m_20049_("WoM_blackout");
                    event.getTarget().m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 100, 0, true, false, false));
                }
                event.getTarget().m_5496_((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), -0.2f, 0.2f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            if (((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue() >= 20.0f && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20142_()) {
                ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
                executer.playAnimationSynchronized(WOMAnimations.STRONG_PUNCH, 0.0f);
                event.setCanceled(true);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)container.getExecuter().getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get(), (Object)0, (ServerPlayer)container.getExecuter().getOriginal());
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get()) != 0 || ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue() >= 20.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        if (((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue() < 20.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)0.2f, (float)0.0f, (float)1.0f);
        }
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String string = "";
        if (((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue() < 20.0f) {
            string = String.format("%.1f", container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get()));
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.font, string, x + 10.0f - (float)(string.length() * 2), y + 10.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient() && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get()) != 0) {
            Entity targetEntity = ((Player)container.getExecuter().getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get())).intValue());
            if (targetEntity != null) {
                if (((Player)container.getExecuter().getOriginal()).m_20270_(targetEntity) > ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get())).floatValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get(), (Object)Float.valueOf(((Player)container.getExecuter().getOriginal()).m_20270_(targetEntity)), (ServerPlayer)container.getExecuter().getOriginal());
                }
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_ID.get(), (Object)0, (ServerPlayer)container.getExecuter().getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TARGET_DISTANCE.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)container.getExecuter().getOriginal());
            }
        }
    }
}

