/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.WOMSounds;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.api.animation.AttackAnimationProvider;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.ConditionalWeaponInnateSkill;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class EnderFusionSkill
extends ConditionalWeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("b9023f5e-ee42-11ec-8ea0-0242ac120002");
    private static final int cooldown = 40;

    public EnderFusionSkill(ConditionalWeaponInnateSkill.Builder builder) {
        super(builder.setSelector(executer -> {
            int combo = (Integer)executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get());
            return combo;
        }).setAnimations(new AttackAnimationProvider[]{() -> (AttackAnimation)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_1, () -> (AttackAnimation)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_2, () -> (AttackAnimation)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_3, () -> (AttackAnimation)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_4, () -> (AttackAnimation)WOMAnimations.ENDERBLASTER_TWOHAND_EVADE_LEFT, () -> (AttackAnimation)WOMAnimations.ENDERBLASTER_TWOHAND_EVADE_RIGHT, () -> (AttackAnimation)WOMAnimations.ENDERBLASTER_TWOHAND_PISTOLERO, () -> (AttackAnimation)WOMAnimations.ENDERBLASTER_TWOHAND_AIRSHOOT}));
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                if (!container.getExecuter().isLogicalClient()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHOOT.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
            if (!container.getExecuter().isLogicalClient() && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get(), (Object)80, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            if (!(event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_RIGHT) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_LEFT) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_LAYED_RIGHT) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_LAYED_LEFT))) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHOOT.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if (!(event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_1) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_2) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_3) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_4) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_PISTOLERO) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_LEFT) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_RIGHT) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_TWOHAND_AIRSHOOT))) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        int animation = vertic == 0 ? (horizon == 0 ? -3 : (horizon >= 0 ? 0 : 1)) : (vertic <= 0 ? -3 : -3);
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(animation);
        return packet;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        int i = args.readInt();
        boolean double_cost = false;
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        if (!player.m_20096_() && !player.m_20069_() && player.f_19789_ < 0.1f && (player.m_9236_().m_46859_(player.m_20183_().m_7495_()) || player.f_19855_ - (double)player.m_20183_().m_123342_() > 0.2)) {
            executer.playAnimationSynchronized((StaticAnimation)this.attackAnimations[this.attackAnimations.length - 1].get(), 0.0f);
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.NOFALLDAMAGE.get(), (Object)true, (ServerPlayer)executer.getOriginal());
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)80, (ServerPlayer)executer.getOriginal());
            double_cost = true;
        } else if (((ServerPlayer)executer.getOriginal()).m_20142_()) {
            executer.playAnimationSynchronized((StaticAnimation)this.attackAnimations[this.attackAnimations.length - 2].get(), 0.0f);
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.NOFALLDAMAGE.get(), (Object)true, (ServerPlayer)executer.getOriginal());
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)80, (ServerPlayer)executer.getOriginal());
            double_cost = true;
        } else {
            if (i != -3) {
                executer.playAnimationSynchronized((StaticAnimation)this.attackAnimations[i + 4].get(), 0.0f);
                executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) - 1), (ServerPlayer)executer.getOriginal());
            } else {
                int animation = this.getAnimationInCondition(executer);
                executer.playAnimationSynchronized((StaticAnimation)this.attackAnimations[animation].get(), 0.0f);
                if (animation == 1 || animation == 3) {
                    double_cost = true;
                }
            }
            if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) < 3) {
                if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) == 1) {
                    executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)80, (ServerPlayer)executer.getOriginal());
                }
                executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) + 1), (ServerPlayer)executer.getOriginal());
            } else {
                executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0, (ServerPlayer)executer.getOriginal());
            }
        }
        if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) < 40) {
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40, (ServerPlayer)executer.getOriginal());
        }
        executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)true, (ServerPlayer)executer.getOriginal());
        if (!((ServerPlayer)executer.getOriginal()).m_7500_()) {
            int stack = executer.getSkill((Skill)this).getStack();
            SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executer, (Skill)this, this.resource);
            executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
                if (double_cost) {
                    event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
                }
            }
            int sweeping_edge = ((ServerPlayer)executer.getOriginal()).m_21206_().getEnchantmentLevel(Enchantments.f_44983_) + ((ServerPlayer)executer.getOriginal()).m_21205_().getEnchantmentLevel(Enchantments.f_44983_);
            Random random = new Random();
            if ((double)(Math.abs(random.nextInt()) % 100) < 100.0 * (-(1.0 / Math.sqrt(sweeping_edge / 2 + 1)) + 1.0)) {
                if (!double_cost || stack != 1) {
                    this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() + 1);
                }
                ((ServerPlayer)executer.getOriginal()).m_9236_().m_6263_(null, ((ServerPlayer)executer.getOriginal()).m_20185_(), ((ServerPlayer)executer.getOriginal()).m_20186_(), ((ServerPlayer)executer.getOriginal()).m_20189_(), (SoundEvent)WOMSounds.ENDERBLASTER_RELOAD.get(), ((ServerPlayer)executer.getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        }
        executer.getSkill((Skill)this).activate();
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill() && executer.getEntityState().canBasicAttack();
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch) {
        float consumption = this.getDefaultConsumptionAmount(playerpatch);
        SkillConsumeEvent event = new SkillConsumeEvent(playerpatch, (Skill)this, this.resource, consumption);
        playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
        if (event.isCanceled()) {
            return false;
        }
        if (event.getResourceType().predicate.canExecute((Skill)this, playerpatch, event.getAmount())) {
            int stack = playerpatch.getSkill((Skill)this).getStack();
            if (playerpatch.getSkill(EpicFightSkills.HYPERVITALITY) != null && stack <= 0) {
                if (playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).getStack() > 0) {
                    playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).deactivate();
                    playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).setMaxDuration(6);
                    playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).setMaxResource(6.0f);
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        list.add(Component.m_237115_((String)traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(Component.m_237115_((String)(traslatableText + ".tooltip")).m_130940_(ChatFormatting.DARK_GRAY));
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Close range shots:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Ender Bullets:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(2), "Laser beam:");
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.RELOAD_COOLDOWN.get(), (Object)80, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if (container.getExecuter().getSkill((Skill)this).getStack() < this.getMaxStack() && ((Player)container.getExecuter().getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ENDER_BLASTER.get()) {
                    if (container.getExecuter().getSkill(WOMSkills.MEDITATION) == null) {
                        container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_TWOHAND_RELOAD, 0.0f);
                    } else if ((Integer)container.getExecuter().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0 || container.getExecuter().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == null) {
                        container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_TWOHAND_RELOAD, 0.0f);
                    }
                }
            }
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            if (container.getExecuter().isLogicalClient()) {
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ZOOM.get())).booleanValue()) {
                    ClientEngine.getInstance().renderEngine.zoomIn();
                } else {
                    ClientEngine.getInstance().renderEngine.zoomOut(0);
                }
            }
            if (!container.getExecuter().isLogicalClient()) {
                ServerPlayerPatch executer = (ServerPlayerPatch)container.getExecuter();
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.NOFALLDAMAGE.get())).booleanValue()) {
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 10) {
                        ((Player)container.getExecuter().getOriginal()).m_183634_();
                    } else {
                        container.getExecuter().getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.NOFALLDAMAGE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    }
                }
                int sweeping_edge = ((ServerPlayer)executer.getOriginal()).m_21206_().getEnchantmentLevel(Enchantments.f_44983_) + ((ServerPlayer)executer.getOriginal()).m_21205_().getEnchantmentLevel(Enchantments.f_44983_);
                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHOOT.get())).booleanValue() && !((Player)container.getExecuter().getOriginal()).m_6117_() && container.getExecuter().getEntityState().canBasicAttack()) {
                    ((Player)container.getExecuter().getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHOOT.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null || container.getStack() > 0 || ((Player)container.getExecuter().getOriginal()).m_7500_()) {
                        boolean flag = true;
                        if (!((Player)container.getExecuter().getOriginal()).m_7500_()) {
                            int stack = executer.getSkill((Skill)this).getStack();
                            if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null && stack <= 0) {
                                if (executer.getSkill(EpicFightSkills.HYPERVITALITY).getStack() > 0) {
                                    executer.getSkill(EpicFightSkills.HYPERVITALITY).activate();
                                    executer.getSkill(EpicFightSkills.HYPERVITALITY).setMaxResource(12.0f);
                                    executer.getSkill(EpicFightSkills.HYPERVITALITY).getSkill().setStackSynchronize(executer, -1);
                                    EpicFightNetworkManager.sendToPlayer((Object)SPSkillExecutionFeedback.executed((int)executer.getSkill(EpicFightSkills.HYPERVITALITY).getSlotId()), (ServerPlayer)((ServerPlayer)executer.getOriginal()));
                                } else {
                                    flag = false;
                                }
                            }
                            if (flag) {
                                this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() - 1);
                                Random random = new Random();
                                if ((double)(Math.abs(random.nextInt()) % 100) < 100.0 * (-(1.0 / Math.sqrt(sweeping_edge / 2 + 1)) + 1.0)) {
                                    this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() + 1);
                                    ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)WOMSounds.ENDERBLASTER_RELOAD.get(), ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                                }
                            }
                        }
                        if (flag) {
                            if (((ServerPlayer)executer.getOriginal()).m_6067_() || ((ServerPlayer)executer.getOriginal()).m_21255_() || executer.getCurrentLivingMotion() == LivingMotions.CREATIVE_FLY || executer.getCurrentLivingMotion() == LivingMotions.SWIM) {
                                if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SIDE.get())).booleanValue()) {
                                    container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_LAYED_RIGHT, 0.0f);
                                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SIDE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                                } else {
                                    container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_LAYED_LEFT, 0.0f);
                                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SIDE.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                                }
                            } else if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SIDE.get())).booleanValue()) {
                                container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_RIGHT, 0.0f);
                                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SIDE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                            } else {
                                container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_TWOHAND_SHOOT_LEFT, 0.0f);
                                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SIDE.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                            }
                        }
                    }
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ZOOM.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                } else if (((Player)container.getExecuter().getOriginal()).m_6117_()) {
                    ((Player)container.getExecuter().getOriginal()).m_6858_(false);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
        } else {
            if (!container.getExecuter().isLogicalClient()) {
                container.getExecuter().getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if (container.getExecuter().isLogicalClient()) {
                ClientEngine.getInstance().renderEngine.zoomOut(0);
            }
        }
    }
}

