/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.GesetzCapability;
import reascer.wom.world.item.HerscherItem;
import yesman.epicfight.api.animation.AttackAnimationProvider;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.ConditionalWeaponInnateSkill;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.RightClickItemEvent;

public class RegierungSkill
extends ConditionalWeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("63c38d4f-cc97-4339-bedf-d9bba36ba29f");

    public RegierungSkill(ConditionalWeaponInnateSkill.Builder builder) {
        super(builder.setSelector(executer -> {
            int combo = (Integer)executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get());
            return combo;
        }).setAnimations(new AttackAnimationProvider[]{() -> (AttackAnimation)WOMAnimations.GESETZ_AUTO_1, () -> (AttackAnimation)WOMAnimations.GESETZ_AUTO_2, () -> (AttackAnimation)WOMAnimations.GESETZ_AUTO_3, () -> (AttackAnimation)WOMAnimations.GESETZ_KRUMMEN, () -> (AttackAnimation)WOMAnimations.GESETZ_SPRENGKOPF}));
    }

    public void onInitiate(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            this.setMaxDurationSynchronize((ServerPlayerPatch)container.getExecuter(), 600 + 400 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)((ServerPlayerPatch)container.getExecuter()).getOriginal())));
        }
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SUPER_ARMOR.get())).booleanValue()) {
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (event.getMovementInput().f_108568_ || event.getMovementInput().f_108569_ || event.getMovementInput().f_108570_ || event.getMovementInput().f_108571_) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.GUARD_POINT.get(), (Object)false, (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.GESETZ_SPRENGKOPF.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if (!event.getAnimation().equals((Object)WOMAnimations.HERRSCHER_AUTO_2) && !event.getAnimation().equals((Object)WOMAnimations.GESETZ_AUTO_1)) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.GUARD_POINT.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
                if (event.getAnimation().equals((Object)WOMAnimations.HERRSCHER_GUARD_HIT)) {
                    this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 40);
                }
                if (event.getAnimation().equals((Object)WOMAnimations.GESETZ_SPRENGKOPF)) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SUPER_ARMOR.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SUPER_ARMOR.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
                if (event.getAnimation().equals((Object)WOMAnimations.HERRSCHER_TRANE)) {
                    this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 100);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.GUARD_POINT.get())).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                    ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)playerentity.m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
                    StaticAnimation animation = Animations.BIPED_HIT_SHIELD;
                    float convert = -0.05f;
                    switch ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.GUARD_POINT_RESULT.get())) {
                        case 1: {
                            animation = WOMAnimations.GESETZ_AUTO_1;
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)1, playerentity);
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 20);
                            break;
                        }
                        case 2: {
                            animation = WOMAnimations.HERRSCHER_AUTO_2;
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 40);
                            break;
                        }
                        case 3: {
                            animation = WOMAnimations.HERRSCHER_AUTO_3;
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 100);
                            break;
                        }
                        case 4: {
                            animation = WOMAnimations.HERRSCHER_AUTO_3;
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 100);
                            convert = -0.15f;
                            break;
                        }
                        case 5: {
                            animation = WOMAnimations.HERRSCHER_AUTO_2;
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)1, playerentity);
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 40);
                            break;
                        }
                        case 6: {
                            animation = WOMAnimations.HERRSCHER_AUTO_2;
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 40);
                            break;
                        }
                        default: {
                            animation = Animations.BIPED_HIT_SHIELD;
                        }
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.GUARD_POINT_RESULT.get()) != 3) {
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
                    }
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                    Entity directEntity = ((DamageSource)event.getDamageSource()).m_7640_();
                    LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)directEntity, LivingEntityPatch.class);
                    if (entitypatch != null) {
                        entitypatch.onAttackBlocked((DamageSource)event.getDamageSource(), entitypatch);
                    }
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        if (container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK) != null && !container.getExecuter().isLogicalClient()) {
            container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get(), (Object)Float.valueOf(1.0f), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        this.setMaxDurationSynchronize(executer, 600 + 400 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal())));
        if (player.m_6117_() && executer.getSkill((Skill)this).getRemainDuration() > 0 && executer.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability) {
            executer.playAnimationSynchronized(WOMAnimations.GESETZ_WIDERSTAND, 0.0f);
        } else if (!player.m_20096_() && !player.m_20069_() && (player.m_9236_().m_46859_(player.m_20183_().m_7495_()) || player.f_19855_ - (double)player.m_20183_().m_123342_() > 0.2)) {
            executer.playAnimationSynchronized((StaticAnimation)this.attackAnimations[this.attackAnimations.length - 1].get(), 0.0f);
        } else if (((ServerPlayer)executer.getOriginal()).m_20142_()) {
            executer.playAnimationSynchronized((StaticAnimation)this.attackAnimations[this.attackAnimations.length - 2].get(), 0.0f);
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0, (ServerPlayer)executer.getOriginal());
        } else {
            int animation = this.getAnimationInCondition(executer);
            executer.playAnimationSynchronized((StaticAnimation)this.attackAnimations[animation].get(), 0.0f);
            if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) < 2) {
                executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COMBO.get()) + 1), (ServerPlayer)executer.getOriginal());
            } else {
                executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0, (ServerPlayer)executer.getOriginal());
            }
        }
        executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)40, (ServerPlayer)executer.getOriginal());
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        return executer.getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability && executer.getValidItemInHand(InteractionHand.MAIN_HAND).m_41720_() instanceof HerscherItem;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill() && executer.getEntityState().canBasicAttack();
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch) {
        Player player = (Player)playerpatch.getOriginal();
        if (!player.m_20096_() && !player.m_20069_() && (player.m_9236_().m_46859_(player.m_20183_().m_7495_()) || player.f_19855_ - (double)player.m_20183_().m_123342_() > 0.2)) {
            return playerpatch.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 3.0f);
        }
        if (((Player)playerpatch.getOriginal()).m_20142_()) {
            return playerpatch.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 2.0f);
        }
        return true;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        list.add(Component.m_237115_((String)traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(Component.m_237115_((String)(traslatableText + ".tooltip")).m_130940_(ChatFormatting.DARK_GRAY));
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        } else if (!container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COMBO.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
        if (container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK) != null && ((Float)container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get())).floatValue() != 0.2f && !container.getExecuter().isLogicalClient()) {
            container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get(), (Object)Float.valueOf(0.2f), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SUPER_ARMOR.get())).booleanValue()) {
            ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
        }
        if (!container.getExecuter().isLogicalClient()) {
            if (((Player)container.getExecuter().getOriginal()).m_6117_()) {
                if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PARRYING.get())).booleanValue()) {
                    container.getExecuter().getEventListener().triggerEvents(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, (PlayerEvent)new RightClickItemEvent((PlayerPatch)((ServerPlayerPatch)container.getExecuter())));
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        }
        container.setResource(10.0f);
    }
}

