/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.damagesources.WOMExtraDamageInstance;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SkyDiveSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("c7a0ee46-56b3-4008-9fba-d2594b1e2676");

    public SkyDiveSkill(Skill.Builder<?> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation().equals((Object)WOMAnimations.AGONY_SKY_DIVE) && event.getTarget() != ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()) {
                int stack = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get());
                event.getDamageSource().addExtraDamage(WOMExtraDamageInstance.WOM_FLAT_DAMAGE.create(new float[]{(float)(stack * stack) * 0.5f}));
                if (stack > 1) {
                    event.getDamageSource().addExtraDamage(WOMExtraDamageInstance.TARGET_LOST_HEALTH.create(new float[]{(float)stack / 10.0f}));
                }
                ((Player)container.getExecuter().getOriginal()).m_183634_();
            }
            if (!event.getTarget().m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
                BlockPos ground = ((ServerPlayer)executer.getOriginal()).m_20183_();
                while (((ServerPlayer)executer.getOriginal()).m_9236_().m_8055_(ground).m_60713_(Blocks.f_50016_)) {
                    ground = ground.m_7495_();
                }
                if (((ServerPlayer)executer.getOriginal()).m_20186_() - (double)ground.m_123342_() > 4.0 && !event.getDamageSource().getAnimation().equals((Object)WOMAnimations.AGONY_RIPPING_FANGS) && !event.getDamageSource().getAnimation().equals((Object)WOMAnimations.AGONY_SKY_DIVE) && !event.getDamageSource().getAnimation().equals((Object)WOMAnimations.AGONY_SKY_DIVE_X)) {
                    ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19620_, 3, 3, true, false, false));
                    ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 2, true, false, false));
                    event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, 3, true, false, false));
                    event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 2, true, false, false));
                }
                if (event.getDamageSource().getAnimation().equals((Object)WOMAnimations.AGONY_RIPPING_FANGS)) {
                    if (event.getTarget().m_21023_(MobEffects.f_19591_)) {
                        event.getTarget().m_21195_(MobEffects.f_19591_);
                    }
                    if (event.getTarget().m_21023_(MobEffects.f_19620_)) {
                        event.getTarget().m_21195_(MobEffects.f_19620_);
                    }
                    if (((ServerPlayer)executer.getOriginal()).m_21023_(MobEffects.f_19591_)) {
                        ((ServerPlayer)executer.getOriginal()).m_21195_(MobEffects.f_19591_);
                    }
                    if (((ServerPlayer)executer.getOriginal()).m_21023_(MobEffects.f_19620_)) {
                        ((ServerPlayer)executer.getOriginal()).m_21195_(MobEffects.f_19620_);
                    }
                    ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 2, 0, true, false, false));
                    event.getTarget().m_6027_(event.getTarget().m_20185_(), Math.max(((ServerPlayer)executer.getOriginal()).m_20186_() - 0.5, (double)ground.m_7494_().m_123342_()), event.getTarget().m_20189_());
                }
                if (((ServerPlayer)executer.getOriginal()).m_20186_() - (double)ground.m_123342_() > 1.0 && (event.getDamageSource().getAnimation().equals((Object)WOMAnimations.AGONY_SKY_DIVE) || event.getDamageSource().getAnimation().equals((Object)WOMAnimations.AGONY_SKY_DIVE_X))) {
                    event.getTarget().m_6027_(event.getTarget().m_20185_(), (double)ground.m_123342_(), event.getTarget().m_20189_());
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
            BlockPos ground = ((ServerPlayer)executer.getOriginal()).m_20183_();
            StaticAnimation[] animations = new StaticAnimation[]{WOMAnimations.AGONY_AUTO_1, WOMAnimations.AGONY_COUNTER, WOMAnimations.AGONY_AUTO_3, WOMAnimations.AGONY_AUTO_2, WOMAnimations.AGONY_RIPPING_FANGS};
            while (((ServerPlayer)executer.getOriginal()).m_9236_().m_8055_(ground).m_60713_(Blocks.f_50016_)) {
                ground = ground.m_7495_();
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
                event.setCanceled(true);
                int attack = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ATTACKS.get());
                executer.playAnimationSynchronized(animations[attack], 0.0f);
                if (attack < 4) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ATTACKS.get(), (Object)(++attack), (ServerPlayer)executer.getOriginal());
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ATTACKS.get(), (Object)0, (ServerPlayer)executer.getOriginal());
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (event.getAnimation().equals((Object)WOMAnimations.AGONY_RISING_EAGLE)) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ATTACKS.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (((Boolean)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 30, 0, true, false, false));
            if (executer.getSkill(EpicFightSkills.HYPERVITALITY) == null) {
                executer.playAnimationSynchronized(WOMAnimations.AGONY_SKY_DIVE, 0.0f);
            } else {
                executer.playAnimationSynchronized(WOMAnimations.AGONY_SKY_DIVE_X, 0.0f);
            }
            if (executer.getSkill(EpicFightSkills.HYPERVITALITY) == null) {
                executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STACK.get(), (Object)(executer.getSkill((Skill)this).getStack() + 1), (ServerPlayer)executer.getOriginal());
            } else {
                executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STACK.get(), (Object)1, (ServerPlayer)executer.getOriginal());
            }
            if (!((ServerPlayer)executer.getOriginal()).m_7500_()) {
                EpicFightDamageSource damage = executer.getDamageSource(WOMAnimations.AGONY_SKY_DIVE, InteractionHand.MAIN_HAND);
                damage.setStunType(StunType.NONE);
                ((ServerPlayer)executer.getOriginal()).m_6469_((DamageSource)damage, ((ServerPlayer)executer.getOriginal()).m_21223_() * 0.4f);
            }
            if (executer.getSkill(EpicFightSkills.HYPERVITALITY) == null && !((ServerPlayer)executer.getOriginal()).m_7500_()) {
                this.setStackSynchronize(executer, 0);
            }
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false, (ServerPlayer)executer.getOriginal());
            executer.getSkill((Skill)this).activate();
        } else {
            executer.playAnimationSynchronized(WOMAnimations.AGONY_RISING_EAGLE, 0.0f);
            float distance = 20 + 10 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal()));
            AABB box = AABB.m_165882_((Vec3)((ServerPlayer)executer.getOriginal()).m_20182_(), (double)(distance * 2.0f), (double)(distance * 2.0f), (double)(distance * 2.0f));
            List list = ((ServerPlayer)executer.getOriginal()).m_9236_().m_45933_(executer.getOriginal(), box);
            for (Entity entity : list) {
                OwnableEntity animal;
                LivingEntity livingEntity;
                OwnableEntity pet;
                if (entity instanceof ArmorStand || entity instanceof OwnableEntity && (pet = (OwnableEntity)entity).m_269323_() == executer.getOriginal() || !(entity.m_20270_(executer.getOriginal()) < distance)) continue;
                double distance_to_target = Math.sqrt(Math.pow(((ServerPlayer)executer.getOriginal()).m_20182_().m_7096_() - entity.m_20185_(), 2.0) + Math.pow(((ServerPlayer)executer.getOriginal()).m_20182_().m_7094_() - entity.m_20189_(), 2.0) + Math.pow(((ServerPlayer)executer.getOriginal()).m_20182_().m_7098_() - entity.m_20186_(), 2.0));
                double power = Math.max(-(1.0 - distance_to_target / 50.0) * 3.0, -(distance_to_target / 50.0) * 12.0);
                if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
                    power = -(distance_to_target / 50.0) * 18.0;
                }
                double d1 = ((ServerPlayer)executer.getOriginal()).m_20182_().m_7096_() - entity.m_20185_();
                double d2 = ((ServerPlayer)executer.getOriginal()).m_20182_().m_7098_() - 1.0 - entity.m_20186_();
                double d0 = ((ServerPlayer)executer.getOriginal()).m_20182_().m_7094_() - entity.m_20189_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                if (entity instanceof LivingEntity) {
                    power *= 1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_);
                }
                entity.f_19812_ = true;
                Vec3 vec3 = entity.m_20184_();
                Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power);
                boolean noFalling = true;
                boolean notPet = true;
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19591_)) {
                    noFalling = false;
                }
                if (entity instanceof OwnableEntity && (animal = (OwnableEntity)entity).m_269323_() != executer.getOriginal()) {
                    notPet = false;
                }
                if (!noFalling || !notPet) continue;
                entity.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
            }
        }
    }

    public boolean resourcePredicate(PlayerPatch<?> executer) {
        if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null && executer.getSkill(EpicFightSkills.HYPERVITALITY).isActivated()) {
            return true;
        }
        if (((Boolean)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            return super.resourcePredicate(executer);
        }
        return executer.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 8.0f);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null) {
            return executer.getEntityState().canBasicAttack();
        }
        return executer.getEntityState().canUseSkill();
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        if (executer.isLogicalClient()) {
            return super.canExecute(executer);
        }
        ItemStack itemstack = ((Player)executer.getOriginal()).m_21205_();
        if (!((Boolean)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(executer, itemstack) == this && ((Player)executer.getOriginal()).m_20202_() == null && ((Player)executer.getOriginal()).f_19789_ == 0.0f;
        }
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(executer, itemstack) == this && ((Player)executer.getOriginal()).m_20202_() == null;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Plunge :");
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient() && ((Player)container.getExecuter().getOriginal()).m_20096_() && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false, (ServerPlayer)container.getExecuter().getOriginal());
        }
    }
}

