/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMWeaponColliders;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.entity.mob.LupusRex;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SolarArcanaSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("c7a0ee46-56b3-4008-9fba-d2594b1e2676");

    public SolarArcanaSkill(Skill.Builder<?> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {});
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCollider() == WOMWeaponColliders.SOLAR) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {});
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        this.setStackSynchronize(executer, 1);
        if (((Boolean)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get())).booleanValue()) {
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)false, (ServerPlayer)executer.getOriginal());
            if (((Boolean)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
                executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARTICLE.get(), (Object)false, (ServerPlayer)executer.getOriginal());
                executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get(), (Object)false, (ServerPlayer)executer.getOriginal());
                executer.modifyLivingMotionByCurrentItem(false);
            } else {
                executer.playAnimationSynchronized(WOMAnimations.SOLAR_BRASERO, 0.0f);
            }
        } else {
            switch ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get())) {
                case 0: {
                    ((ServerPlayer)executer.getOriginal()).m_9236_().m_6263_(null, ((ServerPlayer)executer.getOriginal()).m_20185_(), ((ServerPlayer)executer.getOriginal()).m_20186_(), ((ServerPlayer)executer.getOriginal()).m_20189_(), SoundEvents.f_12031_, ((ServerPlayer)executer.getOriginal()).m_5720_(), 1.0f, 2.0f);
                    executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)-1, (ServerPlayer)executer.getOriginal());
                    break;
                }
                case 1: {
                    executer.playAnimationSynchronized(WOMAnimations.SOLAR_AUTO_1_POLVORA, 0.0f);
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)8, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)1, (ServerPlayer)executer.getOriginal());
                    break;
                }
                case 2: {
                    if (!((ServerPlayer)executer.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                        ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 7, 0, true, false, false));
                    }
                    executer.playAnimationSynchronized(WOMAnimations.SOLAR_AUTO_2_POLVORA, 0.0f);
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)8, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)2, (ServerPlayer)executer.getOriginal());
                    break;
                }
                case 3: {
                    executer.playAnimationSynchronized(WOMAnimations.SOLAR_AUTO_3_POLVORA, 0.0f);
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)8, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)3, (ServerPlayer)executer.getOriginal());
                    break;
                }
                case 4: {
                    if (!((ServerPlayer)executer.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                        ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 7, 0, true, false, false));
                    }
                    executer.playAnimationSynchronized(WOMAnimations.SOLAR_AUTO_4_POLVORA, 0.0f);
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)8, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)4, (ServerPlayer)executer.getOriginal());
                    break;
                }
                case 5: {
                    executer.playAnimationSynchronized(WOMAnimations.SOLAR_BRASERO_OBSCURIDAD, 0.0f);
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)8, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)5, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)-3, (ServerPlayer)executer.getOriginal());
                    break;
                }
                case 6: {
                    executer.playAnimationSynchronized(WOMAnimations.SOLAR_BRASERO_CREMATORIO, 0.0f);
                    executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)0, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STORED_HEAT_LEVEL.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)0, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)0, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER_REFRESH.get())), (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARTICLE.get(), (Object)false, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)8, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)6, (ServerPlayer)executer.getOriginal());
                    break;
                }
                case 7: {
                    executer.playAnimationSynchronized(WOMAnimations.SOLAR_BRASERO_INFIERNO, 0.0f);
                    executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)0, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STORED_HEAT_LEVEL.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)0, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)0, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER_REFRESH.get())), (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARTICLE.get(), (Object)false, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)8, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)7, (ServerPlayer)executer.getOriginal());
                    break;
                }
                case 8: {
                    executer.playAnimationSynchronized(WOMAnimations.SOLAR_OBSCURIDAD_AUTO_3_A, 0.0f);
                    executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)0, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get())), (ServerPlayer)executer.getOriginal());
                    executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)Math.max((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get()) - 1, 0), (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)4, (ServerPlayer)executer.getOriginal());
                    executer.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)8, (ServerPlayer)executer.getOriginal());
                    break;
                }
                default: {
                    executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)-1, (ServerPlayer)executer.getOriginal());
                }
            }
        }
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            this.setStackSynchronize((ServerPlayerPatch)container.getExecuter(), 1);
            if (container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get()) != null && (Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get()) > 0) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) > 0) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) == 0) {
                        float power = (float)((Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get())).intValue() / 200.0f * 9.0f * (float)(1 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal())));
                        AABB box = AABB.m_165882_((Vec3)((Player)container.getExecuter().getOriginal()).m_20182_(), (double)(power * 2.0f), (double)(power * 2.0f), (double)(power * 2.0f));
                        List list = ((Player)container.getExecuter().getOriginal()).m_9236_().m_45933_(container.getExecuter().getOriginal(), box);
                        for (Entity entity : list) {
                            LivingEntity livingEntity;
                            LupusRex lupus;
                            if (entity instanceof ArmorStand || entity instanceof LupusRex && (lupus = (LupusRex)entity).m_30614_() || !(entity instanceof LivingEntity) || !(entity.m_20270_(container.getExecuter().getOriginal()) < power) || (livingEntity = (LivingEntity)entity).m_21224_()) continue;
                            if (livingEntity.m_6060_()) {
                                Boolean no_solar_ignited = true;
                                String solar_tag = "";
                                for (String tag : livingEntity.m_19880_()) {
                                    if (!tag.contains("solar_ignited:")) continue;
                                    no_solar_ignited = false;
                                    solar_tag = tag;
                                    break;
                                }
                                if (!no_solar_ignited.booleanValue()) continue;
                                livingEntity.m_20049_("solar_ignited:1");
                                livingEntity.m_20254_(9 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal())) * 3);
                                continue;
                            }
                            livingEntity.m_20254_(9 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal())) * 3);
                        }
                    }
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
        }
    }
}

