/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class HerrscherPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("7ef0b439-f520-4fcb-8959-01b71c601ba8");

    public HerrscherPassive(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) != null && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) > 0) {
                event.setAmount(event.getAmount() * (1.0f - (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get())).intValue() / 100.0f));
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STACK.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) - 5), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_257000_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 2.0f, 0.5f);
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.7f, 0.0f, 0.0f), 0.6f), ((Player)container.getExecuter().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecuter().getOriginal()).m_20189_() - 0.2, 50, 0.6, 0.4, 0.6, (double)0.1f);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        if (container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getSkill() instanceof HerrscherPassive) {
            return (Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) > 0;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderColor((float)0.7f, (float)0.0f, (float)0.0f, (float)1.0f);
        guiGraphics.m_280411_(WOMSkills.REGIERUNG.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String string = String.valueOf(container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()));
        guiGraphics.drawString(gui.font, string, x + 12.0f - (float)(gui.font.m_92895_(string) / 2), y + 10.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient() && (Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) > 0) {
            PlayerPatch entitypatch = container.getExecuter();
            float power = 1.0f + (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get())).intValue() / 10.0f;
            int n = (int)(6.0f * power);
            double r = 0.9;
            double t = 0.05 * (double)power;
            for (int i = 0; i < n; ++i) {
                double theta = Math.PI * 2 * new Random().nextDouble();
                double phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                double x = r * Math.cos(phi) * Math.cos(theta);
                double y = r * Math.cos(phi) * Math.sin(theta);
                double z = r * Math.sin(phi);
                Vec3f direction = new Vec3f((float)x, (float)y, (float)z);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(90.0), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.7f, 0.0f, 0.0f), 0.6f), ((Player)entitypatch.getOriginal()).m_20185_() + (double)direction.x, ((Player)entitypatch.getOriginal()).m_20186_() + 0.75, ((Player)entitypatch.getOriginal()).m_20189_() + (double)direction.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

