/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SatsujinPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("010e5bfa-e6a2-11ec-8fea-0242ac120002");

    public SatsujinPassive(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            StaticAnimation[] resetAnimations;
            for (StaticAnimation staticAnimation : resetAnimations = new StaticAnimation[]{WOMAnimations.KATANA_AUTO_1, WOMAnimations.KATANA_AUTO_2, WOMAnimations.KATANA_AUTO_3, WOMAnimations.KATANA_DASH, WOMAnimations.HERRSCHER_AUSROTTUNG, WOMAnimations.KATANA_SHEATHED_AUTO_1, WOMAnimations.KATANA_SHEATHED_AUTO_2, WOMAnimations.KATANA_SHEATHED_AUTO_3, WOMAnimations.KATANA_GUARD, WOMAnimations.KATANA_GUARD_HIT, Animations.BIPED_HIT_SHORT, Animations.BIPED_HIT_LONG}) {
                if (!event.getAnimation().equals((Object)staticAnimation)) continue;
                container.getSkill().setConsumptionSynchronize((ServerPlayerPatch)event.getPlayerPatch(), 0.0f);
                container.getSkill().setStackSynchronize((ServerPlayerPatch)event.getPlayerPatch(), 0);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> this.onReset(container));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    public void onReset(SkillContainer container) {
        PlayerPatch executer = container.getExecuter();
        if (!executer.isLogicalClient() && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHEATH.get())).booleanValue()) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)executer;
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)false, (ServerPlayer)playerpatch.getOriginal());
            playerpatch.modifyLivingMotionByCurrentItem(false);
            container.getSkill().setConsumptionSynchronize(playerpatch, 0.0f);
        }
    }

    public void setConsumption(SkillContainer container, float value) {
        PlayerPatch executer = container.getExecuter();
        if (!executer.isLogicalClient() && this.consumption < value) {
            ServerPlayer serverPlayer = (ServerPlayer)executer.getOriginal();
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHEATH.get())).booleanValue()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)true, serverPlayer);
                boolean flag = false;
                if (container.getExecuter().getSkill(WOMSkills.MEDITATION) == null) {
                    flag = true;
                } else if ((Integer)container.getExecuter().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0) {
                    flag = true;
                }
                if (flag) {
                    ((ServerPlayerPatch)executer).modifyLivingMotionByCurrentItem(false);
                    SPPlayAnimation msg3 = new SPPlayAnimation(WOMAnimations.KATANA_SHEATHE, serverPlayer.m_19879_(), 0.0f);
                    EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf((Object)msg3, (ServerPlayer)serverPlayer);
                }
            } else {
                ((ServerPlayerPatch)executer).modifyLivingMotionByCurrentItem(false);
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)true, serverPlayer);
        }
        super.setConsumption(container, value);
    }

    public boolean shouldDeactivateAutomatically(PlayerPatch<?> executer) {
        return true;
    }

    public float getCooldownRegenPerSecond(PlayerPatch<?> player) {
        return ((Player)player.getOriginal()).m_6117_() ? 0.0f : 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        if (container.getExecuter().getSkill(WOMSkills.SAKURA_STATE) != null) {
            return (Integer)container.getExecuter().getSkill(WOMSkills.SAKURA_STATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) > 0;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)0.8f, (float)0.9f, (float)0.7f);
        guiGraphics.m_280411_(WOMSkills.SAKURA_STATE.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String string = String.valueOf(container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.font, string, x + 18.0f - (float)(gui.font.m_92895_(string) / 2), y + 8.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }
}

