/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SolarPassiveSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("72eabb8f-f889-4302-80bb-690bb557a008");

    public SolarPassiveSkill(Skill.Builder<?> builder) {
        super(builder.setActivateType(Skill.ActivateType.DURATION_INFINITE));
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {});
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {});
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {});
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            if ((event.getDamageSource().getAnimation().equals((Object)WOMAnimations.SOLAR_AUTO_1_POLVORA) || event.getDamageSource().getAnimation().equals((Object)WOMAnimations.SOLAR_AUTO_3_POLVORA)) && !event.getTarget().m_21224_()) {
                if (event.getTarget().m_6060_()) {
                    Boolean no_solar_ignited = true;
                    for (String tag : event.getTarget().m_19880_()) {
                        if (!tag.contains("solar_ignited:")) continue;
                        no_solar_ignited = false;
                        break;
                    }
                    if (no_solar_ignited.booleanValue()) {
                        event.getTarget().m_20049_("solar_ignited:1");
                        event.getTarget().m_20254_(9 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal())) * 3);
                    }
                } else {
                    event.getTarget().m_20254_(9 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal())) * 3);
                }
            }
            if (event.getDamageSource().getAnimation().equals((Object)WOMAnimations.SOLAR_AUTO_2_POLVORA) || event.getDamageSource().getAnimation().equals((Object)WOMAnimations.SOLAR_AUTO_4_POLVORA) || ((Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
                String Solar_tag = "solar_ignited:0";
                boolean Solar_obscuridad = (Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get());
                if (event.getTarget().m_6060_()) {
                    int explosion_damage = 3 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal())) + Integer.valueOf(Solar_tag.split(":")[1]) * 2;
                    Boolean is_solar_ignited = false;
                    for (String tag : event.getTarget().m_19880_()) {
                        if (!tag.contains("solar_ignited:")) continue;
                        Solar_tag = tag;
                        is_solar_ignited = true;
                        break;
                    }
                    if (is_solar_ignited.booleanValue()) {
                        event.getTarget().f_19802_ = 0;
                        event.getTarget().m_6469_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_269111_().m_269387_(), (float)explosion_damage);
                        ((ServerLevel)event.getTarget().m_9236_()).m_8767_((ParticleOptions)(Integer.valueOf(Solar_tag.split(":")[1]) == 1 ? ParticleTypes.f_123744_ : ParticleTypes.f_123745_), event.getTarget().m_20185_(), event.getTarget().m_20186_() + 1.0, event.getTarget().m_20189_(), 10, 0.0, 0.0, 0.0, 0.1);
                        ((ServerLevel)event.getTarget().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 1.5, event.getTarget().m_20189_(), 1, 0.0, 0.0, 0.0, 0.2);
                        ((ServerLevel)event.getTarget().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 1.0, event.getTarget().m_20189_(), 10, 0.0, 0.0, 0.0, 0.08);
                        ((ServerLevel)event.getTarget().m_9236_()).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.75, event.getTarget().m_20189_(), SoundEvents.f_12273_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 1.0f, 0.5f);
                        ((ServerLevel)event.getTarget().m_9236_()).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.75, event.getTarget().m_20189_(), SoundEvents.f_11929_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 2.0f, 0.5f);
                        if (Integer.valueOf(Solar_tag.split(":")[1]) == 2) {
                            ((ServerLevel)event.getTarget().m_9236_()).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.75, event.getTarget().m_20189_(), SoundEvents.f_11930_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 1.0f, 0.5f);
                        }
                        int heating_speed = (Integer)((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get());
                        heat_lvl = ((Float)((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get())).floatValue();
                        if (!Solar_obscuridad) {
                            ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)Math.min(Math.max(heating_speed + 1, 1), 4), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                        }
                        if (((ServerPlayerPatch)event.getPlayerPatch()).getSkill(EpicFightSkills.HYPERVITALITY) != null && !Solar_obscuridad) {
                            ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get(), (Object)Float.valueOf(Math.min(Math.max(heat_lvl + 1.0f + (float)Integer.valueOf(Solar_tag.split(":")[1]).intValue(), 0.0f), 100.0f)), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                        }
                        ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)160, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                        if (!Solar_obscuridad && Integer.valueOf(Solar_tag.split(":")[1]) != 2) {
                            event.getTarget().m_252836_();
                            event.getTarget().m_20137_("solar_ignited:");
                        }
                    } else {
                        event.getTarget().f_19802_ = 0;
                        event.getTarget().m_6469_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_269111_().m_269387_(), (float)explosion_damage);
                        ((ServerLevel)event.getTarget().m_9236_()).m_8767_((ParticleOptions)(Solar_obscuridad ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), event.getTarget().m_20185_(), event.getTarget().m_20186_() + 1.0, event.getTarget().m_20189_(), 10, 0.0, 0.0, 0.0, 0.1);
                        ((ServerLevel)event.getTarget().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 1.0, event.getTarget().m_20189_(), 10, 0.0, 0.0, 0.0, 0.08);
                        ((ServerLevel)event.getTarget().m_9236_()).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.75, event.getTarget().m_20189_(), SoundEvents.f_12273_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 1.0f, 2.0f);
                        ((ServerLevel)event.getTarget().m_9236_()).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.75, event.getTarget().m_20189_(), SoundEvents.f_11928_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 1.0f, 0.5f);
                        Integer heating_speed = (Integer)((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get());
                        heat_lvl = ((Float)((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get())).floatValue();
                        if (!Solar_obscuridad) {
                            ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)Math.min(Math.max(heating_speed + 1, 1), 4), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                        }
                        if (((ServerPlayerPatch)event.getPlayerPatch()).getSkill(EpicFightSkills.HYPERVITALITY) != null && !Solar_obscuridad) {
                            ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get(), (Object)Float.valueOf(Math.min(Math.max(heat_lvl + 1.0f, 0.0f), 100.0f)), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                        }
                        ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)160, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                        if (!Solar_obscuridad) {
                            event.getTarget().m_252836_();
                        }
                    }
                }
            }
            if ((event.getDamageSource().getAnimation().equals((Object)WOMAnimations.SOLAR_BRASERO_CREMATORIO) && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_CREMATORIO.get())).booleanValue() || event.getDamageSource().getAnimation().equals((Object)WOMAnimations.SOLAR_BRASERO_INFIERNO)) && !event.getTarget().m_21224_()) {
                for (String tag : event.getTarget().m_19880_()) {
                    if (!tag.contains("solar_ignited:")) continue;
                    event.getTarget().m_20137_("solar_ignited:");
                    break;
                }
                event.getTarget().m_20049_("solar_ignited:2");
                event.getTarget().m_20254_(5 + event.getTarget().m_20094_() / 20);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {});
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!((Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
                ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARTICLE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            if ((Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get()) == -5) {
                ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)-2, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_CREMATORIO.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {});
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        int timing_timer = (Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get());
        int size = 75;
        Float alpha = Float.valueOf(1.0f);
        if (timing_timer > 0) {
            alpha = Float.valueOf(1.0f - (1.0f - (float)timing_timer / 4.0f));
            size = (int)(95.0f * (1.0f - 0.5f / (float)timing_timer));
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
        switch ((Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get())) {
            case 5: {
                RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)1.0f, (float)alpha.floatValue());
                break;
            }
            case 6: {
                RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.0f, (float)alpha.floatValue());
                break;
            }
            case 7: {
                RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)alpha.floatValue());
                break;
            }
            case 8: {
                RenderSystem.setShaderColor((float)0.0f, (float)0.8f, (float)1.0f, (float)alpha.floatValue());
                break;
            }
        }
        switch ((Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get())) {
            case 5: {
                RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)1.0f, (float)alpha.floatValue());
                break;
            }
            case 6: {
                RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.0f, (float)alpha.floatValue());
                break;
            }
            case 7: {
                RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)alpha.floatValue());
                break;
            }
            case 8: {
                RenderSystem.setShaderColor((float)0.0f, (float)0.8f, (float)1.0f, (float)alpha.floatValue());
                break;
            }
        }
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        if ((Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get()) != 0 && (Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get()) != -1 || (Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get()) > 0) {
            guiGraphics.m_280411_(new ResourceLocation("wom", "textures/gui/skills/timed_solar_attack.png"), width / 2 + 100 - size / 2, height / 2 - size / 2, size, size, 0.0f, 0.0f, 1, 1, 1, 1);
        }
        float strenght = ((Float)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get())).floatValue();
        switch ((Integer)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get())) {
            case -5: {
                RenderSystem.setShaderColor((float)0.1f, (float)0.4f, (float)1.0f, (float)1.0f);
                break;
            }
            case -4: {
                RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case -3: {
                RenderSystem.setShaderColor((float)0.9f, (float)0.2f, (float)0.0f, (float)1.0f);
                break;
            }
            case -2: {
                RenderSystem.setShaderColor((float)0.9f, (float)0.3f, (float)0.1f, (float)1.0f);
                break;
            }
            case -1: {
                RenderSystem.setShaderColor((float)0.8f, (float)0.4f, (float)0.2f, (float)1.0f);
                break;
            }
            case 0: {
                RenderSystem.setShaderColor((float)0.8f, (float)0.5f, (float)0.3f, (float)1.0f);
                break;
            }
            case 1: {
                RenderSystem.setShaderColor((float)0.9f, (float)0.6f, (float)0.2f, (float)1.0f);
                break;
            }
            case 2: {
                RenderSystem.setShaderColor((float)0.9f, (float)0.7f, (float)0.3f, (float)1.0f);
                break;
            }
            case 3: {
                RenderSystem.setShaderColor((float)1.0f, (float)0.8f, (float)0.6f, (float)1.0f);
                break;
            }
            case 4: {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
        }
        guiGraphics.m_280056_(gui.font, String.valueOf(String.format("%.0f", Float.valueOf(strenght)) + "%"), width - 30 - String.valueOf(String.format("%.0f", Float.valueOf(strenght))).length() * 2, height - 35, 0xFFFFFF, true);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        int i;
        PlayerPatch entitypatch;
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_CREMATORIO.get())).booleanValue()) {
            entitypatch = container.getExecuter();
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getAnimator().getPose(0.0f), Armatures.BIPED.toolL);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, 0.0f));
            OpenMatrix4f CORRECTION = new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_19859_ - 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
            OpenMatrix4f.mul((OpenMatrix4f)CORRECTION, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            int n = 12;
            double r = 0.1;
            for (int i2 = 0; i2 < n; ++i2) {
                double theta = Math.PI * 2 * new Random().nextDouble();
                double phi = Math.acos(new Random().nextDouble());
                double x = r * Math.sin(phi) * Math.cos(theta);
                double y = r * Math.sin(phi) * Math.sin(theta);
                double z = r * Math.cos(phi);
                Vec3f direction = new Vec3f((float)x, (float)y, (float)z);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.translate(new Vec3f(0.0f, 0.0f, 0.2f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), (double)direction.x, (double)direction.y, (double)direction.z);
                if (!new Random().nextBoolean()) continue;
                ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)((new Random().nextFloat() - 0.5f) * 0.05f));
                ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), 0.0, (double)(new Random().nextFloat() * 0.05f), 0.0);
            }
        }
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get()) > 0) {
            entitypatch = container.getExecuter();
            ((Player)entitypatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19607_, 10, 0, true, false, false));
            ((Player)entitypatch.getOriginal()).m_20095_();
            int n = 2;
            double r = 0.7;
            double t = 0.01;
            float power = 1.0f + (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get())).intValue() / 200.0f * 7.0f * (float)(1 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal())));
            for (int i3 = 0; i3 < n; ++i3) {
                double theta = Math.PI * 2 * new Random().nextDouble();
                double phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                double x = r * Math.cos(phi) * Math.cos(theta);
                double y = r * Math.cos(phi) * Math.sin(theta);
                double z = r * Math.sin(phi);
                Vec3f direction = new Vec3f((float)x, (float)y, (float)z);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.rotate((float)Math.toRadians(90.0), new Vec3f(1.0f, 0.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, ((Player)entitypatch.getOriginal()).m_20185_() + (double)direction.x, ((Player)entitypatch.getOriginal()).m_20186_() + (double)0.1f, ((Player)entitypatch.getOriginal()).m_20189_() + (double)direction.z, 0.0, (double)0.01f, 0.0);
                ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, ((Player)entitypatch.getOriginal()).m_20185_() + (double)(direction.x * (1.0f + new Random().nextFloat() * power)), ((Player)entitypatch.getOriginal()).m_20186_() + (double)0.1f, ((Player)entitypatch.getOriginal()).m_20189_() + (double)(direction.z * (1.0f + new Random().nextFloat() * power)), 0.0, (double)(0.1f + new Random().nextFloat() * 0.2f), 0.0);
                for (int j = 0; j < 3 * (1 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal()))); ++j) {
                    theta = Math.PI * 2 * new Random().nextDouble();
                    phi = (new Random().nextDouble() - 0.5) * Math.PI * t / r;
                    x = r * Math.cos(phi) * Math.cos(theta);
                    y = r * Math.cos(phi) * Math.sin(theta);
                    z = r * Math.sin(phi);
                    direction = new Vec3f((float)x, (float)y, (float)z);
                    rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_)), new Vec3f(0.0f, 1.0f, 0.0f));
                    rotation.rotate((float)Math.toRadians(90.0), new Vec3f(1.0f, 0.0f, 0.0f));
                    OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                    ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, ((Player)entitypatch.getOriginal()).m_20185_() + (double)(direction.x * power), ((Player)entitypatch.getOriginal()).m_20186_() + (double)0.1f, ((Player)entitypatch.getOriginal()).m_20189_() + (double)(direction.z * power), 0.0, (double)0.01f, 0.0);
                }
            }
        }
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PARTICLE.get())).booleanValue() && !container.getExecuter().getEntityState().attacking()) {
            entitypatch = container.getExecuter();
            int numberOf = 3;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            for (i = 0; i < numberOf; ++i) {
                if (Math.abs(new Random().nextInt()) % 100 < ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get())).intValue()) {
                    OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getAnimator().getPose(interpolation), Armatures.BIPED.toolL);
                    transformMatrix.translate(new Vec3f(0.4f, 0.0f, 0.0f));
                    OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
                    ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)((new Random().nextFloat() - 0.5f) * 0.05f));
                    ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), (double)((new Random().nextFloat() - 0.5f) * 0.01f), (double)(new Random().nextFloat() * 0.05f), (double)((new Random().nextFloat() - 0.5f) * 0.01f));
                }
                interpolation += partialScale;
            }
        }
        if (((Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARTICLE.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            entitypatch = container.getExecuter();
            int numberOf = 3;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            for (i = 0; i < numberOf; ++i) {
                if (Math.abs(new Random().nextInt()) % 100 < ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get())).intValue()) {
                    OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getAnimator().getPose(interpolation), Armatures.BIPED.toolR);
                    transformMatrix.translate(new Vec3f((new Random().nextFloat() - 0.5f) * 0.2f, (new Random().nextFloat() - 0.5f) * 0.8f + 0.08f, -(new Random().nextFloat() * 2.9f) - 0.2f));
                    OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
                    ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), (double)((new Random().nextFloat() - 0.5f) * 0.02f), (double)((new Random().nextFloat() - 0.5f) * 0.02f), (double)((new Random().nextFloat() - 0.5f) * 0.02f));
                }
                interpolation += partialScale;
            }
        }
        if (!container.getExecuter().isLogicalClient()) {
            if (((Player)container.getExecuter().getOriginal()).f_19787_ - ((Player)container.getExecuter().getOriginal()).f_19867_ > 0.1f) {
                if (!((Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARTICLE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get()) == -5) {
                    container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STORED_HEAT_LEVEL.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
            if (((Player)container.getExecuter().getOriginal()).m_7500_()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get(), (Object)Float.valueOf(100.0f), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD_TA_TIMER.get()) == 0) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
            if (((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get())).floatValue() == 0.0f) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get()) > 0 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get()) < 200) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get()) + 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER_REFRESH.get(), (Object)80, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER_REFRESH.get(), (Object)160, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0) {
                if (!((Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER_REFRESH.get())), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                int heating_speed = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get());
                if (heating_speed >= -4 && heating_speed <= 4) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)Math.min(Math.max(heating_speed - 1, -4), 4), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CYCLE.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            } else {
                int cycle = 20;
                int cycle_modifier = 0;
                Float heat_level = (Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get());
                Float stored_heat_level = (Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STORED_HEAT_LEVEL.get());
                if (((Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)-3, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    if (heat_level.floatValue() == 0.0f) {
                        container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        ((ServerPlayerPatch)container.getExecuter()).modifyLivingMotionByCurrentItem(false);
                    }
                }
                switch ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get())) {
                    case -5: {
                        if (stored_heat_level.floatValue() == 0.0f) {
                            container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)5, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        }
                        if (stored_heat_level.floatValue() == 30.0f) {
                            container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)6, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        }
                        if (stored_heat_level.floatValue() == 70.0f) {
                            container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)7, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        }
                        if (stored_heat_level.floatValue() == 100.0f || heat_level.floatValue() == 0.0f) {
                            container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMED_ATTACK.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEATING_SPEED.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STORED_HEAT_LEVEL.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARTICLE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        }
                        cycle = 0;
                        cycle_modifier = -2;
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STORED_HEAT_LEVEL.get(), (Object)Float.valueOf(stored_heat_level.floatValue() - (float)cycle_modifier), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        break;
                    }
                    case -4: {
                        cycle = 10;
                        cycle_modifier = -1;
                        break;
                    }
                    case -3: {
                        cycle = 20;
                        cycle_modifier = -1;
                        break;
                    }
                    case -2: {
                        cycle = 40;
                        cycle_modifier = -1;
                        break;
                    }
                    case -1: {
                        cycle = 60;
                        cycle_modifier = -1;
                        break;
                    }
                    case 0: {
                        cycle = 40;
                        cycle_modifier = 0;
                        break;
                    }
                    case 1: {
                        cycle = 60;
                        cycle_modifier = 1;
                        break;
                    }
                    case 2: {
                        cycle = 40;
                        cycle_modifier = 1;
                        break;
                    }
                    case 3: {
                        cycle = 20;
                        cycle_modifier = 1;
                        break;
                    }
                    case 4: {
                        cycle = 10;
                        cycle_modifier = 1;
                        break;
                    }
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CYCLE.get(), (Object)(cycle / ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_INFERNIO.get()) > 0 ? 2 : 1)), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                heat_level = Float.valueOf(((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get())).floatValue() + (float)cycle_modifier);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.HEAT_LEVEL.get(), (Object)Float.valueOf(Math.min(Math.max(heat_level.floatValue(), 0.0f), 100.0f)), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        }
    }
}

